/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus;

import com.tmtravlr.lootplusplus.LPPEntityAIRangedAttack;
import com.tmtravlr.lootplusplus.LootPPItems;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.additions.ItemAddedThrowable;
import com.tmtravlr.lootplusplus.commands.CommandSenderGeneric;
import com.tmtravlr.lootplusplus.recipes.LootPPFuelHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class LootPPHelper {
    public static SimpleNetworkWrapper lppNetworkWrapper;
    public static boolean generateFiles;
    public static Random rand;
    public static Comparator<ItemStack> stackComparatorWild;
    public static Comparator<ItemStack> stackComparator;
    public static Comparator<ItemStack> stackComparatorNBT;
    public static Comparator<BlockMeta> blockComparator;
    public static Comparator<NBTTagCompound> comparatorNBT;
    public static LootPPFuelHandler fuelHandler;
    public static boolean loadedDropsAndChestLoot;
    public static boolean loadedRecipes;
    public static boolean gotContents;
    public static boolean gotChestInfo;
    public static boolean gotFortressContents;
    public static boolean gotFurnaceXP;
    public static Field contents;
    public static Field chestInfo;
    public static Field experienceMap;
    public static Set<String> chestTypes;
    public static boolean creepersDropAllRecords;
    public static boolean creepersDropRecords;
    public static TreeMap<NBTTagCompound, Set<ItemStack>> entityDropRemovals;
    public static TreeMap<NBTTagCompound, ArrayList<EntityDropInfo>> entityDropAdditions;
    public static TreeMap<BlockMeta, Set<ItemStack>> blockDropRemovals;
    public static TreeMap<BlockMeta, ArrayList<BlockDropInfo>> blockDropAdditions;
    public static TreeMap<ItemStack, Item.ToolMaterial> addedToolMaterials;
    public static TreeMap<ItemStack, ItemArmor.ArmorMaterial> addedArmourMaterials;
    public IWorldGenerator surfaceGen;
    public static File configFolder;
    public static File idFolder;
    public static CreativeTabs tabLootPP;
    public static CreativeTabs tabLootPPAdditions;
    public static HashMap<String, ArrayList<ItemStack>> additionsToDisplay;
    public static HashMap<String, LPPCreativeTabs> addedTabs;
    public static HashMap<EntityLiving, LPPEntityAIRangedAttack> rangedAIs;
    public static HashMap<EntityLiving, LPPEntityAIRangedAttack> meleeAIs;
    public static HashMap<EntityLiving, EntityAIBase> originalRangedAIs;
    public static HashMap<EntityLiving, EntityAIBase> originalMeleeAIs;
    public static ArrayList<EntityLiving> delayedAIs;

    public LootPPHelper() {
        System.out.println("[Loot++] Attempting to get chest contents.");
        try {
            contents = ChestGenHooks.class.getDeclaredField("contents");
            contents.setAccessible(true);
            gotContents = true;
        }
        catch (Exception e) {
            System.out.println("[Loot++] Couldn't get chest contents! =(");
            e.printStackTrace();
        }
        System.out.println("[Loot++] Attempting to get chest info.");
        try {
            chestInfo = ChestGenHooks.class.getDeclaredField("chestInfo");
            chestInfo.setAccessible(true);
            gotChestInfo = true;
        }
        catch (Exception e) {
            System.out.println("[Loot++] Couldn't get chest info! =(");
            e.printStackTrace();
        }
        System.out.println("[Loot++] Attempting to get furnace experience map.");
        try {
            experienceMap = null;
            try {
                experienceMap = FurnaceRecipes.class.getDeclaredField("field_77605_c");
            }
            catch (Exception e) {
                experienceMap = FurnaceRecipes.class.getDeclaredField("experienceList");
            }
            experienceMap.setAccessible(true);
            gotFurnaceXP = true;
        }
        catch (Exception e) {
            System.out.println("[Loot++] Couldn't get furnace experience map! =(");
            e.printStackTrace();
        }
    }

    public static int compareStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return 0;
        }
        if (stack1 == null && stack2 != null) {
            return 1;
        }
        if (stack1 != null && stack2 == null) {
            return -1;
        }
        if (stack2.func_77973_b() != stack1.func_77973_b()) {
            return Item.func_150891_b((Item)stack2.func_77973_b()) - Item.func_150891_b((Item)stack1.func_77973_b());
        }
        if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
            return 0;
        }
        return stack2.func_77952_i() - stack1.func_77952_i();
    }

    public static boolean isQuickdraw(Enchantment enchant) {
        String name;
        return enchant != null && enchant.func_77320_a() != null && ((name = StatCollector.func_74838_a((String)enchant.func_77320_a().toLowerCase())).contains("quickdraw") || name.contains("drawnback"));
    }

    public static EntityPlayerMP getPlayerByUsername(String name) {
        EntityPlayerMP entityplayermp;
        Iterator iterator = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!(entityplayermp = (EntityPlayerMP)iterator.next()).func_70005_c_().equalsIgnoreCase(name));
        return entityplayermp;
    }

    public static void mergeNBT(NBTTagCompound base, NBTTagCompound other) {
        for (String s : other.func_150296_c()) {
            NBTBase nbtbase = other.func_74781_a(s);
            if (nbtbase.func_74732_a() == 10) {
                if (base.func_150297_b(s, 10)) {
                    NBTTagCompound nbttagcompound1 = base.func_74775_l(s);
                    LootPPHelper.mergeNBT(nbttagcompound1, (NBTTagCompound)nbtbase);
                    continue;
                }
                base.func_74782_a(s, nbtbase.func_74737_b());
                continue;
            }
            base.func_74782_a(s, nbtbase.func_74737_b());
        }
    }

    public static boolean compareNBT(NBTBase part, NBTBase full) {
        if (part == full) {
            return true;
        }
        if (part == null) {
            return true;
        }
        if (full == null) {
            return false;
        }
        if (!part.getClass().equals(full.getClass())) {
            return false;
        }
        if (part instanceof NBTTagCompound) {
            String s;
            NBTBase nbtbase2;
            NBTTagCompound nbttagcompound = (NBTTagCompound)part;
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)full;
            Iterator iterator = nbttagcompound.func_150296_c().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (LootPPHelper.compareNBT(nbtbase2 = nbttagcompound.func_74781_a(s = (String)iterator.next()), nbttagcompound1.func_74781_a(s)));
            return false;
        }
        return part.equals((Object)full);
    }

    public static boolean hasAllTags(NBTBase tagsToCheck, NBTBase baseNBT, boolean compareLists) {
        if (tagsToCheck == baseNBT) {
            return true;
        }
        if (tagsToCheck == null) {
            return true;
        }
        if (baseNBT == null) {
            return false;
        }
        if (!tagsToCheck.getClass().equals(baseNBT.getClass())) {
            return false;
        }
        if (tagsToCheck instanceof NBTTagCompound) {
            String s;
            NBTBase nbtbase3;
            NBTTagCompound nbttagcompound = (NBTTagCompound)tagsToCheck;
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)baseNBT;
            Iterator iterator = nbttagcompound.func_150296_c().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (LootPPHelper.hasAllTags(nbtbase3 = nbttagcompound.func_74781_a(s = (String)iterator.next()), nbttagcompound1.func_74781_a(s), compareLists));
            return false;
        }
        if (tagsToCheck instanceof NBTTagList && compareLists) {
            NBTTagList nbttaglist = (NBTTagList)tagsToCheck;
            NBTTagList nbttaglist1 = (NBTTagList)baseNBT;
            if (nbttaglist.func_74745_c() == 0) {
                return nbttaglist1.func_74745_c() == 0;
            }
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTBase nbtbase2 = nbttaglist.func_179238_g(i);
                boolean flag1 = false;
                for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
                    if (!LootPPHelper.hasAllTags(nbtbase2, nbttaglist1.func_179238_g(j), compareLists)) {
                        continue;
                    }
                    flag1 = true;
                    break;
                }
                if (flag1) continue;
                return false;
            }
            return true;
        }
        return tagsToCheck.equals((Object)baseNBT);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static DropInfo getDropInfo(char type, String dropString, boolean comment, String title) {
        infoToReturn /* !! */  = null;
        switch (type) {
            case 'i': {
                parts = dropString.split("-", 6);
                if (parts.length < 2) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, dropString);
                    return null;
                }
                itemName = parts[0];
                maxString = minString = parts[1];
                weightString = "1";
                metaString = "0";
                nbt = null;
                if (parts.length > 2) {
                    maxString = parts[2];
                }
                if (parts.length > 3) {
                    weightString = parts[3];
                }
                if (parts.length > 4) {
                    metaString = parts[4];
                }
                if (parts.length > 5) {
                    try {
                        nbt = JsonToNBT.func_180713_a((String)parts[5].trim());
                    }
                    catch (NBTException e) {
                        if (!comment) {
                            e.printStackTrace();
                            LootPPNotifier.notifyNBT(comment, title, parts[6].trim(), e.getMessage());
                        }
                        nbt = null;
                    }
                }
                min = 1;
                max = 1;
                weight = 1;
                meta = 0;
                try {
                    min = Integer.valueOf(minString);
                    max = Integer.valueOf(maxString);
                    weight = Integer.valueOf(weightString);
                    meta = Integer.valueOf(metaString);
                }
                catch (Exception e) {
                    if (comment) ** GOTO lbl43
                    System.err.println("[Loot++] Caught an exception while loading a drop addition.");
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, new String[]{minString, maxString, weightString, metaString});
                }
lbl43:
                // 3 sources

                if (min < 0) {
                    min = 0;
                }
                if (max < min) {
                    max = min;
                }
                if (meta < 0) {
                    meta = 0;
                }
                if (weight <= 0) {
                    weight = 1;
                }
                if ((item = (Item)Item.field_150901_e.func_82594_a((Object)itemName)) == null) {
                    LootPPNotifier.notifyNonexistant(comment, title, itemName);
                    return null;
                }
                itemStack = new ItemStack(item);
                if (nbt != null) {
                    itemStack.func_77982_d(nbt);
                }
                itemStack.func_77964_b(meta);
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Created item drop. Item: " + itemStack + ", Min: " + min + ", Max: " + max + ", Weight: " + weight);
                }
                infoToReturn /* !! */  = new DropInfoItem(itemStack, min, max, weight);
                break;
            }
            case 'e': {
                parts = dropString.split("-", 3);
                if (parts.length < 1) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, dropString);
                    return null;
                }
                entityName = parts[0];
                weightString = "1";
                nbtString = "{}";
                if (parts.length > 1) {
                    weightString = parts[1];
                }
                if (parts.length > 2) {
                    nbtString = parts[2];
                }
                nbt = null;
                entityNBT = null;
                try {
                    nbt = JsonToNBT.func_180713_a((String)nbtString);
                    if (nbt != null) {
                        entityNBT = nbt;
                    }
                }
                catch (NBTException e) {
                    if (!comment) {
                        e.printStackTrace();
                        LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                    }
                    entityNBT = null;
                }
                if (entityNBT == null) {
                    entityNBT = new NBTTagCompound();
                }
                weight = 1;
                try {
                    weight = Integer.valueOf(weightString);
                }
                catch (NumberFormatException e) {
                    if (comment) ** GOTO lbl97
                    System.err.println("[Loot++] Caught an exception while loading a drop addition.");
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, weightString);
                }
lbl97:
                // 3 sources

                if (weight <= 0) {
                    weight = 1;
                }
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Created entity drop. Entity: " + entityName + ", NBT Tag: " + entityNBT + ", Weight: " + weight);
                }
                entityNBT.func_74778_a("id", entityName);
                infoToReturn /* !! */  = new DropInfoEntity(entityNBT, weight);
                break;
            }
            case 'c': {
                parts = dropString.split("-", 2);
                if (parts.length < 2) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, dropString);
                    return null;
                }
                weightString = parts[0];
                command = parts[1];
                weight = 1;
                try {
                    weight = Integer.valueOf(weightString);
                }
                catch (NumberFormatException e) {
                    if (comment) ** GOTO lbl120
                    System.err.println("[Loot++] Caught an exception while loading a drop addition.");
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, weightString);
                }
lbl120:
                // 3 sources

                if (weight <= 0) {
                    weight = 1;
                }
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Created command drop. Command: " + command + ", Weight: " + weight);
                }
                infoToReturn /* !! */  = new DropInfoCommand(command, weight);
                break;
            }
            default: {
                LootPPNotifier.notify(comment, title, "Unrecognized drop type character: " + type);
                return null;
            }
        }
        return infoToReturn /* !! */ ;
    }

    public static void dropEntityDropAdditions(LivingDropsEvent event, EntityDropInfo drop, Random rand) {
        if (drop.playerKill && !event.recentlyHit) {
            return;
        }
        float f = rand.nextFloat();
        float f2 = drop.chance;
        float f3 = drop.increasedByLooting ? 0.01f * (float)event.lootingLevel : 0.0f;
        if (f > f2 + f3) {
            return;
        }
        if (drop.dropList == null || drop.dropList.isEmpty()) {
            return;
        }
        ArrayList<DropInfo> listToUse = drop.dropList.get(0);
        int totalWeight = 0;
        for (ArrayList<DropInfo> infoList : drop.dropList) {
            if (infoList.isEmpty() || infoList.get(0) == null) continue;
            totalWeight += infoList.get((int)0).weight;
        }
        if (totalWeight <= 0) {
            System.out.println("[Loot++] Problem while adding drops! Weights should never be 0 or negative!");
            totalWeight = 1;
        }
        int randomInt = rand.nextInt(totalWeight) + 1;
        totalWeight = 0;
        for (ArrayList<DropInfo> infoList : drop.dropList) {
            if (infoList.isEmpty() || infoList.get(0) == null || (totalWeight += infoList.get((int)0).weight) < randomInt) continue;
            listToUse = infoList;
            break;
        }
        for (DropInfo toUse : listToUse) {
            DropInfoCommand infoCommand;
            int i;
            int numToDrop;
            if (toUse.dropType == DropType.ITEM) {
                DropInfoItem infoItem = toUse.getDropInfoItem();
                if (infoItem == null) continue;
                int amountDiff = infoItem.max - infoItem.min;
                if (amountDiff < 0) {
                    amountDiff = 0;
                }
                int numToDrop2 = infoItem.min + (amountDiff == 0 ? 0 : rand.nextInt(amountDiff + 1));
                if (drop.increasedByLooting && event.lootingLevel > 0) {
                    numToDrop2 += rand.nextInt(event.lootingLevel + 1);
                }
                if (infoItem.stack == null) {
                    return;
                }
                ItemStack droppedItem = new ItemStack(infoItem.stack.func_77973_b());
                droppedItem.func_77982_d(infoItem.stack.func_77978_p());
                droppedItem.field_77994_a = numToDrop2;
                droppedItem.func_77964_b(infoItem.stack.func_77952_i());
                EntityItem toDrop = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, droppedItem);
                toDrop.func_174867_a(10);
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Dropping " + numToDrop2 + " of " + droppedItem.func_82833_r());
                }
                event.drops.add(toDrop);
            }
            if (toUse.dropType == DropType.ENTITY) {
                DropInfoEntity infoEntity = toUse.getDropInfoEntity();
                if (infoEntity == null) continue;
                numToDrop = 1;
                if (drop.increasedByLooting && event.lootingLevel > 0) {
                    numToDrop += rand.nextInt(event.lootingLevel + 1);
                }
                for (i = 0; i < numToDrop; ++i) {
                    Entity entity1 = EntityList.func_75615_a((NBTTagCompound)infoEntity.entityTag, (World)event.entity.field_70170_p);
                    if (entity1 instanceof EntityLiving && infoEntity.entityTag.func_150296_c().size() == 1) {
                        ((EntityLiving)entity1).func_180482_a(event.entity.field_70170_p.func_175649_E(event.entity.func_180425_c()), null);
                    }
                    if (entity1 == null) continue;
                    entity1.func_70012_b(event.entity.field_70165_t + rand.nextDouble() * 0.1, event.entity.field_70163_u + rand.nextDouble() * 0.1, event.entity.field_70161_v + rand.nextDouble() * 0.1, entity1.field_70177_z, entity1.field_70125_A);
                    event.entity.field_70170_p.func_72838_d(entity1);
                    Entity entity2 = entity1;
                    if (LootPlusPlusMod.debug) {
                        System.out.println("[Loot++] Spawning Entity: " + infoEntity.entityTag.func_74779_i("id"));
                    }
                    NBTTagCompound nbttagcompound1 = infoEntity.entityTag;
                    while (entity2 != null && nbttagcompound1.func_150297_b("Riding", 10)) {
                        Entity entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound1.func_74775_l("Riding"), (World)event.entity.field_70170_p);
                        if (entity instanceof EntityLiving && infoEntity.entityTag.func_150296_c().size() == 1) {
                            ((EntityLiving)entity).func_180482_a(event.entity.field_70170_p.func_175649_E(event.entity.func_180425_c()), null);
                        }
                        if (entity != null) {
                            entity.func_70012_b(entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                            event.entity.field_70170_p.func_72838_d(entity);
                            entity2.func_70078_a(entity);
                            if (LootPlusPlusMod.debug) {
                                System.out.println("[Loot++] Spawning Entity as Mount: " + nbttagcompound1.func_74779_i("id"));
                            }
                        }
                        entity2 = entity;
                        nbttagcompound1 = nbttagcompound1.func_74775_l("Riding");
                    }
                }
            }
            if (toUse.dropType != DropType.COMMAND || (infoCommand = toUse.getDropInfoCommand()) == null) continue;
            numToDrop = 1;
            if (drop.increasedByLooting && event.lootingLevel > 0) {
                numToDrop += rand.nextInt(event.lootingLevel + 1);
            }
            for (i = 0; i < numToDrop; ++i) {
                try {
                    CommandSenderGeneric sender = new CommandSenderGeneric(event.entity.func_70005_c_(), event.entity.field_70170_p, new Vec3(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v));
                    ICommandManager manager = MinecraftServer.func_71276_C().func_71187_D();
                    manager.func_71556_a((ICommandSender)sender, infoCommand.command);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("[Loot++] Problem while running command from item!");
                    e.printStackTrace();
                }
            }
        }
    }

    public static void removeBlockDrop(BlockEvent.HarvestDropsEvent event, Iterator it, ItemStack stack, ItemStack current) {
        if (LootPPHelper.compareStacks(stack, current) == 0 && (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d() || stack.func_77978_p().equals((Object)current.func_77978_p()))) {
            if (LootPlusPlusMod.debug) {
                System.out.println("[Loot++] Removed Block Drop: " + Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()) + " for block " + event.state);
            }
            it.remove();
        }
    }

    public static void dropBlockDropAdditions(BlockEvent.HarvestDropsEvent event, BlockDropInfo drop, Random rand) {
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Attempting to drop something for: " + Block.field_149771_c.func_177774_c((Object)event.state.func_177230_c()));
        }
        if (drop.playerMined && event.harvester == null) {
            return;
        }
        if (drop.affectedBySilk && !event.isSilkTouching || !drop.affectedBySilk && event.isSilkTouching) {
            return;
        }
        float f = rand.nextFloat();
        float f2 = drop.chance;
        float f3 = drop.increasedByFortune ? 0.01f * (float)event.fortuneLevel : 0.0f;
        if (f > f2 + f3) {
            return;
        }
        if (drop.dropList == null || drop.dropList.isEmpty()) {
            return;
        }
        ArrayList<DropInfo> listToUse = drop.dropList.get(0);
        int totalWeight = 0;
        for (ArrayList<DropInfo> infoList : drop.dropList) {
            if (infoList.isEmpty() || infoList.get(0) == null) continue;
            totalWeight += infoList.get((int)0).weight;
        }
        if (totalWeight <= 0) {
            System.out.println("[Loot++] Problem while adding drops! Weights should never be 0 or negative!");
            totalWeight = 1;
        }
        int randomInt = rand.nextInt(totalWeight) + 1;
        totalWeight = 0;
        for (ArrayList<DropInfo> infoList : drop.dropList) {
            if (infoList.isEmpty() || infoList.get(0) == null || (totalWeight += infoList.get((int)0).weight) < randomInt) continue;
            listToUse = infoList;
            break;
        }
        for (DropInfo toUse : listToUse) {
            DropInfoCommand infoCommand;
            int i;
            int numToDrop;
            if (toUse.dropType == DropType.ITEM) {
                DropInfoItem infoItem = toUse.getDropInfoItem();
                if (infoItem == null) continue;
                int amountDiff = infoItem.max - infoItem.min;
                if (amountDiff < 0) {
                    amountDiff = 0;
                }
                int numToDrop2 = infoItem.min + (amountDiff == 0 ? 0 : rand.nextInt(amountDiff + 1));
                if (drop.increasedByFortune && event.fortuneLevel > 0) {
                    numToDrop2 += rand.nextInt(event.fortuneLevel + 1);
                }
                if (infoItem.stack == null) {
                    return;
                }
                ItemStack droppedItem = new ItemStack(infoItem.stack.func_77973_b());
                droppedItem.func_77982_d(infoItem.stack.func_77978_p());
                droppedItem.field_77994_a = numToDrop2;
                droppedItem.func_77964_b(infoItem.stack.func_77952_i());
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Dropping Item: " + droppedItem);
                }
                event.drops.add(droppedItem);
            }
            if (toUse.dropType == DropType.ENTITY) {
                DropInfoEntity infoEntity = toUse.getDropInfoEntity();
                if (infoEntity == null) continue;
                numToDrop = 1;
                if (drop.increasedByFortune && event.fortuneLevel > 0) {
                    numToDrop += rand.nextInt(event.fortuneLevel + 1);
                }
                for (i = 0; i < numToDrop; ++i) {
                    Entity entity1 = EntityList.func_75615_a((NBTTagCompound)infoEntity.entityTag, (World)event.world);
                    if (entity1 instanceof EntityLiving && infoEntity.entityTag.func_150296_c().size() == 1) {
                        ((EntityLiving)entity1).func_180482_a(event.world.func_175649_E(event.pos), null);
                    }
                    if (entity1 == null) continue;
                    entity1.func_70012_b((double)event.pos.func_177958_n() + 0.5 + rand.nextDouble() * 0.1, (double)event.pos.func_177956_o() + 0.5 + rand.nextDouble() * 0.1, (double)event.pos.func_177952_p() + 0.5 + rand.nextDouble() * 0.1, entity1.field_70177_z, entity1.field_70125_A);
                    event.world.func_72838_d(entity1);
                    Entity entity2 = entity1;
                    if (LootPlusPlusMod.debug) {
                        System.out.println("[Loot++] Spawning Entity: " + infoEntity.entityTag.func_74779_i("id"));
                    }
                    NBTTagCompound nbttagcompound1 = infoEntity.entityTag;
                    while (entity2 != null && nbttagcompound1.func_150297_b("Riding", 10)) {
                        Entity entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound1.func_74775_l("Riding"), (World)event.world);
                        if (entity != null) {
                            entity.func_70012_b(entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                            event.world.func_72838_d(entity);
                            entity2.func_70078_a(entity);
                            if (LootPlusPlusMod.debug) {
                                System.out.println("[Loot++] Spawning Entity as Mount: " + nbttagcompound1.func_74779_i("id"));
                            }
                        }
                        entity2 = entity;
                        nbttagcompound1 = nbttagcompound1.func_74775_l("Riding");
                    }
                }
            }
            if (toUse.dropType != DropType.COMMAND || (infoCommand = toUse.getDropInfoCommand()) == null) continue;
            numToDrop = 1;
            if (drop.increasedByFortune && event.fortuneLevel > 0) {
                numToDrop += rand.nextInt(event.fortuneLevel + 1);
            }
            for (i = 0; i < numToDrop; ++i) {
                try {
                    CommandSenderGeneric sender = new CommandSenderGeneric("Server", event.world, event.pos);
                    ICommandManager manager = MinecraftServer.func_71276_C().func_71187_D();
                    manager.func_71556_a((ICommandSender)sender, infoCommand.command);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("[Loot++] Problem while running command from item!");
                    e.printStackTrace();
                }
            }
        }
    }

    public static void dropThrownDropAdditions(ItemAddedThrowable item, Entity thrown) {
        Random rand = new Random();
        if (rand.nextFloat() > item.chance) {
            return;
        }
        if (item.dropList == null || item.dropList.isEmpty()) {
            return;
        }
        ArrayList<DropInfo> listToUse = item.dropList.get(0);
        int totalWeight = 0;
        for (ArrayList<DropInfo> infoList : item.dropList) {
            if (infoList.isEmpty() || infoList.get(0) == null) continue;
            totalWeight += infoList.get((int)0).weight;
        }
        if (totalWeight <= 0) {
            System.out.println("[Loot++] Problem while adding drops! Weights should never be 0 or negative!");
            totalWeight = 1;
        }
        int randomInt = rand.nextInt(totalWeight) + 1;
        totalWeight = 0;
        for (ArrayList<DropInfo> infoList : item.dropList) {
            if (infoList.isEmpty() || infoList.get(0) == null || (totalWeight += infoList.get((int)0).weight) < randomInt) continue;
            listToUse = infoList;
            break;
        }
        for (DropInfo toUse : listToUse) {
            DropInfoCommand infoCommand;
            if (toUse.dropType == DropType.ITEM) {
                DropInfoItem infoItem = toUse.getDropInfoItem();
                if (infoItem == null) continue;
                int amountDiff = infoItem.max - infoItem.min;
                if (amountDiff < 0) {
                    amountDiff = 0;
                }
                int numToDrop = infoItem.min + (amountDiff == 0 ? 0 : rand.nextInt(amountDiff + 1));
                if (infoItem.stack == null) {
                    return;
                }
                ItemStack droppedItem = new ItemStack(infoItem.stack.func_77973_b());
                droppedItem.func_77982_d(infoItem.stack.func_77978_p());
                droppedItem.field_77994_a = numToDrop;
                droppedItem.func_77964_b(infoItem.stack.func_77952_i());
                EntityItem toDrop = new EntityItem(thrown.field_70170_p, thrown.field_70165_t, thrown.field_70163_u, thrown.field_70161_v, droppedItem);
                toDrop.func_174867_a(10);
                thrown.field_70170_p.func_72838_d((Entity)toDrop);
            }
            if (toUse.dropType == DropType.ENTITY) {
                DropInfoEntity infoEntity = toUse.getDropInfoEntity();
                if (infoEntity == null) continue;
                Entity entity1 = EntityList.func_75615_a((NBTTagCompound)infoEntity.entityTag, (World)thrown.field_70170_p);
                if (entity1 instanceof EntityLiving && infoEntity.entityTag.func_150296_c().size() == 1) {
                    ((EntityLiving)entity1).func_180482_a(thrown.field_70170_p.func_175649_E(thrown.func_180425_c()), null);
                }
                if (entity1 != null) {
                    entity1.func_70012_b(thrown.field_70165_t + rand.nextDouble() * 0.1, thrown.field_70163_u + rand.nextDouble() * 0.1, thrown.field_70161_v + rand.nextDouble() * 0.1, entity1.field_70177_z, entity1.field_70125_A);
                    thrown.field_70170_p.func_72838_d(entity1);
                    Entity entity2 = entity1;
                    if (LootPlusPlusMod.debug) {
                        System.out.println("[Loot++] Spawning Entity: " + infoEntity.entityTag.func_74779_i("id"));
                    }
                    NBTTagCompound nbttagcompound1 = infoEntity.entityTag;
                    while (entity2 != null && nbttagcompound1.func_150297_b("Riding", 10)) {
                        Entity entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound1.func_74775_l("Riding"), (World)thrown.field_70170_p);
                        if (entity instanceof EntityLiving && infoEntity.entityTag.func_150296_c().size() == 1) {
                            ((EntityLiving)entity).func_180482_a(thrown.field_70170_p.func_175649_E(thrown.func_180425_c()), null);
                        }
                        if (entity != null) {
                            entity.func_70012_b(entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                            thrown.field_70170_p.func_72838_d(entity);
                            entity2.func_70078_a(entity);
                            if (LootPlusPlusMod.debug) {
                                System.out.println("[Loot++] Spawning Entity as Mount: " + nbttagcompound1.func_74779_i("id"));
                            }
                        }
                        entity2 = entity;
                        nbttagcompound1 = nbttagcompound1.func_74775_l("Riding");
                    }
                }
            }
            if (toUse.dropType != DropType.COMMAND || (infoCommand = toUse.getDropInfoCommand()) == null) continue;
            try {
                CommandSenderGeneric sender = new CommandSenderGeneric(thrown.func_70005_c_(), thrown.field_70170_p, new Vec3(thrown.field_70165_t, thrown.field_70163_u, thrown.field_70161_v));
                ICommandManager manager = MinecraftServer.func_71276_C().func_71187_D();
                manager.func_71556_a((ICommandSender)sender, infoCommand.command);
            }
            catch (Exception e) {
                System.err.println("[Loot++] Problem while running command from item!");
                e.printStackTrace();
            }
        }
    }

    public static void addAddedBowAIToMob(EntityLiving mob) {
        EntityAITasks.EntityAITaskEntry entry;
        Iterator iterator = mob.field_70714_bg.field_75782_a.iterator();
        int rangedPriority = 2;
        int meleePriority = 2;
        EntityAIBase rangedTask = null;
        EntityAIBase meleeTask = null;
        while (iterator.hasNext()) {
            entry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (!(entry.field_75733_a instanceof EntityAIArrowAttack)) continue;
            rangedPriority = entry.field_75731_b;
            rangedTask = entry.field_75733_a;
            break;
        }
        while (iterator.hasNext()) {
            entry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (!(entry.field_75733_a instanceof EntityAIAttackOnCollide)) continue;
            meleePriority = entry.field_75731_b;
            meleeTask = entry.field_75733_a;
            break;
        }
        LPPEntityAIRangedAttack aiArrow = new LPPEntityAIRangedAttack((IRangedAttackMob)mob, 1.0, 20, 60, 15.0f);
        if (rangedTask instanceof EntityAIArrowAttack) {
            aiArrow.entityMoveSpeed = (Double)ObfuscationReflectionHelper.getPrivateValue(EntityAIArrowAttack.class, (Object)((EntityAIArrowAttack)rangedTask), (String[])new String[]{"entityMoveSpeed", "field_75321_e"});
            aiArrow.baseRangedAttackTime = (Integer)ObfuscationReflectionHelper.getPrivateValue(EntityAIArrowAttack.class, (Object)((EntityAIArrowAttack)rangedTask), (String[])new String[]{"field_96561_g"});
            aiArrow.maxRangedAttackTime = (Integer)ObfuscationReflectionHelper.getPrivateValue(EntityAIArrowAttack.class, (Object)((EntityAIArrowAttack)rangedTask), (String[])new String[]{"maxRangedAttackTime", "field_75325_h"});
            aiArrow.maxAttackDistance = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityAIArrowAttack.class, (Object)((EntityAIArrowAttack)rangedTask), (String[])new String[]{"field_96562_i"})).floatValue();
        }
        if (rangedTask != null) {
            mob.field_70714_bg.func_85156_a(rangedTask);
            originalRangedAIs.put(mob, rangedTask);
        }
        mob.field_70714_bg.func_75776_a(rangedPriority, (EntityAIBase)aiArrow);
        rangedAIs.put(mob, aiArrow);
        if (meleeTask != null) {
            mob.field_70714_bg.func_85156_a(meleeTask);
            originalRangedAIs.put(mob, meleeTask);
            mob.field_70714_bg.func_75776_a(meleePriority, (EntityAIBase)aiArrow);
            meleeAIs.put(mob, aiArrow);
        }
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Added bow task for mob '" + mob + "'.");
        }
    }

    public static void removeAddedBowAIFromMob(EntityLiving mob) {
        EntityAITasks.EntityAITaskEntry entry;
        Iterator iterator = mob.field_70714_bg.field_75782_a.iterator();
        int rangedPriority = 2;
        int meleePriority = 2;
        EntityAIBase rangedTask = rangedAIs.get(mob);
        EntityAIBase meleeTask = meleeAIs.get(mob);
        if (rangedTask != null) {
            while (iterator.hasNext()) {
                entry = (EntityAITasks.EntityAITaskEntry)iterator.next();
                if (entry.field_75733_a != rangedTask) continue;
                rangedPriority = entry.field_75731_b;
                break;
            }
            mob.field_70714_bg.func_85156_a(rangedTask);
        }
        if (meleeTask != null) {
            while (iterator.hasNext()) {
                entry = (EntityAITasks.EntityAITaskEntry)iterator.next();
                if (entry.field_75733_a != meleeTask) continue;
                meleePriority = entry.field_75731_b;
                break;
            }
            mob.field_70714_bg.func_85156_a(meleeTask);
        }
        if (originalRangedAIs.containsKey(mob)) {
            mob.field_70714_bg.func_75776_a(rangedPriority, originalRangedAIs.get(mob));
        }
        if (originalMeleeAIs.containsKey(mob)) {
            mob.field_70714_bg.func_75776_a(meleePriority, originalMeleeAIs.get(mob));
            originalMeleeAIs.remove(mob);
        }
        rangedAIs.remove(mob);
        meleeAIs.remove(mob);
        originalRangedAIs.remove(mob);
        originalMeleeAIs.remove(mob);
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Removed bow task from mob '" + mob + "'.");
        }
    }

    public static void generateLoot(String type, IInventory inventory) {
        try {
            if (chestTypes.contains(type)) {
                int count = ChestGenHooks.getCount((String)type, (Random)rand);
                if (count == 0) {
                    ItemStack itemToGenerate = ChestGenHooks.getOneItem((String)type, (Random)rand);
                    inventory.func_70299_a(0, itemToGenerate);
                } else {
                    WeightedRandomChestContent.func_177630_a((Random)rand, (List)ChestGenHooks.getItems((String)type, (Random)rand), (IInventory)inventory, (int)count);
                }
            }
        }
        catch (Exception e) {
            FMLLog.warning((String)"[Loot++] Caught an exception while generating chest loot.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    static {
        generateFiles = true;
        rand = new Random();
        stackComparatorWild = new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack1, ItemStack stack2) {
                if (stack1 == null && stack2 == null) {
                    return 0;
                }
                if (stack1 == null && stack2 != null) {
                    return 1;
                }
                if (stack1 != null && stack2 == null) {
                    return -1;
                }
                if (stack1.func_77973_b() == null && stack2.func_77973_b() == null) {
                    return 0;
                }
                if (stack1.func_77973_b() == null && stack2.func_77973_b() != null) {
                    return 1;
                }
                if (stack1.func_77973_b() != null && stack2.func_77973_b() == null) {
                    return -1;
                }
                if (stack2.func_77973_b() != stack1.func_77973_b()) {
                    return Item.func_150891_b((Item)stack2.func_77973_b()) - Item.func_150891_b((Item)stack1.func_77973_b());
                }
                if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
                    return 0;
                }
                return stack2.func_77952_i() - stack1.func_77952_i();
            }
        };
        stackComparator = new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack1, ItemStack stack2) {
                if (stack1 == null && stack2 == null) {
                    return 0;
                }
                if (stack1 == null && stack2 != null) {
                    return 1;
                }
                if (stack1 != null && stack2 == null) {
                    return -1;
                }
                if (stack1.func_77973_b() == null && stack2.func_77973_b() == null) {
                    return 0;
                }
                if (stack1.func_77973_b() == null && stack2.func_77973_b() != null) {
                    return 1;
                }
                if (stack1.func_77973_b() != null && stack2.func_77973_b() == null) {
                    return -1;
                }
                if (stack2.func_77973_b() != stack1.func_77973_b()) {
                    return Item.func_150891_b((Item)stack2.func_77973_b()) - Item.func_150891_b((Item)stack1.func_77973_b());
                }
                return stack2.func_77952_i() - stack1.func_77952_i();
            }
        };
        stackComparatorNBT = new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack1, ItemStack stack2) {
                int compareResult = stackComparator.compare(stack1, stack2);
                if (compareResult == 0 && stack1 != null && stack2 != null) {
                    if (stack1.func_77978_p() == null && stack2.func_77978_p() == null) {
                        return 0;
                    }
                    if (stack1.func_77978_p() == null && stack2.func_77978_p() != null) {
                        return 1;
                    }
                    if (stack1.func_77978_p() != null && stack2.func_77978_p() == null) {
                        return -1;
                    }
                    return LootPPHelper.compareNBT((NBTBase)stack2.func_77978_p(), (NBTBase)stack1.func_77978_p()) ? 0 : stack2.func_77978_p().hashCode() - stack1.func_77978_p().hashCode();
                }
                return compareResult;
            }
        };
        blockComparator = new Comparator<BlockMeta>(){

            @Override
            public int compare(BlockMeta blockMeta1, BlockMeta blockMeta2) {
                if (blockMeta1 == null && blockMeta2 == null) {
                    return 0;
                }
                if (blockMeta1 == null && blockMeta2 != null) {
                    return 1;
                }
                if (blockMeta1 != null && blockMeta2 == null) {
                    return -1;
                }
                if (blockMeta1.block == null && blockMeta2.block == null) {
                    return 0;
                }
                if (blockMeta1.block == null && blockMeta2.block != null) {
                    return 1;
                }
                if (blockMeta1.block != null && blockMeta2.block == null) {
                    return -1;
                }
                if (blockMeta2.block != blockMeta1.block) {
                    return Block.field_149771_c.func_177774_c((Object)blockMeta2.block).toString().compareTo(Block.field_149771_c.func_177774_c((Object)blockMeta1.block).toString());
                }
                return blockMeta2.meta - blockMeta1.meta;
            }
        };
        comparatorNBT = new Comparator<NBTTagCompound>(){

            @Override
            public int compare(NBTTagCompound tag1, NBTTagCompound tag2) {
                return LootPPHelper.compareNBT((NBTBase)tag1, (NBTBase)tag2) ? 0 : tag1.hashCode() - tag2.hashCode();
            }
        };
        fuelHandler = new LootPPFuelHandler();
        loadedDropsAndChestLoot = false;
        loadedRecipes = false;
        gotContents = false;
        gotChestInfo = false;
        gotFortressContents = false;
        gotFurnaceXP = false;
        chestTypes = new HashSet<String>();
        creepersDropAllRecords = true;
        creepersDropRecords = true;
        entityDropRemovals = new TreeMap(comparatorNBT);
        entityDropAdditions = new TreeMap(comparatorNBT);
        blockDropRemovals = new TreeMap(blockComparator);
        blockDropAdditions = new TreeMap(blockComparator);
        addedToolMaterials = new TreeMap(stackComparator);
        addedToolMaterials.put(new ItemStack(Item.func_150898_a((Block)Blocks.field_150344_f), 1, Short.MAX_VALUE), Item.ToolMaterial.WOOD);
        addedToolMaterials.put(new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 1, Short.MAX_VALUE), Item.ToolMaterial.STONE);
        addedToolMaterials.put(new ItemStack(Items.field_151042_j, 1, Short.MAX_VALUE), Item.ToolMaterial.IRON);
        addedToolMaterials.put(new ItemStack(Items.field_151043_k, 1, Short.MAX_VALUE), Item.ToolMaterial.GOLD);
        addedToolMaterials.put(new ItemStack(Items.field_151045_i, 1, Short.MAX_VALUE), Item.ToolMaterial.EMERALD);
        Item.ToolMaterial temp = EnumHelper.addToolMaterial((String)"lpp_leather", (int)0, (int)59, (float)2.0f, (float)0.0f, (int)15);
        temp.customCraftingMaterial = Items.field_151116_aA;
        addedToolMaterials.put(new ItemStack(temp.customCraftingMaterial, 1, Short.MAX_VALUE), temp);
        addedArmourMaterials = new TreeMap(stackComparator);
        addedArmourMaterials.put(new ItemStack(Items.field_151116_aA, 1, Short.MAX_VALUE), ItemArmor.ArmorMaterial.LEATHER);
        addedArmourMaterials.put(new ItemStack(Items.field_151042_j, 1, Short.MAX_VALUE), ItemArmor.ArmorMaterial.IRON);
        addedArmourMaterials.put(new ItemStack(Items.field_151043_k, 1, Short.MAX_VALUE), ItemArmor.ArmorMaterial.GOLD);
        addedArmourMaterials.put(new ItemStack(Items.field_151045_i, 1, Short.MAX_VALUE), ItemArmor.ArmorMaterial.DIAMOND);
        temp = EnumHelper.addArmorMaterial((String)"lpp_wood", (String)"lpp_wood", (int)5, (int[])new int[]{1, 3, 2, 1}, (int)15);
        temp.customCraftingMaterial = Item.func_150898_a((Block)Blocks.field_150344_f);
        addedArmourMaterials.put(new ItemStack(temp.customCraftingMaterial, 1, Short.MAX_VALUE), (ItemArmor.ArmorMaterial)temp);
        temp = EnumHelper.addArmorMaterial((String)"lpp_stone", (String)"lpp_stone", (int)5, (int[])new int[]{1, 3, 2, 1}, (int)15);
        temp.customCraftingMaterial = Item.func_150898_a((Block)Blocks.field_150347_e);
        addedArmourMaterials.put(new ItemStack(temp.customCraftingMaterial, 1, Short.MAX_VALUE), (ItemArmor.ArmorMaterial)temp);
        tabLootPP = new CreativeTabs("tabLootPP"){

            public Item func_78016_d() {
                return LootPPItems.generalDummyIcon;
            }
        };
        tabLootPPAdditions = new CreativeTabs("tabLootPPAdditions"){

            public Item func_78016_d() {
                return LootPPItems.additionsDummyIcon;
            }

            public boolean hasSearchBar() {
                return true;
            }
        }.func_78025_a("item_search.png");
        additionsToDisplay = new HashMap();
        addedTabs = new HashMap();
        rangedAIs = new HashMap();
        meleeAIs = new HashMap();
        originalRangedAIs = new HashMap();
        originalMeleeAIs = new HashMap();
        delayedAIs = new ArrayList();
    }

    public static class LPPCreativeTabs
    extends CreativeTabs {
        public LPPCreativeTabs(String label) {
            super(label);
        }

        public String func_78024_c() {
            return this.func_78013_b();
        }

        public Item func_78016_d() {
            return this.func_151244_d().func_77973_b();
        }

        public ItemStack func_151244_d() {
            ArrayList<ItemStack> additions = additionsToDisplay.get(this.func_78013_b());
            if (additions != null && !additions.isEmpty()) {
                return additions.get(0);
            }
            return new ItemStack(LootPPItems.additionsDummyIcon);
        }
    }

    public static class BlockDropInfo {
        public float chance;
        public boolean playerMined;
        public boolean affectedBySilk;
        public boolean increasedByFortune;
        public ArrayList<ArrayList<DropInfo>> dropList;

        public BlockDropInfo(float probability, boolean dropOnPlayerKill, boolean silkAffects, boolean fortuneIncreases) {
            this.chance = probability;
            this.playerMined = dropOnPlayerKill;
            this.affectedBySilk = silkAffects;
            this.increasedByFortune = fortuneIncreases;
            this.dropList = new ArrayList();
        }
    }

    public static class EntityDropInfo {
        public float chance;
        public boolean playerKill;
        public boolean increasedByLooting;
        public ArrayList<ArrayList<DropInfo>> dropList;

        public EntityDropInfo(float probability, boolean dropOnPlayerKill, boolean lootingIncreases) {
            this.chance = probability;
            this.playerKill = dropOnPlayerKill;
            this.increasedByLooting = lootingIncreases;
            this.dropList = new ArrayList();
        }
    }

    public static class DropInfoCommand
    extends DropInfo {
        public String command;

        public DropInfoCommand(String commandToSet, int dropWeight) {
            this.command = commandToSet;
            this.weight = dropWeight;
            this.dropType = DropType.COMMAND;
        }
    }

    public static class DropInfoItem
    extends DropInfo {
        public ItemStack stack;
        public int min;
        public int max;

        public DropInfoItem(ItemStack iStack, int amountMin, int amountMax, int dropWeight) {
            this.stack = iStack;
            this.min = amountMin;
            this.max = amountMax;
            this.weight = dropWeight;
            this.dropType = DropType.ITEM;
        }

        public String toString() {
            return "{ Type: " + this.dropType.name() + ", Weight: " + this.weight + ", Min: " + this.min + ", Max: " + this.max + ", Item: " + this.stack + "}";
        }
    }

    public static class DropInfoEntity
    extends DropInfo {
        public NBTTagCompound entityTag;

        public DropInfoEntity(NBTTagCompound eToSpawn, int dropWeight) {
            this.entityTag = eToSpawn;
            this.weight = dropWeight;
            this.dropType = DropType.ENTITY;
        }

        public String toString() {
            return "{ Type: " + this.dropType.name() + ", Weight: " + this.weight + ", Entity Tag: " + this.entityTag + "}";
        }
    }

    public static class DropInfo {
        public DropType dropType;
        public int weight;

        public DropInfoEntity getDropInfoEntity() {
            return this instanceof DropInfoEntity ? (DropInfoEntity)this : null;
        }

        public DropInfoItem getDropInfoItem() {
            return this instanceof DropInfoItem ? (DropInfoItem)this : null;
        }

        public DropInfoCommand getDropInfoCommand() {
            return this instanceof DropInfoCommand ? (DropInfoCommand)this : null;
        }
    }

    public static enum DropType {
        ITEM('i'),
        ENTITY('e'),
        COMMAND('c');

        public final char charType;

        private DropType(char charTypeToSet) {
            this.charType = charTypeToSet;
        }
    }

    public static class BlockMeta {
        public Block block;
        public int meta;

        public BlockMeta(Block blockToSet, int metaToSet) {
            this.block = blockToSet;
            this.meta = metaToSet;
        }

        public BlockMeta(IBlockState state) {
            this.block = state.func_177230_c();
            this.meta = this.block.func_176201_c(state);
        }

        public String toString() {
            return "{ Block: " + Block.field_149771_c.func_177774_c((Object)this.block) + ", Metadata: " + this.meta + " }";
        }
    }
}

