/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.additions;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.additions.EntityAddedThrownItem;
import com.tmtravlr.lootplusplus.additions.ItemAddedThrowable;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAddedGun
extends ItemBow {
    public static final float POWER_MULTIPLIER = 1.25f;
    public static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#.###");
    public String displayName = "";
    public float baseDamage = 0.0f;
    public int waitTime = 20;
    public int bulletCount = 1;
    public int enchantability = 1;
    public ItemStack repairStack;
    public Item ammoItem;
    public ItemAddedThrowable shotItem;
    public String shootingSound;

    public ItemAddedGun(String display, float damage, int time, int durability, int bullets, int enchant, ItemStack repairItem, Item ammo, ItemAddedThrowable shot, String sound) {
        this.func_77637_a(LootPPHelper.tabLootPPAdditions);
        this.func_77656_e(durability);
        this.baseDamage = damage;
        this.waitTime = time;
        this.bulletCount = bullets;
        this.enchantability = enchant;
        this.repairStack = repairItem;
        this.displayName = display;
        this.ammoItem = ammo;
        this.shotItem = shot;
        this.shootingSound = sound;
    }

    public int getWaitTime(ItemStack stack) {
        int time = this.waitTime;
        if (stack == null || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("ench")) {
            return this.waitTime;
        }
        NBTTagList enchList = stack.func_77978_p().func_150295_c("ench", 10);
        int size = enchList.func_74745_c();
        for (int i = 0; i < size; ++i) {
            int lvl;
            NBTTagCompound tag = enchList.func_150305_b(i);
            int id = tag.func_74762_e("id");
            Enchantment enchant = Enchantment.func_180306_c((int)id);
            if (!LootPPHelper.isQuickdraw(enchant) || (lvl = tag.func_74762_e("lvl")) <= 0) continue;
            time = time / 2 + time / (2 * (lvl + 1));
        }
        return time;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74838_a((String)this.displayName).trim();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            boolean flag;
            int tickStamp = this.getTimeStamp(stack);
            if (tickStamp <= player.field_70173_aa && player.field_70173_aa - tickStamp < this.getWaitTime(stack)) {
                return stack;
            }
            boolean bl = flag = player.field_71075_bZ.field_75098_d || this.bulletCount == 0 || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
            if (flag || player.field_71071_by.func_146028_b(this.ammoItem)) {
                int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
                int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack);
                for (int i = 0; i < (this.bulletCount < 1 ? 1 : this.bulletCount) && (flag || player.field_71071_by.func_146028_b(this.ammoItem)); ++i) {
                    if (!flag) {
                        player.field_71071_by.func_146026_a(this.ammoItem);
                    }
                    if (world.field_72995_K) continue;
                    EntityAddedThrownItem.nextVelocity = this.shotItem.velocity;
                    EntityAddedThrownItem thrown = new EntityAddedThrownItem(world, (EntityLivingBase)player, this.shotItem);
                    if (thrown.damage > 0.0f) {
                        thrown.damage += (float)power * 1.25f + this.baseDamage;
                    }
                    if (punch > 0) {
                        thrown.punch = punch;
                    }
                    world.func_72838_d((Entity)thrown);
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
                world.func_72956_a((Entity)player, this.shootingSound, 1.0f, 1.0f / (0.8f + field_77697_d.nextFloat() * 0.4f));
                this.setTimeStamp(stack, player.field_70173_aa);
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        int power;
        float damage;
        tooltip.add("");
        if (this.baseDamage > 0.0f && (damage = this.baseDamage + this.shotItem.damage + (float)(power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) * 1.25f) != 0.0f) {
            tooltip.add(EnumChatFormatting.BLUE + "+" + DECIMALFORMAT.format(damage) + StatCollector.func_74838_a((String)"gun.info.rangeddamage"));
        }
        tooltip.add(EnumChatFormatting.BLUE + "+" + DECIMALFORMAT.format((float)this.getWaitTime(stack) / 20.0f) + StatCollector.func_74838_a((String)"gun.info.reloadtime"));
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public int getTimeStamp(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74762_e("TickStamp");
    }

    public void setTimeStamp(ItemStack stack, int ticks) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("TickStamp", ticks);
    }

    private String getName() {
        return "lootplusplus:" + this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repairMaterial) {
        return this.repairStack != null && repairMaterial != null && this.repairStack.func_77973_b() == repairMaterial.func_77973_b() && (this.repairStack.func_77952_i() == Short.MAX_VALUE || this.repairStack.func_77952_i() == repairMaterial.func_77952_i());
    }
}

