/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.ItemDummyTab;
import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ConfigLoaderGeneral
extends ConfigLoader {
    public static ConfigLoaderGeneral instance = new ConfigLoaderGeneral();

    ConfigLoaderGeneral() {
        this.namesToExtras.put("creative_menu_additions", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "general";
    }

    public void loadGeneral() {
        Configuration general = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        general.load();
        LootPlusPlusMod.debug = general.getBoolean("Display debug output?", "debug", false, "");
        LootPPHelper.generateFiles = general.getBoolean("Load info files?", "files", true, "");
        general.save();
    }

    public void loadCreativeAdditions() {
        Configuration general = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        general.load();
        String[] creativeAdditions = general.getStringList("creative_menu_additions", "creative_menu", new String[0], "You can add items to the creative menu here in the format:\n\n      <Creative tab name>_____<Item name>_____<Metadata (optional)>_____<NBT tag (optional)>\n\nFor instance, you could add a wither skeleton spawn egg by putting:\n\n      Custom Spawn Eggs_____lootplusplus:custom_spawn_egg_____0_____{EntityName:Skeleton, EntityData:{SkeletonType:1}, display:{Name:\"\u00a7rSpawn Wither Skeleton\"}}\n");
        ArrayList<String> additionsList = ConfigExtrasLoader.combineLists(creativeAdditions, (ArrayList)this.namesToExtras.get("creative_menu_additions"));
        for (int index = 0; index < additionsList.size(); ++index) {
            ArrayList<Object> additions;
            Object itemObj;
            String nbtString;
            int meta;
            String itemName;
            String tabName;
            String[] parts;
            boolean comment;
            String title;
            block14: {
                String entry = (String)additionsList.get(index);
                title = this.getFileName() + ".cfg 'creative_menu_additions' #" + (index + 1);
                comment = false;
                if (entry.length() > 0) {
                    boolean bl = comment = entry.charAt(0) == '#';
                }
                if ((parts = entry.split("_____")).length < 2) {
                    if (entry.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                    continue;
                }
                tabName = parts[0];
                itemName = parts[1];
                meta = 0;
                nbtString = "{}";
                if (parts.length > 2) {
                    try {
                        meta = Integer.valueOf(parts[2]);
                    }
                    catch (NumberFormatException e) {
                        if (comment) break block14;
                        System.err.println("[Loot++] Caught exception while trying to add a bow " + itemName);
                        e.printStackTrace();
                        LootPPNotifier.notifyNumber(comment, title, parts[2]);
                    }
                }
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)itemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, itemName);
                continue;
            }
            Item item = (Item)itemObj;
            NBTTagCompound nbt = null;
            if (parts.length > 3) {
                nbtString = parts[3];
            }
            if (nbtString != null && !nbtString.equals("{}")) {
                try {
                    NBTTagCompound nbtBase;
                    nbt = nbtBase = JsonToNBT.func_180713_a((String)nbtString.trim());
                }
                catch (NBTException e) {
                    if (!comment) {
                        e.printStackTrace();
                        LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                    }
                    nbt = null;
                }
            }
            ItemStack itemStack = new ItemStack(item, 1, meta);
            if (nbt != null) {
                itemStack.func_77982_d(nbt);
            }
            if ((additions = LootPPHelper.additionsToDisplay.get(tabName)) == null) {
                additions = new ArrayList();
            }
            additions.add(itemStack);
            LootPPHelper.additionsToDisplay.put(tabName, additions);
            if (LootPPHelper.addedTabs.containsKey(tabName)) continue;
            LootPPHelper.addedTabs.put(tabName, new LootPPHelper.LPPCreativeTabs(tabName));
            ItemDummyTab dummyTab = new ItemDummyTab(tabName);
            GameRegistry.registerItem((Item)dummyTab, (String)("tab_" + tabName.replace(' ', '_')));
        }
        general.save();
    }
}

