/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPItems;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.additions.ItemAdded;
import com.tmtravlr.lootplusplus.additions.ItemAddedArmour;
import com.tmtravlr.lootplusplus.additions.ItemAddedAxe;
import com.tmtravlr.lootplusplus.additions.ItemAddedBow;
import com.tmtravlr.lootplusplus.additions.ItemAddedFood;
import com.tmtravlr.lootplusplus.additions.ItemAddedGun;
import com.tmtravlr.lootplusplus.additions.ItemAddedHoe;
import com.tmtravlr.lootplusplus.additions.ItemAddedMultiTool;
import com.tmtravlr.lootplusplus.additions.ItemAddedPickaxe;
import com.tmtravlr.lootplusplus.additions.ItemAddedShovel;
import com.tmtravlr.lootplusplus.additions.ItemAddedSword;
import com.tmtravlr.lootplusplus.additions.ItemAddedThrowable;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ConfigLoaderItems
extends ConfigLoader {
    public static ConfigLoaderItems instance = new ConfigLoaderItems();

    ConfigLoaderItems() {
        this.namesToExtras.put("generic_items", new ArrayList());
        this.namesToExtras.put("foods", new ArrayList());
        this.namesToExtras.put("thrown", new ArrayList());
        this.namesToExtras.put("bows", new ArrayList());
        this.namesToExtras.put("guns", new ArrayList());
        this.namesToExtras.put("multitools", new ArrayList());
        this.namesToExtras.put("materials", new ArrayList());
        this.namesToExtras.put("swords", new ArrayList());
        this.namesToExtras.put("pickaxes", new ArrayList());
        this.namesToExtras.put("axes", new ArrayList());
        this.namesToExtras.put("shovels", new ArrayList());
        this.namesToExtras.put("hoes", new ArrayList());
        this.namesToExtras.put("helmets", new ArrayList());
        this.namesToExtras.put("chestplates", new ArrayList());
        this.namesToExtras.put("leggings", new ArrayList());
        this.namesToExtras.put("boots", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "item_additions";
    }

    public void loadItemAdditions() {
        int durability;
        boolean shines;
        String displayName;
        String itemName;
        String[] parts;
        boolean comment;
        String title;
        String info;
        int index;
        Configuration itemConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        itemConfig.load();
        Property temp = itemConfig.get("add_generic", "generic_items", new String[0]);
        temp.comment = "Add generic items, which have no special functions, but are good for\nintermediate crafting ingredients and such, in the format:\n\n      <Item name>_____<Item display name>_____<Shines (true or false, optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- If shines is true, the item will have the glow like enchanted\nitems, nether stars, etc.\n\nSo for instance to add a ruby, you could put\n\n      ruby_____Ruby\n\nAssuming you had an item model ruby.json in the folder mentioned above.\n";
        ArrayList<String> infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("generic_items"));
        for (index = 0; index < infoList.size(); ++index) {
            info = infoList.get(index);
            title = this.getFileName() + ".cfg 'generic_items' #" + (index + 1);
            comment = false;
            if (info.length() > 0) {
                boolean bl = comment = info.charAt(0) == '#';
            }
            if (comment) continue;
            parts = info.split("_____");
            if (parts.length < 2) {
                if (info.equals("")) continue;
                LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                continue;
            }
            itemName = parts[0];
            displayName = parts[1];
            shines = false;
            if (parts.length > 2) {
                shines = Boolean.valueOf(parts[2]);
            }
            Item generic = new ItemAdded(shines, displayName).func_77655_b(itemName);
            LootPPItems.addedItems.add(generic);
            GameRegistry.registerItem((Item)generic, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(generic);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom generic item: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("add_foods", "foods", new String[0]);
        temp.comment = "Add food items, which can be eaten and restore hunger. Add them in the format:\n\n      <Item name>_____<Item display name>_____<Shines (true or false)>_____<Food restored>_____<Saturation>_____<Wolves eat (true or false)>_____<Always edible (true or false)>_____<Time to eat>_____<Potion effects given (optional)>\n\nWhere: \n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The texture location is the name of the png file you place in the resource \npack, in the 'assets/minecraft/items' folder without the .png.\n- If shines is true, the food item will shine like enchanted items.\n- The food restored is the amount of food restored in half bars.\n- The saturation is how much saturation is given by the food (time until you\nget hungry again).- If wolves eat is true, wolves can eat the food.\n- If always edible is true, you can eat the food even if you're not hungry.\n- Time to eat is how long it takes to eat the item (32 normally).\n- Finally the potions the food gives you is a list of potion effects in the format:\n\n      ..._____<Potion effect id>-<Potion duration>-<Potion level (0 is 1)>-<Probability (between 0.0 and 1.0)>-<Particle type (normal, faded, or none)>_____...\n\nFor reference, some of the vanilla foods could be recreated with:\n\nSteak:                  cooked_beef_____Steak_____false_____8_____0.8_____true_____false_____32\nRotten Flesh:           rotten_flesh_____Rotten Flesh_____false_____4_____0.1_____true_____false_____32_____17-1200-0-0.8-normal\nGolden Apple:           golden_apple_____Golden Apple_____false_____4_____1.2_____false_____true_____32_____10-100-0-1.0-normal_____22-2400-0-1.0-normal\nEnchanted Golden Apple: enchanted_golden_apple_____Enchanted Golden Apple_____true_____4_____1.2_____false_____true_____32_____10-600-4-1.0-normal_____22-2400-0-1.0-normal_____11-6000-0-1.0-normal_____12-6000-0-1.0-normal\n\nAs an example, if you wanted to add an item like a slice of pizza, you could add:\n\n      pizza_slice_____Pizza Slice_____false_____6_____0.6_____false_____false_____32\n\nOr if you wanted to add 'ruby' apples like the vanilla golden ones but with\nhealth boost instead of absorption, you could add:\n\n      ruby_apple_____\u00a7bRuby Apple_____false_____4_____1.2_____false_____true_____32_____10-150-1-1.0-normal_____21-2400-1-1.0-normal\n      enchanted_ruby_apple_____\u00a7dRuby Apple_____true_____4_____1.2_____false_____true_____32_____10-600-4-1.0-normal_____21-2400-4-1.0-normal_____11-6000-0-1.0-normal_____12-6000-0-1.0-normal";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("foods"));
        for (index = 0; index < infoList.size(); ++index) {
            int eatTime;
            boolean alwaysEdible;
            boolean wolvesEat;
            float saturationRestored;
            int foodRestored;
            block153: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'foods' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 8) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName = parts[1];
                shines = false;
                foodRestored = 4;
                saturationRestored = 0.4f;
                wolvesEat = false;
                alwaysEdible = false;
                eatTime = 32;
                try {
                    shines = Boolean.valueOf(parts[2]);
                    foodRestored = Integer.valueOf(parts[3]);
                    saturationRestored = Float.valueOf(parts[4]).floatValue();
                    wolvesEat = Boolean.valueOf(parts[5]);
                    alwaysEdible = Boolean.valueOf(parts[6]);
                    eatTime = Integer.valueOf(parts[7]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block153;
                    System.err.println("[Loot++] Caught an exception while trying to create a food item " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[2], parts[3], parts[4], parts[5], parts[6], parts[7]);
                }
            }
            Item food = new ItemAddedFood(foodRestored, saturationRestored, wolvesEat, alwaysEdible, eatTime, shines, displayName).func_77655_b(itemName);
            LootPPItems.addedItems.add(food);
            GameRegistry.registerItem((Item)food, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(food);
            if (parts.length > 8) {
                for (int i = 8; i < parts.length; ++i) {
                    String particles;
                    float probability;
                    int potionAmplifier;
                    int potionDuration;
                    Potion potion;
                    block154: {
                        String[] potionParts = parts[i].split("-");
                        if (potionParts.length != 5) {
                            LootPPNotifier.notifyWrongNumberOfParts(comment, title, parts[i]);
                            continue;
                        }
                        potion = Potion.func_180142_b((String)potionParts[0]);
                        potionDuration = 100;
                        potionAmplifier = 0;
                        probability = 1.0f;
                        particles = potionParts[4];
                        if (potion == null) {
                            try {
                                int effectId = Integer.valueOf(potionParts[0]);
                                potion = Potion.field_76425_a[effectId];
                            }
                            catch (NumberFormatException effectId) {
                                // empty catch block
                            }
                            if (potion == null) {
                                LootPPNotifier.notify(comment, title, "Couldn't find potion effect '" + potionParts[0] + "'");
                                continue;
                            }
                        }
                        try {
                            potionDuration = Integer.valueOf(potionParts[1]);
                            potionAmplifier = Integer.valueOf(potionParts[2]);
                            probability = Float.valueOf(potionParts[3]).floatValue();
                        }
                        catch (NumberFormatException e) {
                            if (comment) break block154;
                            System.err.println("[Loot++] Caught an exception while trying to create a food item " + itemName);
                            e.printStackTrace();
                            LootPPNotifier.notifyNumber(comment, title, potionParts[1], potionParts[2], potionParts[3]);
                        }
                    }
                    PotionEffect effect = new PotionEffect(potion.func_76396_c(), potionDuration, potionAmplifier);
                    ((ItemAddedFood)food).addPotionEffect(effect, probability, particles);
                }
            }
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom food item: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("add_thrown", "thrown", new String[0]);
        temp.comment = "Add thrown items, which you can throw with right click, in the format:\n\n      <Item name>_____<Item display name>_____<Shines (true or false)>_____<Damage>_____<Velocity>_____<Gravity>_____<Inaccuracy>_____<Drop Chance (Optional)>_____<Drops (Optional)>\n\nWhere:\n- The <Item name> will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The <Item display name> is what people will see in-game.\n- If <Shines> is true, the item will have the glow like enchanted\nitems, nether stars, etc.\n- the <Damage> is how much damage the thrown item will when hitting an entity.\n- The <Velocity> is how fast the thrown item will travel.\n- The <Gravity> is how much the item is affected by gravity.\n- The <Innacuracy> is how much the thrown item will 'wobble'.\n- The <Drop chance> is the chance that a drop will happen, from 0.0-1.0.\n- The <Drops> is a list of drops the item will drop when it lands\nin the same format as block and entity drops:\n\n      ..._____i-<Item id>-<Min>-<Max>-<Weight (optional)>-<Metadata (optional)>-<NBT Tag (optional)>_____...\n\nfor items, or:\n\n      ..._____e-<Entity id>-<Weight (optional)>-<NBT tag (optional)>_____...\n\nfor entities, or:\n\n      ..._____c-<Weight>-<Command>_____...\n\nfor commands, where:\n- The <Item id> or<Entity id> is the string id for the item or entity.- The <Weight> is the chance that this drop will be chosen out of all the combined weights.\nMake sure it's bigger than 0. If you don't specify the weight, it will default to 1.\n- And the <Command> is a command you want to run where the block breaks.\n\nAlso, you can put %%%%% between drops to create groups of drops. In a group, only the weight of\nthe first drop will count.\n\nSome examples of default items could be:\n\n      snowball: snowball_____Snowball_____false_____0.0_____1.5_____0.03_____0.0\n      egg: egg_____Egg_____false_____0.0_____1.5_____0.03_____0.0_____0.12_____e-Chicken-31-{Age:-24000}_____e-Chicken-1-{Age:-24000}%%%%%e-Chicken-1-{Age:-24000}%%%%%e-Chicken-1-{Age:-24000}%%%%%e-Chicken-1-{Age:-24000}\n      xp bottle: experience_bottle_____Bottle o' Enchanting_____true_____0.0_____0.7_____0.07_____-20.0_____1.0_____e-XPOrb-1-{Value:3}%%%%%c-1-playsound game.potion.smash @a ~ ~ ~_____e-XPOrb-1-{Value:3}%%%%%e-XPOrb-1-{Value:3}%%%%%c-1-playsound game.potion.smash @a ~ ~ ~_____e-XPOrb-1-{Value:7}%%%%%e-XPOrb-1-{Value:2}%%%%%c-1-playsound game.potion.smash @a ~ ~ ~_____e-XPOrb-1-{Value:7}%%%%%e-XPOrb-1-{Value:3}%%%%%e-XPOrb-1-{Value:1}%%%%%c-1-playsound game.potion.smash @a ~ ~ ~\n\nAs an example, if you wanted to add a 'grenade' that turns into TNT:\n\n      grenade_____Grenade_____false_____0.0_____1.0_____0.05_____0.0_____1.0_____e-PrimedTnt-1-{Fuse:40}\n\nAssuming you had an item model grenade.json in the folder mentioned above.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("thrown"));
        for (index = 0; index < infoList.size(); ++index) {
            ArrayList<ArrayList<LootPPHelper.DropInfo>> thrownDrops;
            float chance;
            float inaccuracy;
            float gravity;
            float velocity;
            float damage;
            block155: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'thrown' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 7) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName = parts[1];
                shines = false;
                damage = 0.0f;
                velocity = 1.5f;
                gravity = 0.03f;
                inaccuracy = 0.0f;
                chance = 0.0f;
                thrownDrops = new ArrayList<ArrayList<LootPPHelper.DropInfo>>();
                try {
                    shines = Boolean.valueOf(parts[2]);
                    damage = Float.valueOf(parts[3]).floatValue();
                    velocity = Float.valueOf(parts[4]).floatValue();
                    gravity = Float.valueOf(parts[5]).floatValue();
                    inaccuracy = Float.valueOf(parts[6]).floatValue();
                    if (parts.length > 7) {
                        chance = Float.valueOf(parts[7]).floatValue();
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block155;
                    System.err.println("[Loot++] Caught exception while trying to add a throwable item " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[2] + ", " + parts[3] + ", " + parts[4] + ", " + parts[5] + ", " + parts[6] + (parts.length > 7 ? ", " + parts[7] : ""));
                }
            }
            for (int i = 8; i < parts.length; ++i) {
                String dropString = parts[i];
                if (dropString.equals("")) continue;
                String[] subParts = dropString.split("%%%%%");
                ArrayList<LootPPHelper.DropInfo> dropList = new ArrayList<LootPPHelper.DropInfo>();
                for (int j = 0; j < subParts.length; ++j) {
                    char type;
                    LootPPHelper.DropInfo dropInfo;
                    String subString = subParts[j];
                    int dashIndex = subString.indexOf("-");
                    if (dashIndex < 0 || (dropInfo = LootPPHelper.getDropInfo(type = subString.charAt(0), subString.substring(dashIndex + 1), comment, title)) == null) continue;
                    dropList.add(dropInfo);
                }
                if (dropList.isEmpty()) continue;
                thrownDrops.add(dropList);
            }
            Item throwable = new ItemAddedThrowable(shines, damage, velocity, gravity, inaccuracy, chance, thrownDrops, displayName).func_77655_b(itemName);
            LootPPItems.addedItems.add(throwable);
            GameRegistry.registerItem((Item)throwable, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(throwable);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom thrown item: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_bows", "bows", new String[0]);
        temp.comment = "Add bows, which act like vanilla bows. Add them in the format:\n\n      <Item name>_____<Item display name>_____<Durability>_____<Base damage>_____<Draw time>_____<# of arrows shot>_____<Enchantability>_____<Repair item name (write none for none)>_____<Repair item meta (-1 for any)>_____<Custom ammo item (optional, must be throwable added item, defaults to minecraft:arrow)>_____<Custom Shooting Sound (optional, defaults to random.bow)>\n\nWhere: \n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). You should add 4 model files for the item\nin the resource pack at assets/lootplusplus/models/item/<Item name>,\nassets/lootplusplus/models/item/<Item name>_pulling_0,\nassets/lootplusplus/models/item/<Item name>_pulling_1, and\nassets/lootplusplus/models/item/<Item name>_pulling_2.\n- The item display name is what people will see in-game. \n- The durability is the durability of the bow.\n- The base damage is the amount of damage added to any arrows you shoot.\n- The draw time is how fast you can draw the bow.\n- The enchantability is how enchantable the bow is.\n- The repair item is what you can repair the bow with ('none' if not repairable).\n- The repair meta is the metadata for the repair item.\n- The custom ammo item is the item this bow will shoot. Leave it out or\nput minecraft:arrow for the bow to shoot arrows. If you include it, it\nmust be a throwable item you added above.\n- The custom shooting sound is what sound the bow makes when you shoot it.\n\nFor reference the vanilla bow would be something like:\n\n      bow_____Bow_____384_____0.0_____20_____1_____1_____none_____-1\n\nIf you wanted to add ruby reinforced bows, regular and double, you could put:\n\n      ruby_bow_____Ruby Reinforced Bow_____1000_____2.0_____22_____1_____5_____lootplusplus:ruby_____-1\n      ruby_double_bow_____Double Ruby Reinforced Bow_____1500_____2.0_____25_____2_____10_____lootplusplus:ruby_bow_____-1\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("bows"));
        for (index = 0; index < infoList.size(); ++index) {
            String soundName;
            String ammoName;
            int repairMeta;
            String repairItemName;
            int enchantability;
            int arrowCount;
            int drawSpeed;
            float baseDamage;
            block156: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'bows' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 9) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName = parts[1];
                durability = 384;
                baseDamage = 0.0f;
                drawSpeed = 72000;
                arrowCount = 1;
                enchantability = 1;
                repairItemName = parts[7];
                repairMeta = Short.MAX_VALUE;
                ammoName = parts.length > 9 ? parts[9] : "minecraft:arrow";
                soundName = parts.length > 10 ? parts[10] : "random.bow";
                try {
                    durability = Integer.valueOf(parts[2]);
                    baseDamage = Float.valueOf(parts[3]).floatValue();
                    drawSpeed = Integer.valueOf(parts[4]);
                    arrowCount = Integer.valueOf(parts[5]);
                    enchantability = Integer.valueOf(parts[6]);
                    repairMeta = Integer.valueOf(parts[8]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block156;
                    System.err.println("[Loot++] Caught exception while trying to add a bow " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[2], parts[3], parts[4], parts[5], parts[6], parts[8]);
                }
            }
            if (repairMeta < 0) {
                repairMeta = Short.MAX_VALUE;
            }
            if (durability <= 0) {
                durability = 1;
            }
            if (baseDamage < 0.0f) {
                baseDamage = 0.0f;
            }
            if (enchantability < 1) {
                enchantability = 1;
            }
            Item repairItem = null;
            if (!repairItemName.equals("none") && (repairItem = Item.func_111206_d((String)repairItemName)) == null) {
                LootPPNotifier.notifyNonexistant(comment, title, repairItemName);
                continue;
            }
            Item ammoItem = Item.func_111206_d((String)ammoName);
            if (ammoItem != Items.field_151032_g && !(ammoItem instanceof ItemAddedThrowable)) {
                LootPPNotifier.notify(comment, title, "No throwable Loot++ item found called " + ammoName);
                continue;
            }
            ItemStack repairStack = null;
            if (repairItem != null) {
                repairStack = new ItemStack(repairItem, 1, repairMeta);
            }
            Item bow = new ItemAddedBow(displayName, baseDamage, drawSpeed, durability, arrowCount, enchantability, repairStack, ammoItem, soundName).func_77655_b(itemName);
            LootPPItems.addedItems.add(bow);
            GameRegistry.registerItem((Item)bow, (String)itemName);
            LootPlusPlusMod.proxy.registerVariants(bow, "lootplusplus:" + itemName, "lootplusplus:" + itemName + "_pulling_0", "lootplusplus:" + itemName + "_pulling_1", "lootplusplus:" + itemName + "_pulling_2");
            LootPlusPlusMod.proxy.registerItemRender(bow);
            LootPlusPlusMod.proxy.registerItemRenderWithDamage(bow, 1, itemName + "_pulling_0");
            LootPlusPlusMod.proxy.registerItemRenderWithDamage(bow, 2, itemName + "_pulling_1");
            LootPlusPlusMod.proxy.registerItemRenderWithDamage(bow, 3, itemName + "_pulling_2");
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom bow: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_guns", "guns", new String[0]);
        temp.comment = "Add guns, which fire on right click, then wait for a set time before\nfiring again. Add them in the format:\n\n      <Item name>_____<Item display name>_____<Durability>_____<Base damage>_____<Draw time>_____<# of arrows shot>_____<Enchantability>_____<Repair item name (write none for none)>_____<Repair item meta (-1 for any)>_____<Ammo Item>_____<Custom bullet item (must be throwable added item)>_____<Custom Shooting Sound (optional, defaults to random.bow)>\n\nWhere: \n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). You should add a model file for the item\nin the resource pack at assets/lootplusplus/models/item/<Item name>.\n- The item display name is what people will see in-game. \n- The durability is the durability of the gun.\n- The base damage is the amount of damage added to any bullets you shoot.\n- The draw time is how fast you can draw the gun.\n- The enchantability is how enchantable the gun is.\n- The repair item is what you can repair the gun with ('none' if not repairable).\n- The repair meta is the metadata for the repair item.\n- The ammo item is the item this gun will consume from your inventory\nwhen it shoots ('none' if no ammo item).\n- The shot item is the item this gun will shoot. It must be a throwable\nitem you added above.\n- The custom shooting sound is what sound the gun makes when you shoot it.\n\nIf you wanted to add ruby pistol and rifle, assuming you added 2 items above (a\ngeneric item ruby_bullets, and a throwable item ruby_shot) you could put:\n\n      ruby_pistol_____Ruby Pistol_____1000_____4.0_____20_____1_____10_____lootplusplus:ruby_____-1_____lootplusplus:ruby_bullets_____lootplusplus:ruby_shot\n      ruby_rifle_____Ruby Rifle_____1500_____7.0_____40_____1_____10_____lootplusplus:ruby_____-1_____lootplusplus:ruby_bullets_____lootplusplus:ruby_shot\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("guns"));
        for (index = 0; index < infoList.size(); ++index) {
            Item shotItem;
            String soundName;
            String shotName;
            String ammoName;
            int repairMeta;
            String repairItemName;
            int enchantability;
            int arrowCount;
            int drawSpeed;
            float baseDamage;
            block157: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'guns' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 11) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName = parts[1];
                durability = 384;
                baseDamage = 0.0f;
                drawSpeed = 72000;
                arrowCount = 1;
                enchantability = 1;
                repairItemName = parts[7];
                repairMeta = Short.MAX_VALUE;
                ammoName = parts[9];
                shotName = parts[10];
                soundName = parts.length > 11 ? parts[11] : "random.bow";
                try {
                    durability = Integer.valueOf(parts[2]);
                    baseDamage = Float.valueOf(parts[3]).floatValue();
                    drawSpeed = Integer.valueOf(parts[4]);
                    arrowCount = Integer.valueOf(parts[5]);
                    enchantability = Integer.valueOf(parts[6]);
                    repairMeta = Integer.valueOf(parts[8]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block157;
                    System.err.println("[Loot++] Caught exception while trying to add a gun " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[2], parts[3], parts[4], parts[5], parts[6], parts[8]);
                }
            }
            if (repairMeta < 0) {
                repairMeta = Short.MAX_VALUE;
            }
            if (durability <= 0) {
                durability = 1;
            }
            if (baseDamage < 0.0f) {
                baseDamage = 0.0f;
            }
            if (enchantability < 1) {
                enchantability = 1;
            }
            Item repairItem = null;
            if (!repairItemName.equals("none") && (repairItem = Item.func_111206_d((String)repairItemName)) == null) {
                LootPPNotifier.notifyNonexistant(comment, title, repairItemName);
                continue;
            }
            Item ammoItem = Item.func_111206_d((String)ammoName);
            if (!ammoName.equals("none")) {
                if (ammoItem == null) {
                    LootPPNotifier.notifyNonexistant(comment, title, ammoName);
                    continue;
                }
            } else {
                ammoItem = Items.field_151032_g;
                arrowCount = 0;
            }
            if (!((shotItem = Item.func_111206_d((String)shotName)) instanceof ItemAddedThrowable)) {
                LootPPNotifier.notify(comment, title, "No throwable Loot++ item found called " + shotName);
                continue;
            }
            ItemStack repairStack = null;
            if (repairItem != null) {
                repairStack = new ItemStack(repairItem, 1, repairMeta);
            }
            Item gun = new ItemAddedGun(displayName, baseDamage, drawSpeed, durability, arrowCount, enchantability, repairStack, ammoItem, (ItemAddedThrowable)shotItem, soundName).func_77655_b(itemName);
            LootPPItems.addedItems.add(gun);
            GameRegistry.registerItem((Item)gun, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(gun);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom gun: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_multitools", "multitools", new String[0]);
        temp.comment = "Add a multitool, which can act like multiple tools at once, in the format:\n\n      <Item name>_____<Item display name>_____<Tool type(s)>_____<Harvest level>_____<Durability>_____<Damage>_____<Efficiency>_____<Enchantability>_____<Repair item name (write none for none)>_____<Repair item meta (-1 for any)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The tool types are the classes of tool that this multitool has, with dashes between\nthem. The possible values are:\n\n      sword, pickaxe, axe, shovel, hoe\n\n- The durability, damage, and efficiency, and enchantability are what you would expect.\n- The repair item is what item you can repair the tool with. If you put 'none',\nthe multitool will not be repairable.\n- The repair item metadata is the metadata of the repair item.\n\nSo for instance, assuming that you added the ruby item in the generic\nsection and material for the item, you can add a ruby multitool that acts\nlike a pickaxe, axe, and shovel with:\n\n      ruby_paxel_____Ruby Paxel_____pickaxe-axe-shovel_____2_____1200_____6.0_____10.0_____20_____lootplusplus:ruby_____-1\n\nAssuming you had a model ruby_paxel.json in the folder mentioned above, and\nif you want to add a ruby battleaxe that acts as both a sword and an axe, you\ncould put:\n\n      ruby_battleaxe_____Ruby Battleaxe_____sword-axe_____2_____1200_____8.0_____10.0_____20_____lootplusplus:ruby_____-1\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("multitools"));
        for (index = 0; index < infoList.size(); ++index) {
            int meta;
            String repairItemName;
            int enchantability;
            float efficiency;
            float damage;
            int durability2;
            int harvestLevel;
            String typesString;
            block158: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'multitools' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length != 10) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName = parts[1];
                typesString = parts[2];
                harvestLevel = 0;
                durability2 = 100;
                damage = 3.0f;
                efficiency = 6.0f;
                enchantability = 10;
                repairItemName = parts[8];
                meta = -1;
                try {
                    harvestLevel = Integer.valueOf(parts[3]);
                    durability2 = Integer.valueOf(parts[4]);
                    damage = Float.valueOf(parts[5]).floatValue();
                    efficiency = Float.valueOf(parts[6]).floatValue();
                    enchantability = Integer.valueOf(parts[7]);
                    meta = Integer.valueOf(parts[9]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block158;
                    System.err.println("[Loot++] Caught exception while trying to create tool " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3], parts[4], parts[5], parts[6], parts[7], parts[9]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            ItemStack repairItem = null;
            if (!repairItemName.equalsIgnoreCase("none")) {
                Object itemObj = Item.field_150901_e.func_82594_a((Object)repairItemName);
                if (itemObj == null || !(itemObj instanceof Item)) {
                    LootPPNotifier.notifyNonexistant(comment, title, repairItemName);
                    continue;
                }
                repairItem = new ItemStack((Item)itemObj, 1, meta);
            }
            String[] toolTypes = typesString.split("-");
            Item addedItem = new ItemAddedMultiTool(toolTypes, harvestLevel, durability2, damage, efficiency, enchantability, repairItem, displayName).func_77655_b(itemName);
            LootPPItems.addedItems.add(addedItem);
            GameRegistry.registerItem((Item)addedItem, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(addedItem);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom multitool: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("add_materials", "materials", new String[0]);
        temp.comment = "Use this to add materials to create weapons, tools, and armour out of.You will be able to repair the tools, ect. that have this material\nwith the given item, and this will also determine the attack damage\nof the tools/weapons. Add entries in the form:\n      <Item name>_____<Item metadata (-1 for any)>_____<Harvest level>_____<Base Durability>_____<Base Efficiency>_____<Base Damage>_____<Enchantability>_____<Armour Durability Factor>_____<Armour Protection List>\n\nFor reference, the default materials would be something like:\n\n      minecraft:planks_____-1_____0_____59_____2.0_____0.0_____15_____5_____1-3-2-1\n      minecraft:leather_____-1_____0_____59_____2.0_____0.0_____15_____5_____1-3-2-1\n      minecraft:stone_____-1_____1_____131_____4.0_____1.0_____5_____5_____1-3-2-1\n      minecraft:iron_ingot_____-1_____2_____250_____6.0_____2.0_____14_____15_____2-6-5-2\n      minecraft:gold_ingot_____-1_____0_____32_____12.0_____0.0_____22_____7_____2-5-3-1\n      minecraft:diamond_____-1_____3_____1561_____8.0_____3.0_____10_____33_____3-8-6-3\n\nSo you should model yours in the same way. You can use materials you add in the\ngeneric section by adding lootplusplus: to the front of the item name. For instance,\nassuming you added the ruby, you could write:\n\n      lootplusplus:ruby_____-1_____3_____1200_____10.0_____3.0_____20_____32_____3-8-6-3\n\nTo make rubies a material much like diamond, but faster at digging, with\nmore enchantability, and less durability.";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("materials"));
        for (index = 0; index < infoList.size(); ++index) {
            int boots;
            int legs;
            int chest;
            int helm;
            int armourDurability;
            int enchantability;
            float damage;
            float efficiency;
            int durability3;
            int harvest;
            int meta;
            block160: {
                String[] strengths;
                block159: {
                    info = infoList.get(index);
                    title = this.getFileName() + ".cfg 'add_materials' #" + (index + 1);
                    comment = false;
                    if (info.length() > 0) {
                        boolean bl = comment = info.charAt(0) == '#';
                    }
                    if ((parts = info.split("_____")).length != 9) {
                        if (info.equals("")) continue;
                        LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                        continue;
                    }
                    itemName = parts[0];
                    meta = -1;
                    harvest = 0;
                    durability3 = 59;
                    efficiency = 2.0f;
                    damage = 0.0f;
                    enchantability = 15;
                    armourDurability = 5;
                    try {
                        meta = Integer.valueOf(parts[1]);
                        harvest = Integer.valueOf(parts[2]);
                        durability3 = Integer.valueOf(parts[3]);
                        efficiency = Float.valueOf(parts[4]).floatValue();
                        damage = Float.valueOf(parts[5]).floatValue();
                        enchantability = Integer.valueOf(parts[6]);
                        armourDurability = Integer.valueOf(parts[7]);
                    }
                    catch (NumberFormatException e) {
                        if (comment) break block159;
                        System.err.println("[Loot++] Caught exception while trying to add material entry for " + itemName);
                        e.printStackTrace();
                        LootPPNotifier.notifyNumber(comment, title, parts[1], parts[2], parts[3], parts[4], parts[5], parts[6], parts[7]);
                    }
                }
                if (meta < 0) {
                    meta = Short.MAX_VALUE;
                }
                if ((strengths = parts[8].split("-")).length != 4) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, parts[8]);
                    continue;
                }
                helm = 1;
                chest = 3;
                legs = 2;
                boots = 1;
                try {
                    helm = Integer.valueOf(strengths[0]);
                    chest = Integer.valueOf(strengths[1]);
                    legs = Integer.valueOf(strengths[2]);
                    boots = Integer.valueOf(strengths[3]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block160;
                    System.err.println("[Loot++] Caught exception while trying to add material armour strengths for " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, strengths[0], strengths[1], strengths[2], strengths[3]);
                }
            }
            String name = itemName;
            int colonIndex = itemName.indexOf(58);
            if (colonIndex != -1) {
                name = itemName.substring(colonIndex + 1);
            }
            name = name + "_" + meta;
            Object itemObj = Item.field_150901_e.func_82594_a((Object)itemName);
            if (itemObj == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, itemName);
                continue;
            }
            Item item = (Item)itemObj;
            Item.ToolMaterial tool = EnumHelper.addToolMaterial((String)name, (int)harvest, (int)durability3, (float)efficiency, (float)damage, (int)enchantability);
            tool.setRepairItem(new ItemStack(item, 1, meta));
            LootPPHelper.addedToolMaterials.put(new ItemStack(item, 1, meta), tool);
            ItemArmor.ArmorMaterial armour = EnumHelper.addArmorMaterial((String)name, (String)name, (int)armourDurability, (int[])new int[]{helm, chest, legs, boots}, (int)enchantability);
            armour.customCraftingMaterial = item;
            LootPPHelper.addedArmourMaterials.put(new ItemStack(item, 1, meta), armour);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom material: " + name);
        }
        temp = itemConfig.get("additions_tools", "swords", new String[0]);
        temp.comment = "Add swords, which act like the vanilla swords, in the format:\n\n      <Item name>_____<Item display name>_____<Material item name>_____<Added Damage (above innate material damage)>_____<Material item metadata (optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The material item name is the material that you can repair the tool with\nwhich should be registered in the adding material section first.\n\nSo for instance, assuming that you added the ruby item\nin the generic section and material for the item, you can add a ruby sword,\ndagger, and big sword with:\n      ruby_dagger_____Ruby Dagger_____lootplusplus:ruby_____2.0\n      ruby_sword_____Ruby Sword_____lootplusplus:ruby_____4.0\n      ruby_big_sword_____Ruby Big Sword_____lootplusplus:ruby_____6.0\n\nAssuming you had a models for each in the folder mentioned above.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("swords"));
        for (index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            int meta;
            float damageBonus;
            String materialItemName;
            String displayName2;
            block161: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'swords' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName2 = parts[1];
                materialItemName = parts[2];
                damageBonus = 4.0f;
                meta = -1;
                try {
                    damageBonus = Float.valueOf(parts[3]).floatValue();
                    if (parts.length > 4) {
                        meta = Integer.valueOf(parts[4]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block161;
                    System.err.println("[Loot++] Caught exception while trying to create sword " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3] + (parts.length > 5 ? ", " + parts[4] : ""));
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)materialItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, materialItemName);
                continue;
            }
            Item item = (Item)itemObj;
            ItemStack materialStack = new ItemStack(item, 1, meta);
            if (!LootPPHelper.addedToolMaterials.containsKey(materialStack) || LootPPHelper.addedToolMaterials.get(materialStack) == null) {
                if (comment) continue;
                System.err.println("[Loot++] Error! No item material found for item " + materialItemName + ". Did you add it to the add_materials section?");
                LootPPNotifier.notify(comment, title, "The item material '" + materialItemName + "' doesn't exist. Did you add it to the add_materials section?");
                continue;
            }
            Item sword = new ItemAddedSword(LootPPHelper.addedToolMaterials.get(materialStack), damageBonus, displayName2).func_77655_b(itemName);
            LootPPItems.addedItems.add(sword);
            GameRegistry.registerItem((Item)sword, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(sword);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom sword: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_tools", "pickaxes", new String[0]);
        temp.comment = "Add pickaxes, which act like the vanilla ones, in the format:\n\n      <Item name>_____<Item display name>_____<Material item name>_____<Material item metadata (optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The material item name is the material that you can repair the tool with\nwhich should be registered in the adding material section first.\n\nSo for instance, assuming that you added the ruby item in the generic\nsection and material for the item, you can add a ruby pickaxe with:\n\n      ruby_pickaxe_____Ruby Pickaxe_____lootplusplus:ruby\n\nAssuming you had a model ruby_pickaxe.json in the folder mentioned above.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("pickaxes"));
        for (index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            int meta;
            String materialItemName;
            String displayName3;
            block162: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'pickaxes' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 3) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName3 = parts[1];
                materialItemName = parts[2];
                meta = -1;
                try {
                    if (parts.length > 3) {
                        meta = Integer.valueOf(parts[3]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block162;
                    System.err.println("[Loot++] Caught exception while trying to create tool " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)materialItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, materialItemName);
                continue;
            }
            Item item = (Item)itemObj;
            ItemStack materialStack = new ItemStack(item, 1, meta);
            if (!LootPPHelper.addedToolMaterials.containsKey(materialStack) || LootPPHelper.addedToolMaterials.get(materialStack) == null) {
                if (comment) continue;
                System.err.println("[Loot++] Error! No item material found for item " + materialItemName + ". Did you add it to the add_materials section?");
                LootPPNotifier.notify(comment, title, "The item material '" + materialItemName + "' doesn't exist. Did you add it to the add_materials section?");
                continue;
            }
            Item pick = new ItemAddedPickaxe(LootPPHelper.addedToolMaterials.get(materialStack), displayName3).func_77655_b(itemName);
            LootPPItems.addedItems.add(pick);
            GameRegistry.registerItem((Item)pick, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(pick);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom pickaxe: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_tools", "axes", new String[0]);
        temp.comment = "Add axes, which act like the vanilla ones, in the format:\n\n      <Item name>_____<Item display name>_____<Material item name>_____<Material item metadata (optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The material item name is the material that you can repair the tool with\nwhich should be registered in the adding material section first.\n\nSo for instance, assuming that you added the ruby item in the generic\nsection and material for the item, you can add a ruby axe with:\n\n      ruby_axe_____Ruby Axe_____lootplusplus:ruby\n\nAssuming you had a model ruby_axe.json in the folder mentioned above.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("axes"));
        for (index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            int meta;
            String materialItemName;
            String displayName4;
            block163: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'axes' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 3) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName4 = parts[1];
                materialItemName = parts[2];
                meta = -1;
                try {
                    if (parts.length > 3) {
                        meta = Integer.valueOf(parts[3]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block163;
                    System.err.println("[Loot++] Caught exception while trying to create tool " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)materialItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, materialItemName);
                continue;
            }
            Item item = (Item)itemObj;
            ItemStack materialStack = new ItemStack(item, 1, meta);
            if (!LootPPHelper.addedToolMaterials.containsKey(materialStack) || LootPPHelper.addedToolMaterials.get(materialStack) == null) {
                if (comment) continue;
                System.err.println("[Loot++] Error! No item material found for item " + materialItemName + ". Did you add it to the add_materials section?");
                LootPPNotifier.notify(comment, title, "The item material '" + materialItemName + "' doesn't exist. Did you add it to the add_materials section?");
                continue;
            }
            Item addedItem = new ItemAddedAxe(LootPPHelper.addedToolMaterials.get(materialStack), displayName4).func_77655_b(itemName);
            LootPPItems.addedItems.add(addedItem);
            GameRegistry.registerItem((Item)addedItem, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(addedItem);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom axe: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_tools", "shovels", new String[0]);
        temp.comment = "Add a shovel, which will act like the vanilla ones, in the format:\n\n      <Item name>_____<Item display name>_____<Material item name>_____<Material item metadata (optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The material item name is the material that you can repair the tool with\nwhich should be registered in the adding material section first.\n\nSo for instance, assuming that you added the ruby item in the generic\nsection and material for the item, you can add a ruby shovel with:\n\n      ruby_shovel_____Ruby Shovel_____lootplusplus:ruby\n\nAssuming you had a model ruby_shovel.json in the folder mentioned above.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("shovels"));
        for (index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            int meta;
            String materialItemName;
            String displayName5;
            block164: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'shovels' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 3) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName5 = parts[1];
                materialItemName = parts[2];
                meta = -1;
                try {
                    if (parts.length > 3) {
                        meta = Integer.valueOf(parts[3]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block164;
                    System.err.println("[Loot++] Caught exception while trying to create tool " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)materialItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, materialItemName);
                continue;
            }
            Item item = (Item)itemObj;
            ItemStack materialStack = new ItemStack(item, 1, meta);
            if (!LootPPHelper.addedToolMaterials.containsKey(materialStack) || LootPPHelper.addedToolMaterials.get(materialStack) == null) {
                if (comment) continue;
                System.err.println("[Loot++] Error! No item material found for item " + materialItemName + ". Did you add it to the add_materials section?");
                LootPPNotifier.notify(comment, title, "The item material '" + materialItemName + "' doesn't exist. Did you add it to the add_materials section?");
                continue;
            }
            Item addedItem = new ItemAddedShovel(LootPPHelper.addedToolMaterials.get(materialStack), displayName5).func_77655_b(itemName);
            LootPPItems.addedItems.add(addedItem);
            GameRegistry.registerItem((Item)addedItem, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(addedItem);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom shovel: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_tools", "hoes", new String[0]);
        temp.comment = "Add a hoe, which will act like the vanilla ones, in the format:\n\n      <Item name>_____<Item display name>_____<Material item name>_____<Material item metadata (optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The material item name is the material that you can repair the tool with\nwhich should be registered in the adding material section first.\n\nSo for instance, assuming that you added the ruby item in the generic\nsection and material for the item, you can add a ruby hoe with:\n\n      ruby_hoe_____Ruby Hoe_____lootplusplus:ruby\n\nAssuming you had a model ruby_hoe.json in the folder mentioned above.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("hoes"));
        for (index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            int meta;
            String materialItemName;
            String displayName6;
            block165: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'hoes' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 3) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName6 = parts[1];
                materialItemName = parts[2];
                meta = -1;
                try {
                    if (parts.length > 3) {
                        meta = Integer.valueOf(parts[3]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block165;
                    System.err.println("[Loot++] Caught exception while trying to create tool " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[3]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)materialItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, materialItemName);
                continue;
            }
            Item item = (Item)itemObj;
            ItemStack materialStack = new ItemStack(item, 1, meta);
            if (!LootPPHelper.addedToolMaterials.containsKey(materialStack) || LootPPHelper.addedToolMaterials.get(materialStack) == null) {
                if (comment) continue;
                System.err.println("[Loot++] Error! No item material found for item " + materialItemName + ". Did you add it to the add_materials section?");
                LootPPNotifier.notify(comment, title, "The item material '" + materialItemName + "' doesn't exist. Did you add it to the add_materials section?");
                continue;
            }
            Item addedItem = new ItemAddedHoe(LootPPHelper.addedToolMaterials.get(materialStack), displayName6).func_77655_b(itemName);
            LootPPItems.addedItems.add(addedItem);
            GameRegistry.registerItem((Item)addedItem, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(addedItem);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom hoe: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_armor", "helmets", new String[0]);
        temp.comment = "Add a helmet, which will act like the vanilla ones, in the format:\n\n      <Item name>_____<Item display name>_____<Material item name>_____<Armour model texure location>_____<Material item metadata (optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The armour model texture name is the texture that will render on your character\nwhen the armor is worn. That one Should be in the 'assets/lootplusplus/models/armor' folder.\n\nSo for instance, assuming that you added the ruby item in the generic section\nand material for the item, you can add a ruby helmet with:\n\n      ruby_helmet_____Ruby Helmet_____lootplusplus:ruby_____lootplusplus:ruby_layer_1\n\nAssuming you had a model ruby_helmet.json in the models/item folder, and a texture\nruby_layer_1.png in the textures/models/armor folder.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("helmets"));
        for (index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            int meta;
            String armourTextureName;
            String materialItemName;
            String displayName7;
            block166: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'helmets' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName7 = parts[1];
                materialItemName = parts[2];
                armourTextureName = parts[3];
                meta = -1;
                try {
                    if (parts.length > 4) {
                        meta = Integer.valueOf(parts[4]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block166;
                    System.err.println("[Loot++] Caught exception while trying to create armour " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[4]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)materialItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, materialItemName);
                continue;
            }
            Item item = (Item)itemObj;
            ItemStack materialStack = new ItemStack(item, 1, meta);
            if (!LootPPHelper.addedArmourMaterials.containsKey(materialStack) || LootPPHelper.addedArmourMaterials.get(materialStack) == null) {
                if (comment) continue;
                System.err.println("[Loot++] Error! No item material found for item " + materialItemName + ". Did you add it to the add_materials section?");
                LootPPNotifier.notify(comment, title, "The item material '" + materialItemName + "' doesn't exist. Did you add it to the add_materials section?");
                continue;
            }
            Item addedItem = new ItemAddedArmour(LootPPHelper.addedArmourMaterials.get(materialStack), 0, displayName7, armourTextureName).func_77655_b(itemName);
            LootPPItems.addedItems.add(addedItem);
            GameRegistry.registerItem((Item)addedItem, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(addedItem);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom helmet: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_armor", "chestplates", new String[0]);
        temp.comment = "Add a chestplate, which will act like the vanilla ones, in the format:\n\n      <Item name>_____<Item display name>_____<Material item name>_____<Armour model texure location>_____<Material item metadata (optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The armour model texture name is the texture that will render on your character\nwhen the armor is worn. That one Should be in the 'assets/lootplusplus/models/armor' folder.\n\nSo for instance,\nassuming that you added the ruby item in the generic section and material\nfor the item, you can add a ruby chestplate with:\n\n      ruby_chestplate_____Ruby Chestplate_____lootplusplus:ruby_____lootplusplus:ruby_layer_1\n\nAssuming you had a model ruby_chestplate.json in the models/item folder, and a texture\nruby_layer_1.png in the textures/models/armor folder.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("chestplates"));
        for (index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            int meta;
            String armourTextureName;
            String materialItemName;
            String displayName8;
            block167: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'chestplates' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName8 = parts[1];
                materialItemName = parts[2];
                armourTextureName = parts[3];
                meta = -1;
                try {
                    if (parts.length > 4) {
                        meta = Integer.valueOf(parts[4]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block167;
                    System.err.println("[Loot++] Caught exception while trying to create armour " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[4]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)materialItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, materialItemName);
                continue;
            }
            Item item = (Item)itemObj;
            ItemStack materialStack = new ItemStack(item, 1, meta);
            if (!LootPPHelper.addedArmourMaterials.containsKey(materialStack) || LootPPHelper.addedArmourMaterials.get(materialStack) == null) {
                if (comment) continue;
                System.out.println("[Loot++] Error! No item material found for item " + materialItemName + ". Did you add it to the add_materials section?");
                LootPPNotifier.notify(comment, title, "The item material '" + materialItemName + "' doesn't exist. Did you add it to the add_materials section?");
                continue;
            }
            Item addedItem = new ItemAddedArmour(LootPPHelper.addedArmourMaterials.get(materialStack), 1, displayName8, armourTextureName).func_77655_b(itemName);
            LootPPItems.addedItems.add(addedItem);
            GameRegistry.registerItem((Item)addedItem, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(addedItem);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom chestplate: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_armor", "leggings", new String[0]);
        temp.comment = "Add a pair of leggings, which will act like the vanilla ones, in the format:\n\n      <Item name>_____<Item display name>_____<Material item name>_____<Armour model texure location>_____<Material item metadata (optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The armour model texture name is the texture that will render on your character\nwhen the armor is worn. That one Should be in the 'assets/lootplusplus/models/armor' folder.\n\nSo for instance,\nassuming that you added the ruby item in the generic section and material\nfor the item, you can add ruby leggings with:\n\n      ruby_leggings_____Ruby leggings_____lootplusplus:ruby_____lootplusplus:ruby_layer_2\n\nAssuming you had a model ruby_leggings.json in the models/item folder, and a texture\nruby_layer_2.png in the textures/models/armor folder. Note that it's layer 2 in this case,\nnot layer 1! The leggings are on a different layer.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("leggings"));
        for (index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            int meta;
            String armourTextureName;
            String materialItemName;
            String displayName9;
            block168: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'leggings' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName9 = parts[1];
                materialItemName = parts[2];
                armourTextureName = parts[3];
                meta = -1;
                try {
                    if (parts.length > 4) {
                        meta = Integer.valueOf(parts[4]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block168;
                    System.err.println("[Loot++] Caught exception while trying to create armour " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[4]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)materialItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, materialItemName);
                continue;
            }
            Item item = (Item)itemObj;
            ItemStack materialStack = new ItemStack(item, 1, meta);
            if (!LootPPHelper.addedArmourMaterials.containsKey(materialStack) || LootPPHelper.addedArmourMaterials.get(materialStack) == null) {
                if (comment) continue;
                System.out.println("[Loot++] Error! No item material found for item " + materialItemName + ". Did you add it to the add_materials section?");
                LootPPNotifier.notify(comment, title, "The item material '" + materialItemName + "' doesn't exist. Did you add it to the add_materials section?");
                continue;
            }
            Item addedItem = new ItemAddedArmour(LootPPHelper.addedArmourMaterials.get(materialStack), 2, displayName9, armourTextureName).func_77655_b(itemName);
            LootPPItems.addedItems.add(addedItem);
            GameRegistry.registerItem((Item)addedItem, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(addedItem);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom leggings: lootplusplus:" + itemName);
        }
        temp = itemConfig.get("additions_armor", "boots", new String[0]);
        temp.comment = "Add boots, which will act like the vanilla ones, in the format:\n\n      <Item name>_____<Item display name>_____<Material item name>_____<Armour model texure location>_____<Material item metadata (optional)>\n\nWhere:\n- The item name will be what the item is registered as (there will be\na 'lootplusplus:' added to the front of it automatically; don't add\nanything with a colon yourself!). Note that you should also add a model file with\nthis name in your resource pack in the folder assets/lootplusplus/models/item/<Item name>.json.\n- The item display name is what people will see in-game.\n- The armour model texture name is the texture that will render on your character\nwhen the armor is worn. That one Should be in the 'assets/lootplusplus/textures/models/armor' folder.\n\nSo for instance,\nassuming that you added the ruby item in the generic section and material\nfor the item, you can add ruby boots with:\n\n      ruby_boots_____Ruby Boots_____lootplusplus:ruby_____lootplusplus:ruby_layer_1\n\nAssuming you had a model ruby_boots.json in the models/item folder, and a texture\nruby_layer_1.png in the textures/models/armor folder.\n";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("boots"));
        for (index = 0; index < infoList.size(); ++index) {
            Object itemObj;
            int meta;
            String armourTextureName;
            String materialItemName;
            String displayName10;
            block169: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'boots' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if (comment) continue;
                parts = info.split("_____");
                if (parts.length < 4) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                itemName = parts[0];
                displayName10 = parts[1];
                materialItemName = parts[2];
                armourTextureName = parts[3];
                meta = -1;
                try {
                    if (parts.length > 4) {
                        meta = Integer.valueOf(parts[4]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block169;
                    System.err.println("[Loot++] Caught exception while trying to create armour " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[4]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((itemObj = Item.field_150901_e.func_82594_a((Object)materialItemName)) == null || !(itemObj instanceof Item)) {
                LootPPNotifier.notifyNonexistant(comment, title, materialItemName);
                continue;
            }
            Item item = (Item)itemObj;
            ItemStack materialStack = new ItemStack(item, 1, meta);
            if (!LootPPHelper.addedArmourMaterials.containsKey(materialStack) || LootPPHelper.addedArmourMaterials.get(materialStack) == null) {
                if (comment) continue;
                System.out.println("[Loot++] Error! No item material found for item " + materialItemName + ". Did you add it to the add_materials section?");
                LootPPNotifier.notify(comment, title, "The item material '" + materialItemName + "' doesn't exist. Did you add it to the add_materials section?");
                continue;
            }
            Item addedItem = new ItemAddedArmour(LootPPHelper.addedArmourMaterials.get(materialStack), 3, displayName10, armourTextureName).func_77655_b(itemName);
            LootPPItems.addedItems.add(addedItem);
            GameRegistry.registerItem((Item)addedItem, (String)itemName);
            LootPlusPlusMod.proxy.registerItemRender(addedItem);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added custom boots: lootplusplus:" + itemName);
        }
        itemConfig.save();
    }
}

