/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoaderBlocks;
import com.tmtravlr.lootplusplus.worldGen.WorldGenSurfaceBlocks;
import com.tmtravlr.lootplusplus.worldGen.WorldGenUndergroundBlocks;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigLoaderWorldGen
extends ConfigLoader {
    public static ConfigLoaderWorldGen instance = new ConfigLoaderWorldGen();

    ConfigLoaderWorldGen() {
        this.namesToExtras.put("surface", new ArrayList());
        this.namesToExtras.put("underground", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "world_gen";
    }

    public void loadWorldGen() {
        String nbtString;
        int meta;
        String blockName;
        String[] parts;
        boolean comment;
        String title;
        String info;
        int index;
        Configuration genConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        genConfig.load();
        Property temp = genConfig.get("add_world_gen", "surface", new String[0]);
        temp.comment = "This adds blocks generating on solid surfaces like flowers (could be underground too):\n\n      <Block name>_____<Block metadata>_____<Block NBT ({} for none)>_____<Bonemeal (true or false)>_____<Chance per chunk (0.0 to 1.0)>_____<Tries per chunk>_____<Group size>_____<Tries per group>_____<Height min>_____<Height max>_____<Block beneath blacklist>_____<Block beneath whitelist>_____<Material beneath blacklist>_____<Material beneath whitelist>_____<Biome blacklist>_____<Biome whitelist>_____<Biome type blacklist>_____<Biome type whitelist>_____<Dimension blacklist>_____<Dimension whitelist>\n\n- The <Block name> is the name the block that will generate.\n- The <Block metadata> is the metadata of the block that will generate.\n- The <Block NBT> is the nbt data of the block that will generate, or {} for none.\n- If <Bonemeal> is true, if the block is a bonemeal-able plant, the generator will attempt\nto apply bonemeal to it (useful for generating trees from saplings).\n- The <Chance per chunk> is the chance (between 0.0 and 1.0) that the block will attempt\nto generate in the chunk\n- The <Tries per chunk> is the number of times the block will attempt to generate in the\nchunk. It should be at least 1.\n- The <Group size> is the cubed area in which a group of the give block will attempt to\ngenerate. It should be at least 1.\n- The <Tries per group> is the number of times the block will attempt to generate in the\ngroup area mentioned above. It should be at least 1.\n- The <Height min> is the minimum height at which the blocks will try to generate. It should\nbe 0 or greater, and smaller than 256.\n- The <Height max> is the maximum height at which the blocks will try to generate. It should\nbe larger or equal to the minimum and smaller than 256.\n- The <Block beneath blacklist> is a list of blocks that this should not generate on.\n- The <Block beneath whitelist> is a list of blocks that this should generate on. Overrides\nthe blacklist.\n- The <Material beneath blacklist> is a list of materials that this should not generate on.\n- The <Material beneath whitelist> is a list of materials that this should generate on.\nOverrides the blacklist. The possible values for the whitelist and the blacklist are:\n\n      air, anvil, cactus, cake, carpet, circuits, clay, cloth, coral, craftedSnow, dragonEgg, fire\n      glass, gourd, grass, ground, ice, iron, lava, leaves, packedIce, piston, plants, portal\n      redstoneLight, rock, sand, snow, sponge, tnt, vine, water, web, wood\n\n- The <Biome blacklist> is a list of biome names that this should not generate in.\n- The <Biome whitelist> is a list of biome names that this should generate in. Overrides\nthe blacklist.\n- The <Biome type blacklist> is a list of biome types that this should not generate in.\n- The <Biome type whitelist> is a list of biome types that this should generate in. The\n'vanilla' forge values for the whitelist and blacklist are:\n\n      HOT, COLD, SPARSE, DENSE, WET, DRY, SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH,\n      NETHER, END, MUSHROOM, MAGICAL, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN,\n      HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH\n\n- The <Dimension blacklist> is a list of dimension ids that this should not generate in.\n- The <Dimension whitelist> is a list of dimension ids that this should generate in. Overrides\nthe blacklist.\n\nFor example, you could generate ruby flowers (assuming you added them in the block_additions)\nwhich generate in any plains or forest biomes on blocks with the ground material like so:\n\n      lootplusplus:ruby_flower_____0_____{}_____false_____0.7_____20_____6_____64_____0_____255_____-_____-_____-_____ground-grass_____-_____-_____-_____PLAINS-FOREST_____-_____-";
        ArrayList<String> infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("surface"));
        for (index = 0; index < infoList.size(); ++index) {
            BiomeDictionary.Type biomeType;
            Material material;
            String[] dimensionWl;
            String[] dimensionBl;
            String[] biomeTypeWl;
            String[] biomeTypeBl;
            String[] biomeWl;
            String[] biomeBl;
            String[] materialsBeneathWl;
            String[] materialsBeneathBl;
            String[] blocksBeneathWl;
            String[] blocksBeneathBl;
            int heightMax;
            int heightMin;
            int triesGroup;
            int groupSize;
            int triesChunk;
            float chancePerChunk;
            boolean bonemeal;
            block64: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'surface' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if ((parts = info.split("_____")).length != 20) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                meta = 0;
                nbtString = parts[2];
                bonemeal = false;
                chancePerChunk = 0.3f;
                triesChunk = 20;
                groupSize = 8;
                triesGroup = 64;
                heightMin = 0;
                heightMax = 255;
                blocksBeneathBl = parts[10].split("-");
                blocksBeneathWl = parts[11].split("-");
                materialsBeneathBl = parts[12].split("-");
                materialsBeneathWl = parts[13].split("-");
                biomeBl = parts[14].split("-");
                biomeWl = parts[15].split("-");
                biomeTypeBl = parts[16].split("-");
                biomeTypeWl = parts[17].split("-");
                dimensionBl = parts[18].split("-");
                dimensionWl = parts[19].split("-");
                try {
                    meta = Integer.valueOf(parts[1]);
                    bonemeal = Boolean.valueOf(parts[3]);
                    chancePerChunk = Float.valueOf(parts[4]).floatValue();
                    triesChunk = Integer.valueOf(parts[5]);
                    groupSize = Integer.valueOf(parts[6]);
                    triesGroup = Integer.valueOf(parts[7]);
                    heightMin = Integer.valueOf(parts[8]);
                    heightMax = Integer.valueOf(parts[9]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block64;
                    System.err.println("[Loot++] Caught exception while trying to add surface world gen for " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[1], parts[3], parts[4], parts[5], parts[6], parts[7], parts[8], parts[9]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            chancePerChunk = MathHelper.func_76131_a((float)chancePerChunk, (float)0.0f, (float)1.0f);
            if (triesChunk < 1) {
                triesChunk = 1;
            }
            if (groupSize < 1) {
                groupSize = 1;
            }
            if (triesGroup < 1) {
                triesGroup = 1;
            }
            heightMin = MathHelper.func_76125_a((int)heightMin, (int)0, (int)255);
            heightMax = MathHelper.func_76125_a((int)heightMax, (int)heightMin, (int)255);
            Object blockObj = Block.field_149771_c.func_82594_a((Object)blockName);
            if (blockObj == null || !(blockObj instanceof Block)) {
                LootPPNotifier.notifyNonexistant(comment, title, blockName);
                continue;
            }
            Block block = (Block)blockObj;
            NBTTagCompound tileTag = null;
            if (!nbtString.equals("") && !nbtString.equals("{}")) {
                try {
                    tileTag = JsonToNBT.func_180713_a((String)nbtString.trim());
                }
                catch (Exception e) {
                    if (!comment) {
                        LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                        e.printStackTrace();
                    }
                    tileTag = null;
                }
            }
            IBlockState toGenerate = block.func_176203_a(meta);
            WorldGenSurfaceBlocks.SurfaceGenInfo genInfo = new WorldGenSurfaceBlocks.SurfaceGenInfo(toGenerate, tileTag, bonemeal, chancePerChunk, triesChunk, groupSize, triesGroup, heightMin, heightMax);
            for (String part : blocksBeneathBl) {
                if (part.equals("")) continue;
                blockObj = Block.field_149771_c.func_82594_a((Object)part);
                if (blockObj == null || !(blockObj instanceof Block)) {
                    LootPPNotifier.notifyNonexistant(comment, title, part);
                    continue;
                }
                genInfo.blocksBl.add((Block)blockObj);
            }
            for (String part : blocksBeneathWl) {
                if (part.equals("")) continue;
                blockObj = Block.field_149771_c.func_82594_a((Object)part);
                if (blockObj == null || !(blockObj instanceof Block)) {
                    LootPPNotifier.notifyNonexistant(comment, title, part);
                    continue;
                }
                genInfo.blocksWl.add((Block)blockObj);
            }
            for (String part : materialsBeneathBl) {
                if (part.equals("")) continue;
                material = ConfigLoaderBlocks.getMaterialFromString(part);
                if (material == null) {
                    LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + part);
                    continue;
                }
                genInfo.materialsBl.add(material);
            }
            for (String part : materialsBeneathWl) {
                if (part.equals("")) continue;
                material = ConfigLoaderBlocks.getMaterialFromString(part);
                if (material == null) {
                    LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + part);
                    continue;
                }
                genInfo.materialsWl.add(material);
            }
            for (String part : biomeBl) {
                if (part.equals("")) continue;
                genInfo.biomeBl.add(part.toLowerCase());
            }
            for (String part : biomeWl) {
                if (part.equals("")) continue;
                genInfo.biomeWl.add(part.toLowerCase());
            }
            for (String part : biomeTypeBl) {
                if (part.equals("")) continue;
                biomeType = BiomeDictionary.Type.getType((String)part, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                genInfo.biomeTypeBl.add(biomeType);
            }
            for (String part : biomeTypeWl) {
                if (part.equals("")) continue;
                biomeType = BiomeDictionary.Type.getType((String)part, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                genInfo.biomeTypeWl.add(biomeType);
            }
            for (String part : dimensionBl) {
                if (part.equals("")) continue;
                try {
                    genInfo.dimensionBl.add(Integer.parseInt(part));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, part);
                }
            }
            for (String part : dimensionWl) {
                if (part.equals("")) continue;
                try {
                    genInfo.dimensionWl.add(Integer.parseInt(part));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, part);
                }
            }
            WorldGenSurfaceBlocks.surfaceGens.add(genInfo);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added surface world gen for block " + blockName);
        }
        temp = genConfig.get("add_world_gen", "underground", new String[0]);
        temp.comment = "This adds blocks generating inside other blocks like ores:\n\n      <Block name>_____<Block metadata>_____<Block NBT ({} for none)>_____<Chance per chunk (0.0 to 1.0)>_____<Tries per chunk>_____<Vein length min>-<Vein length max (optional)>_____<Vein thickness min>-<Vein thickness max>_____<Height min>_____<Height max>_____<Block blacklist>_____<Block whitelist>_____<Material beneath blacklist>_____<Material beneath whitelist>_____<Biome blacklist>_____<Biome whitelist>_____<Biome type blacklist>_____<Biome type whitelist>_____<Dimension blacklist>_____<Dimension whitelist>\n\n- The <Block name> is the name the block that will generate.\n- The <Block metadata> is the metadata of the block that will generate.\n- The <Block NBT> is the nbt data of the block that will generate, or {} for none.\n- The <Chance per chunk> is the chance (between 0.0 and 1.0) that the block will attempt\nto generate in the chunk\n- The <Tries per chunk> is the number of times the block will attempt to generate in the\nchunk. It should be at least 1.\n- The <Vein length min and max> are the minimum and maximum lengths of the ore vein. The\nmin should be at least 1, and the max should be bigger or equal to the min, if included.\n- The <Vein thickness min and max> are the minimum and maximum thickness of the ore vein. The\nmin should be at least 1, and the max should be bigger or equal to the min, if included.\n- The <Height min> is the minimum height at which the blocks will try to generate. It should\nbe 0 or greater, and smaller than 256.\n- The <Height max> is the maximum height at which the blocks will try to generate. It should\nbe larger or equal to the minimum and smaller than 256.\n- The <Block blacklist> is a list of blocks that this should not generate in.\n- The <Block whitelist> is a list of blocks that this should generate in. Overrides\nthe blacklist.\n- The <Material beneath blacklist> is a list of materials that this should not generate on.\n- The <Material beneath whitelist> is a list of materials that this should generate on.\nOverrides the blacklist. The possible values for the whitelist and the blacklist are:\n\n      air, anvil, cactus, cake, carpet, circuits, clay, cloth, coral, craftedSnow, dragonEgg, fire\n      glass, gourd, grass, ground, ice, iron, lava, leaves, packedIce, piston, plants, portal\n      redstoneLight, rock, sand, snow, sponge, tnt, vine, water, web, wood\n\n- The <Biome blacklist> is a list of biome names that this should not generate in.\n- The <Biome whitelist> is a list of biome names that this should generate in. Overrides\nthe blacklist.\n- The <Biome type blacklist> is a list of biome types that this should not generate in.\n- The <Biome type whitelist> is a list of biome types that this should generate in. The\n'vanilla' forge values for the whitelist and blacklist are:\n\n      HOT, COLD, SPARSE, DENSE, WET, DRY, SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH,\n      NETHER, END, MUSHROOM, MAGICAL, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN,\n      HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH\n\n- The <Dimension blacklist> is a list of dimension ids that this should not generate in.\n- The <Dimension whitelist> is a list of dimension ids that this should generate in. Overrides\nthe blacklist.\n\nFor example, you could generate ruby ore (assuming you added it in the block_additions)\nin every biome with rarity more like diamonds, except they generate more in\ndesert-like biomes, with these two entries:\n\n      lootplusplus:ruby_ore_____0_____{}_____0.8_____2_____1-2_____1-2_____0_____20_____-_____stone_____-_____-_____-_____-_____-_____-_____-_____-\n      lootplusplus:ruby_ore_____0_____{}_____0.8_____2_____1-2_____1_____0_____30_____-_____stone_____-_____-_____-_____-_____-_____DRY-SANDY-SAVANNA_____-_____-";
        infoList = ConfigExtrasLoader.combineLists(temp.getStringList(), (ArrayList)this.namesToExtras.get("underground"));
        for (index = 0; index < infoList.size(); ++index) {
            BiomeDictionary.Type biomeType;
            Material material;
            String[] dimensionWl;
            String[] dimensionBl;
            String[] biomeTypeWl;
            String[] biomeTypeBl;
            String[] biomeWl;
            String[] biomeBl;
            String[] materialsBeneathWl;
            String[] materialsBeneathBl;
            String[] blocksBeneathWl;
            String[] blocksBeneathBl;
            int heightMax;
            int heightMin;
            int veinThicknessMax;
            int veinThicknessMin;
            int veinLengthMax;
            int veinLengthMin;
            int triesChunk;
            float chancePerChunk;
            block65: {
                info = infoList.get(index);
                title = this.getFileName() + ".cfg 'underground' #" + (index + 1);
                comment = false;
                if (info.length() > 0) {
                    boolean bl = comment = info.charAt(0) == '#';
                }
                if ((parts = info.split("_____")).length != 19) {
                    if (info.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, info);
                    continue;
                }
                blockName = parts[0];
                meta = 0;
                nbtString = parts[2];
                chancePerChunk = 0.3f;
                triesChunk = 20;
                veinLengthMin = 1;
                veinLengthMax = 2;
                veinThicknessMin = 2;
                veinThicknessMax = 2;
                heightMin = 0;
                heightMax = 255;
                blocksBeneathBl = parts[9].split("-");
                blocksBeneathWl = parts[10].split("-");
                materialsBeneathBl = parts[11].split("-");
                materialsBeneathWl = parts[12].split("-");
                biomeBl = parts[13].split("-");
                biomeWl = parts[14].split("-");
                biomeTypeBl = parts[15].split("-");
                biomeTypeWl = parts[16].split("-");
                dimensionBl = parts[17].split("-");
                dimensionWl = parts[18].split("-");
                try {
                    meta = Integer.valueOf(parts[1]);
                    chancePerChunk = Float.valueOf(parts[3]).floatValue();
                    triesChunk = Integer.valueOf(parts[4]);
                    String[] subParts = parts[5].split("-");
                    veinLengthMin = Integer.valueOf(subParts[0]);
                    veinLengthMax = subParts.length > 1 ? Integer.valueOf(subParts[1]) : veinLengthMin;
                    subParts = parts[6].split("-");
                    veinThicknessMin = Integer.valueOf(subParts[0]);
                    veinThicknessMax = subParts.length > 1 ? Integer.valueOf(subParts[1]) : veinThicknessMin;
                    heightMin = Integer.valueOf(parts[7]);
                    heightMax = Integer.valueOf(parts[8]);
                }
                catch (Exception e) {
                    if (comment) break block65;
                    System.err.println("[Loot++] Caught exception while trying to add underground world gen for " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[1], parts[3], parts[4], parts[5], parts[6], parts[7], parts[8]);
                }
            }
            meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
            chancePerChunk = MathHelper.func_76131_a((float)chancePerChunk, (float)0.0f, (float)1.0f);
            if (triesChunk < 1) {
                triesChunk = 1;
            }
            if (veinLengthMin < 1) {
                veinLengthMin = 1;
            }
            if (veinLengthMax < veinLengthMin) {
                veinLengthMax = veinLengthMin;
            }
            if (veinThicknessMin < 1) {
                veinThicknessMin = 1;
            }
            if (veinThicknessMax < veinThicknessMin) {
                veinThicknessMax = veinThicknessMin;
            }
            heightMin = MathHelper.func_76125_a((int)heightMin, (int)0, (int)255);
            heightMax = MathHelper.func_76125_a((int)heightMax, (int)heightMin, (int)255);
            Object blockObj = Block.field_149771_c.func_82594_a((Object)blockName);
            if (blockObj == null || !(blockObj instanceof Block)) {
                LootPPNotifier.notifyNonexistant(comment, title, blockName);
                continue;
            }
            Block block = (Block)blockObj;
            NBTTagCompound tileTag = null;
            if (!nbtString.equals("") && !nbtString.equals("{}")) {
                try {
                    tileTag = JsonToNBT.func_180713_a((String)nbtString.trim());
                }
                catch (Exception e) {
                    if (!comment) {
                        LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                        e.printStackTrace();
                    }
                    tileTag = null;
                }
            }
            IBlockState toGenerate = block.func_176203_a(meta);
            WorldGenUndergroundBlocks.UndergroundGenInfo genInfo = new WorldGenUndergroundBlocks.UndergroundGenInfo(toGenerate, tileTag, chancePerChunk, triesChunk, veinLengthMin, veinLengthMax, veinThicknessMin, veinThicknessMax, heightMin, heightMax);
            for (String part : blocksBeneathBl) {
                if (part.equals("")) continue;
                blockObj = Block.field_149771_c.func_82594_a((Object)part);
                if (blockObj == null || !(blockObj instanceof Block)) {
                    LootPPNotifier.notifyNonexistant(comment, title, part);
                    continue;
                }
                genInfo.blocksBl.add((Block)blockObj);
            }
            for (String part : blocksBeneathWl) {
                if (part.equals("")) continue;
                blockObj = Block.field_149771_c.func_82594_a((Object)part);
                if (blockObj == null || !(blockObj instanceof Block)) {
                    LootPPNotifier.notifyNonexistant(comment, title, part);
                    continue;
                }
                genInfo.blocksWl.add((Block)blockObj);
            }
            for (String part : materialsBeneathBl) {
                if (part.equals("")) continue;
                material = ConfigLoaderBlocks.getMaterialFromString(part);
                if (material == null) {
                    LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + part);
                    continue;
                }
                genInfo.materialsBl.add(material);
            }
            for (String part : materialsBeneathWl) {
                if (part.equals("")) continue;
                material = ConfigLoaderBlocks.getMaterialFromString(part);
                if (material == null) {
                    LootPPNotifier.notify(comment, title, "Couldn't find a material for name: " + part);
                    continue;
                }
                genInfo.materialsWl.add(material);
            }
            for (String part : biomeBl) {
                if (part.equals("")) continue;
                genInfo.biomeBl.add(part.toLowerCase());
            }
            for (String part : biomeWl) {
                if (part.equals("")) continue;
                genInfo.biomeWl.add(part.toLowerCase());
            }
            for (String part : biomeTypeBl) {
                if (part.equals("")) continue;
                biomeType = BiomeDictionary.Type.getType((String)part, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                genInfo.biomeTypeBl.add(biomeType);
            }
            for (String part : biomeTypeWl) {
                if (part.equals("")) continue;
                biomeType = BiomeDictionary.Type.getType((String)part, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                genInfo.biomeTypeWl.add(biomeType);
            }
            for (String part : dimensionBl) {
                if (part.equals("")) continue;
                try {
                    genInfo.dimensionBl.add(Integer.parseInt(part));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, part);
                }
            }
            for (String part : dimensionWl) {
                if (part.equals("")) continue;
                try {
                    genInfo.dimensionWl.add(Integer.parseInt(part));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, part);
                }
            }
            WorldGenUndergroundBlocks.undergroundGens.add(genInfo);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added underground world gen for block " + blockName);
        }
        genConfig.save();
    }
}

