/*
 * Decompiled with CFR 0.152.
 */
import java.util.IdentityHashMap;
import java.util.Map;

public class NaturalProperties {
    public int rotation = 1;
    public boolean flip = false;
    private Map[] quadMaps = new Map[8];

    public NaturalProperties(String type) {
        if (type.equals("4")) {
            this.rotation = 4;
            return;
        }
        if (type.equals("2")) {
            this.rotation = 2;
            return;
        }
        if (type.equals("F")) {
            this.flip = true;
            return;
        }
        if (type.equals("4F")) {
            this.rotation = 4;
            this.flip = true;
            return;
        }
        if (type.equals("2F")) {
            this.rotation = 2;
            this.flip = true;
            return;
        }
        Config.warn("NaturalTextures: Unknown type: " + type);
    }

    public boolean isValid() {
        if (this.rotation == 2 || this.rotation == 4) {
            return true;
        }
        return this.flip;
    }

    public synchronized clt getQuad(clt quadIn, int rotate, boolean flipU) {
        clt quad;
        int index = rotate;
        if (flipU) {
            index |= 4;
        }
        if (index <= 0 || index >= this.quadMaps.length) {
            return quadIn;
        }
        IdentityHashMap<clt, clt> map = this.quadMaps[index];
        if (map == null) {
            this.quadMaps[index] = map = new IdentityHashMap<clt, clt>(1);
        }
        if ((quad = (clt)map.get(quadIn)) == null) {
            quad = this.makeQuad(quadIn, rotate, flipU);
            map.put(quadIn, quad);
        }
        return quad;
    }

    private clt makeQuad(clt quad, int rotate, boolean flipU) {
        int[] vertexData = quad.a();
        int tintIndex = quad.c();
        ej face = quad.d();
        cue sprite = quad.getSprite();
        vertexData = this.fixVertexData(vertexData, rotate, flipU);
        clt bq = new clt(vertexData, tintIndex, face, sprite);
        return bq;
    }

    private int[] fixVertexData(int[] vertexData, int rotate, boolean flipU) {
        int[] vertexData2 = (int[])vertexData.clone();
        int v2 = 4 - rotate;
        if (flipU) {
            v2 += 3;
        }
        v2 %= 4;
        int mul = vertexData2.length / 4;
        for (int v = 0; v < 4; ++v) {
            int pos = v * mul;
            int pos2 = v2 * mul;
            vertexData2[pos2 + 4] = vertexData[pos + 4];
            vertexData2[pos2 + 4 + 1] = vertexData[pos + 4 + 1];
            if (flipU) {
                if (--v2 >= 0) continue;
                v2 = 3;
                continue;
            }
            if (++v2 <= 3) continue;
            v2 = 0;
        }
        return vertexData2;
    }
}

