/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import shadersmod.client.GuiButtonShaderOption;
import shadersmod.client.ShaderOption;
import shadersmod.client.ShaderOptionProfile;
import shadersmod.client.ShaderOptionScreen;
import shadersmod.client.Shaders;

public class GuiShaderOptions
extends bxf {
    private bxf prevScreen;
    protected String title = "Shader Options";
    private bto settings;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;
    private String screenName = null;
    private String screenText = null;
    private boolean changed = false;
    public static final String OPTION_PROFILE = "<profile>";
    public static final String OPTION_EMPTY = "<empty>";
    public static final String OPTION_REST = "*";

    public GuiShaderOptions(bxf guiscreen, bto gamesettings) {
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    public GuiShaderOptions(bxf guiscreen, bto gamesettings, String screenName) {
        this(guiscreen, gamesettings);
        this.screenName = screenName;
        if (screenName != null) {
            this.screenText = Shaders.translate("screen." + screenName, screenName);
        }
    }

    public void b() {
        int baseId = 100;
        int baseX = 0;
        int baseY = 30;
        int stepY = 20;
        int btnX = this.l - 130;
        int btnWidth = 120;
        int btnHeight = 20;
        int columns = 2;
        ShaderOption[] ops = Shaders.getShaderPackOptions(this.screenName);
        if (ops != null) {
            if (ops.length > 18) {
                columns = ops.length / 9 + 1;
            }
            for (int i = 0; i < ops.length; ++i) {
                ShaderOption so = ops[i];
                if (so == null || !so.isVisible()) continue;
                int col = i % columns;
                int row = i / columns;
                int colWidth = Math.min(this.l / columns, 200);
                baseX = (this.l - colWidth * columns) / 2;
                int x = col * colWidth + 5 + baseX;
                int y = baseY + row * stepY;
                int w = colWidth - 10;
                int h = btnHeight;
                String text = this.getButtonText(so, w);
                GuiButtonShaderOption btn = new GuiButtonShaderOption(baseId + i, x, y, w, h, so, text);
                btn.l = so.isEnabled();
                this.n.add(btn);
            }
        }
        this.n.add(new bug(201, this.l / 2 - btnWidth - 20, this.m / 6 + 168 + 11, btnWidth, btnHeight, cwc.a((String)"controls.reset", (Object[])new Object[0])));
        this.n.add(new bug(200, this.l / 2 + 20, this.m / 6 + 168 + 11, btnWidth, btnHeight, cwc.a((String)"gui.done", (Object[])new Object[0])));
    }

    private String getButtonText(ShaderOption so, int btnWidth) {
        String labelName = so.getNameText();
        if (so instanceof ShaderOptionScreen) {
            ShaderOptionScreen soScr = (ShaderOptionScreen)so;
            return labelName + "...";
        }
        bty fr = Config.getMinecraft().k;
        int lenSuffix = fr.a(": " + Lang.getOff()) + 5;
        while (fr.a(labelName) + lenSuffix >= btnWidth && labelName.length() > 0) {
            labelName = labelName.substring(0, labelName.length() - 1);
        }
        String col = so.isChanged() ? so.getValueColor(so.getValue()) : "";
        String labelValue = so.getValueText(so.getValue());
        return labelName + ": " + col + labelValue;
    }

    protected void a(bug guibutton) {
        if (!guibutton.l) {
            return;
        }
        if (guibutton.k < 200 && guibutton instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)guibutton;
            ShaderOption so = btnSo.getShaderOption();
            if (so instanceof ShaderOptionScreen) {
                String screenName = so.getName();
                GuiShaderOptions scr = new GuiShaderOptions(this, this.settings, screenName);
                this.j.a((bxf)scr);
                return;
            }
            so.nextValue();
            this.updateAllButtons();
            this.changed = true;
        }
        if (guibutton.k == 201) {
            ShaderOption[] opts = Shaders.getChangedOptions(Shaders.getShaderPackOptions());
            for (int i = 0; i < opts.length; ++i) {
                ShaderOption opt = opts[i];
                opt.resetValue();
                this.changed = true;
            }
            this.updateAllButtons();
        }
        if (guibutton.k == 200) {
            if (this.changed) {
                Shaders.saveShaderPackOptions();
                Shaders.uninit();
            }
            this.j.a(this.prevScreen);
        }
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        GuiButtonShaderOption btnSo;
        ShaderOption so;
        bug btn;
        super.a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1 && (btn = this.getSelectedButton(mouseX, mouseY)) instanceof GuiButtonShaderOption && (so = (btnSo = (GuiButtonShaderOption)btn).getShaderOption()).isChanged()) {
            btnSo.a(this.j.U());
            so.resetValue();
            this.changed = true;
            this.updateAllButtons();
        }
    }

    private void updateAllButtons() {
        for (bug btn : this.n) {
            if (!(btn instanceof GuiButtonShaderOption)) continue;
            GuiButtonShaderOption gbso = (GuiButtonShaderOption)btn;
            ShaderOption opt = gbso.getShaderOption();
            if (opt instanceof ShaderOptionProfile) {
                ShaderOptionProfile optProf = (ShaderOptionProfile)opt;
                optProf.updateProfile();
            }
            gbso.j = this.getButtonText(opt, gbso.b());
        }
    }

    public void a(int x, int y, float f) {
        this.c();
        if (this.screenText != null) {
            this.a(this.q, this.screenText, this.l / 2, 15, 0xFFFFFF);
        } else {
            this.a(this.q, this.title, this.l / 2, 15, 0xFFFFFF);
        }
        super.a(x, y, f);
        if (Math.abs(x - this.lastMouseX) > 5 || Math.abs(y - this.lastMouseY) > 5) {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
            return;
        }
        this.drawTooltips(x, y, this.n);
    }

    private void drawTooltips(int x, int y, List buttonList) {
        int activateDelay = 700;
        if (System.currentTimeMillis() < this.mouseStillTime + (long)activateDelay) {
            return;
        }
        int x1 = this.l / 2 - 150;
        int y1 = this.m / 6 - 7;
        if (y <= y1 + 98) {
            y1 += 105;
        }
        int x2 = x1 + 150 + 150;
        int y2 = y1 + 84 + 10;
        bug btn = this.getSelectedButton(x, y);
        if (btn instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)btn;
            ShaderOption so = btnSo.getShaderOption();
            String[] lines = this.makeTooltipLines(so, x2 - x1);
            if (lines == null) {
                return;
            }
            this.a(x1, y1, x2, y2, -536870912, -536870912);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                int col = 0xDDDDDD;
                if (line.endsWith("!")) {
                    col = 0xFF2020;
                }
                this.q.a(line, (float)(x1 + 5), (float)(y1 + 5 + i * 11), col);
            }
        }
    }

    private String[] makeTooltipLines(ShaderOption so, int width) {
        if (so instanceof ShaderOptionProfile) {
            return null;
        }
        String name = so.getNameText();
        String desc = Config.normalize(so.getDescriptionText()).trim();
        String[] descs = this.splitDescription(desc);
        String id = null;
        if (!name.equals(so.getName())) {
            id = Lang.get("of.general.id") + ": " + so.getName();
        }
        String source = null;
        if (so.getPaths() != null) {
            source = Lang.get("of.general.from") + ": " + Config.arrayToString(so.getPaths());
        }
        String def = null;
        if (so.getValueDefault() != null) {
            String defVal = so.isEnabled() ? so.getValueText(so.getValueDefault()) : Lang.get("of.general.ambiguous");
            def = Lang.getDefault() + ": " + defVal;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(name);
        list.addAll(Arrays.asList(descs));
        if (id != null) {
            list.add(id);
        }
        if (source != null) {
            list.add(source);
        }
        if (def != null) {
            list.add(def);
        }
        String[] lines = this.makeTooltipLines(width, list);
        return lines;
    }

    private String[] splitDescription(String desc) {
        if (desc.length() <= 0) {
            return new String[0];
        }
        desc = StrUtils.removePrefix(desc, "//");
        String[] descs = desc.split("\\. ");
        for (int i = 0; i < descs.length; ++i) {
            descs[i] = "- " + descs[i].trim();
            descs[i] = StrUtils.removeSuffix(descs[i], ".");
        }
        return descs;
    }

    private String[] makeTooltipLines(int width, List<String> args) {
        bty fr = Config.getMinecraft().k;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (arg == null || arg.length() <= 0) continue;
            List parts = fr.c(arg, width);
            for (String part : parts) {
                list.add(part);
            }
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }

    private bug getSelectedButton(int x, int y) {
        for (int i = 0; i < this.n.size(); ++i) {
            bug btn = (bug)this.n.get(i);
            int btnWidth = bxr.getButtonWidth((bug)btn);
            int btnHeight = bxr.getButtonHeight((bug)btn);
            if (x < btn.h || y < btn.i || x >= btn.h + btnWidth || y >= btn.i + btnHeight) continue;
            return btn;
        }
        return null;
    }
}

