/*
Company:
Microchip Technology Inc.

File Name:
XNODE.h

Summary:
This is a library that will be used to set up a serial communication between an XNODE 
controller and an I/O type XNODE.

Description:
This header file provides implementations for driver APIs for all modules selected in the GUI.
Generation Information :
Product Revision  :  
Device            :  Cualquier dispositivo que tenga puerto serial
Driver Version    :  3.00
*/

#ifndef XNODE_h
#define XNODE_h

#include <HardwareSerial.h>

class XNODE
{
    public:   //Functions belonging to the class that can be called outside of it

        void SendCommandWithRange(char* node, char* command, int value);

        void SendCommandWithRange(char* node, char* command, int value1, int value2, int value3);

        /*
        Constructor:
            XNODE::XNODE(HardwareSerial *_TRANSMITTING_SERIAL)
        Overview:
            Defines the serial ports that will be used to establish 
            communication with the node as global variables.
        Precondition:
            None.
        Input:
            HardwareSerial *_TRANSMITTING_SERIAL: Serial port that communicates with the node; e.g. Serial
        Output:
            None.
        */
        XNODE(HardwareSerial* _TRANSMITTING_SERIAL);

        /*
        Constructor:
            XNODE::XNODE(HardwareSerial* _TRANSMITTING_SERIAL, HardwareSerial* _RECEIVING_SERIAL)
        Overview:
            Defines the serial ports that will be used to establish 
            communication with the node as global variables.
        Precondition:
            None.
        Input:
            HardwareSerial* _TRANSMITTING_SERIAL: Serial port that communicates with the node; e.g. Serial.
            HardwareSerial* _RECEIVING_SERIAL: Serial port where the instructions between nodes are displayed; e.g. Serial1, Serial2, Serial3.
        Output:
            None.
        */
        XNODE(HardwareSerial* _TRANSMITTING_SERIAL, HardwareSerial* _RECEIVING_SERIAL);

        /*
        Function:
            void XNODE::SendCommand(char* node, char* command, char* value)
        Overview:
            Sends a command with a numeric value through the serial port to the XNODE.
        Precondition:
            None.
        Input:
            char* node: X-NODE's ID; e.g. 016A, 007E.
            char* command: Commands for the X-NODEs; R, G, F, S.
            char* value: Command's value; e.g. 101010, 00001111.
        Output:
            None.
        */
        void SendCommand(char* ID, char* command, char* value);

        /*
        Function:
            void XNODE::SendAsk(char* node)
        Overview:
            Sends the ID and the command '?' through the serial port to the X-NODE.
        Precondition:
            None.
        Input:
            char* node: X-NODE's ID; e.g. 016A, 007E.
        Output:
            None.
        */
        void SendAsk(char* node);

        /*
        Function:
            float XNODE::GetValueAsFloat(char* node, char* command)
        Overview:
            Sends the command to the X-NODE through the serial port, waits for the 
            response and then processes it.
        Precondition:
            None.
        Input:
            char* node: X-NODE's ID; e.g. 016A, 007E.
            char* command: Commands for the X-NODEs; e.g GH, GT, GP.
        Output:
            Float: The X-NODE's response as a float.
        */
        float GetValueAsFloat(char* node, char* command);


        float GetValueAsFloat(char* node, char* command, float val1, float val2);


        /*
        Function:
            int XNODE::GetValueAsInt(char* node, char* command)  
        Overview:
            Sends the command to the X-NODE through the serial port, waits for the 
            response and then processes it.
        Precondition:
            None.
        Input:
            char* node: X-NODE's ID; e.g. 016A, 007E.
            char* command: Commands for the X-NODEs; e.g GH, GT, GP.
        Output:
            Int: The X-NODE's response as an Integer.
        */
        int GetValueAsInt(char* node, char* command);
        

    private:    //Functions belonging to the class that can only be used within the class
        
        /*
        Function:
            void XNODE::PrintCommand(char* node, char* command) 
        Overview:
            Sends the ID and the command through the serial port.
        Precondition:
            None.
        Input:
            char* node: X-NODE's ID; e.g. 016A, 007E.
            char* command: Commands for the X-NODEs; e.g GH, GT, GP.
        Output:
            none.
        */
        void PrintCommand(char* node, char* command);

        void PrintCommand(char* node, char* command, float val1, float val2);

        /*
        Function:
            int ReadBufferSerial(char* Buffer, bool _bufferException)
        Overview:
            Reads the serial port and stores the characters in "Buffer".
            Returns the number of characters read.
        Precondition:
            None.
        Input:
            char* Buffer: XNODE´s Answer from the serial port.
            bool _bufferException: Checks if the connection meets with the correct conditions.
        Output:
            Int: Number of characters read.
        */
        int ReadBufferSerial(char* Buffer, bool _bufferException);
        
        /*
        Function:
            bool XNODE::CheckModel(char* Buffer, char* node)
        Overview:
            Returns a bool value when deciding if the evaluation is 
            true or false.
        Precondition:
            None.
        Input:
            char* Buffer: XNODE´s Answer from the serial port.
            char* node: X-NODE's ID; e.g. 016A, 007E
        Output:
            Bool: Comparison result.
        */
        bool CheckModel(char* Buffer, char* ID);
        
        /*
        Function:
            void XNODE::SerialDebugGet(char* node, char* command, char* Buffer)
        Overview:
            If the constructor method defines a second serial port, this function will be in charge 
            of verifying which one has been defined and will show through it which data is being 
            sent through the transmission serial port to the node. Tts particular use is to monitor 
            information request type commands.
        Precondition:
            A second serial port is defined in the constructor.
        Input:
            char* node: X-NODE's ID; e.g. 016A, 007E.
            char* command: Commands for the X-NODEs; R, G, F, S.
            char* Buffer: XNODE´s Answer from the serial port.
        Output:
            none
        */
        void SerialDebugSet(char* node, char* command, char* value);
        
        /*
        Function:
            void XNODE::SerialDebugSet(char* node, char* command, char* value)
        Overview:
            If the constructor method defines a second serial port, this function will be in charge 
            of verifying which one has been defined and will show through it which data is being 
            sent through the transmission serial port to the node. Its particular use is to monitor 
            action request type commands.
        Precondition:
            A second serial port is defined in the constructor.
        Input:
            char* node: X-NODE's ID; e.g. 016A, 007E.
            char* command: Commands for the X-NODEs; R, G, F, S.
            char* value: Command's value; e.g. 101010, 00001111.
        Output:
            none
        */
        void SerialDebugGet(char* node, char* command, char* Buffer);

        /*
        Function:
            float XNODE::StringtoFloat(char* Buffer)
        Overview:
            Performs the conversion of a numeric value in string type format 
            to a float type format.
        Precondition:
            None.
        Input:
            char* Buffer: XNODE´s Answer from the serial port.
        Output:
            float: The X-NODE's response as a float.
        */
        float StringtoFloat(char* Buffer);
        
        /*
        Function:
            int XNODE::StringtoInt(char* Buffer)
        Overview:
            Performs the conversion of a numeric value in string type format 
            to an Integer type format.
        Precondition:
            None.
        Input:
            char* Buffer: XNODE´s Answer from the serial port.
        Output:
            int: The X-NODE's response as an Integer.
        */
        int StringtoInt(char* Buffer);

        /*
        Function:
            void errorMessage()
        Overview:
            Sends a message of possible solutions to a specific error.
        Precondition:
            none
        Input:
            none
        Output:
            none
        */
        void errorMessage();
};

#endif

