/*
 * Decompiled with CFR 0.152.
 */
package dev.banzetta.toastmanager;

import dev.banzetta.toastmanager.ManagedToastComponent;
import dev.banzetta.toastmanager.ToastManagerConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraftforge.api.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ToastManager
implements ClientModInitializer {
    public static final String MODID = "toastmanager";
    public static final Logger LOGGER = LogManager.getLogger((String)"toastmanager");
    public static final class_304 CLEAR = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.toastmanager.clear", class_3675.class_307.field_1668, 74, "key.toastmanager.category"));
    public static final class_2960 TRANSLUCENT = new class_2960("toastmanager", "textures/gui/toasts.png");
    public static final class_2960 TRANSPARENT = new class_2960("toastmanager", "textures/gui/toasts2.png");
    public static final class_2960 ORIGINAL = new class_2960("textures/gui/toasts.png");
    public static final List<Class<?>> BLOCKED_CLASSES = new ArrayList();
    public static List<ManagedToastComponent.ManagedToastInstance<?>> tracker = new ArrayList();

    public void onInitializeClient() {
        ModLoadingContext.registerConfig((String)MODID, (ModConfig.Type)ModConfig.Type.CLIENT, (IConfigSpec)ToastManagerConfig.SPEC);
        class_310.method_1551().field_1702 = new ManagedToastComponent();
        ClientTickEvents.END_CLIENT_TICK.register(ToastManager::onEndClientTick);
        ToastManager.handleToastReloc();
        ToastManager.handleBlockedClasses();
    }

    public static void onEndClientTick(class_310 minecraft) {
        if (CLEAR.method_1434()) {
            class_310.method_1551().method_1566().method_2000();
        }
        for (ManagedToastComponent.ManagedToastInstance<?> t : tracker) {
            t.tick();
        }
    }

    static void handleToastReloc() {
        if (((Boolean)ToastManagerConfig.INSTANCE.transparent.get()).booleanValue()) {
            ToastManager.updateToastTexture(TRANSPARENT);
        } else if (((Boolean)ToastManagerConfig.INSTANCE.translucent.get()).booleanValue()) {
            ToastManager.updateToastTexture(TRANSLUCENT);
        } else {
            ToastManager.updateToastTexture(ORIGINAL);
        }
    }

    private static void updateToastTexture(class_2960 newTexture) {
        try {
            Field namespaceField = class_2960.class.getDeclaredField("field_13353");
            Field pathField = class_2960.class.getDeclaredField("field_13355");
            namespaceField.setAccessible(true);
            pathField.setAccessible(true);
            namespaceField.set(class_368.field_2207, newTexture.method_12836());
            pathField.set(class_368.field_2207, newTexture.method_12832());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.error("Could not update toast texture", (Throwable)e);
        }
    }

    static void handleBlockedClasses() {
        BLOCKED_CLASSES.clear();
        for (String s : (List)ToastManagerConfig.INSTANCE.blockedClasses.get()) {
            try {
                Class<?> c = Class.forName(s);
                BLOCKED_CLASSES.add(c);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Invalid class string provided to Toast Manager: " + s);
            }
        }
    }
}

