/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.progressivebosses.module.dragon.phase.CrystalRespawnPhase;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.RandomHelper;
import insane96mcp.progressivebosses.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1521;
import net.minecraft.class_1527;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2389;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3033;
import net.minecraft.class_3218;
import net.minecraft.class_3310;
import net.minecraft.class_3532;
import net.minecraft.class_5281;

@ConfigEntries
@Label(name="Crystals", description="Makes more Crystal spawn and with more cages.")
public class CrystalFeature
implements LabelConfigGroup {
    @ConfigEntry(translationKey="More Cages at Difficulty", comment="At this difficulty cages will start to appear around other crystals too. -1 will disable this feature.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int moreCagesAtDifficulty = 1;
    @ConfigEntry(translationKey="Max Bonus Cages", comment="Max number of bonus cages that can spawn around the crystals.")
    @ConfigEntry.BoundedInteger(min=0, max=8)
    public int maxBonusCages = 6;
    @ConfigEntry(translationKey="More Crystals at Difficulty", comment="At this difficulty one crystal will start to appear inside obsidian towers. -1 will disable this feature.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int moreCrystalsAtDifficulty = 2;
    @ConfigEntry(translationKey="More Crystals Step", comment="Every how much difficulty one more crystal will be spawned inside towers")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int moreCrystalsStep = 3;
    @ConfigEntry(translationKey="More Crystals Max", comment="Max number of bonus crystals that can spawn inside the towers.")
    @ConfigEntry.BoundedInteger(min=0, max=10)
    public int moreCrystalsMax = 3;
    @ConfigEntry(translationKey="Enable crystal respawn", comment="Everytime the dragon is hit (when below 50% of health) there's a chance to to trigger a Crystal respawn Phase. The chance is 0% when health >=50% and 100% when health <=30%, the health threshold decreases by 20% every time the dragon respawns crystals.")
    public boolean enableCrystalRespawn = true;
    @ConfigEntry(translationKey="Crystal Respawn Per Difficulty", comment="Difficulty multiplied by this number will output how many crystals will the dragon respawn.")
    @ConfigEntry.BoundedDouble(min=0.0, max=10.0)
    public double crystalRespawnPerDifficulty = 0.375;
    @ConfigEntry(translationKey="Explosion Immune", comment="Crystals can no longer be destroyed by other explosions.")
    public boolean explosionImmune = true;
    @ConfigEntries.Exclude
    private static final List<class_1527<? extends class_1521>> VALID_CRYSTAL_RESPAWN_PHASES = Arrays.asList(class_1527.field_7081, class_1527.field_7073, class_1527.field_7072, class_1527.field_7069, class_1527.field_7077, class_1527.field_7078, class_1527.field_7076);
    @ConfigEntries.Exclude
    private static final class_2960 ENDERGETIC_CRYSTAL_HOLDER_RL = new class_2960("endergetic:crystal_holder");

    public CrystalFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.HURT.register(event -> this.onDragonDamage(event));
    }

    public void onDragonDamage(LivingEntityEvents.OnLivingHurtEvent event) {
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        if (!this.enableCrystalRespawn) {
            return;
        }
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = dragonTags.method_10583("progressivebosses:difficulty");
        if (!VALID_CRYSTAL_RESPAWN_PHASES.contains(dragon.method_6831().method_6864().method_6849())) {
            return;
        }
        float healthRatio = dragon.method_6032() / dragon.method_6063();
        if ((double)healthRatio >= 0.8) {
            return;
        }
        byte crystalRespawn = dragonTags.method_10571("progressivebosses:crystal_respawn");
        float chance = this.getChanceAtValue(healthRatio, 0.8f - (float)crystalRespawn * 0.35f, 0.2f - (float)crystalRespawn * 0.35f);
        if (dragon.method_6051().nextFloat() > chance) {
            return;
        }
        dragonTags.method_10567("progressivebosses:crystal_respawn", (byte)(crystalRespawn + 1));
        double crystalsRespawned = class_3532.method_15350((double)((double)difficulty * this.crystalRespawnPerDifficulty), (double)0.0, (double)10.0);
        crystalsRespawned = Utils.getAmountWithDecimalChance(dragon.method_6051(), crystalsRespawned);
        if (crystalsRespawned == 0.0) {
            return;
        }
        dragon.method_6831().method_6863(CrystalRespawnPhase.getPhaseType());
        CrystalRespawnPhase phase = (CrystalRespawnPhase)dragon.method_6831().method_6864();
        ArrayList<class_3310.class_3181> spikes = new ArrayList<class_3310.class_3181>(class_3310.method_14506((class_5281)((class_3218)dragon.field_6002)));
        spikes.sort(Comparator.comparingInt(class_3310.class_3181::method_13963).reversed());
        int i = 0;
        while ((double)i < crystalsRespawned) {
            class_3310.class_3181 targetSpike = (class_3310.class_3181)spikes.get(i);
            phase.addCrystalRespawn(targetSpike);
            ++i;
        }
    }

    private float getChanceAtValue(float value, float max, float min) {
        return class_3532.method_15363((float)((max - min - (value - min)) / (max - min)), (float)0.0f, (float)1.0f);
    }

    public void onSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = dragonTags.method_10583("progressivebosses:difficulty");
        this.crystalCages(dragon, difficulty);
        this.moreCrystals(dragon, difficulty);
    }

    private void crystalCages(class_1510 dragon, float difficulty) {
        if (this.moreCagesAtDifficulty == -1 || this.maxBonusCages == 0) {
            return;
        }
        if (difficulty < (float)this.moreCagesAtDifficulty) {
            return;
        }
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        if (dragonTags.method_10545("progressivebosses:crystal_cages")) {
            return;
        }
        dragonTags.method_10556("progressivebosses:crystal_cages", true);
        ArrayList<class_1511> crystals = new ArrayList<class_1511>();
        ArrayList<class_3310.class_3181> spikes = new ArrayList<class_3310.class_3181>(class_3310.method_14506((class_5281)((class_3218)dragon.field_6002)));
        spikes.sort(Comparator.comparingInt(class_3310.class_3181::method_13963));
        for (class_3310.class_3181 spike : spikes) {
            crystals.addAll(dragon.field_6002.method_18467(class_1511.class, spike.method_13968()));
        }
        crystals.removeIf(c -> c.field_6002.method_8320(c.method_24515().method_10086(2)).method_26204() == class_2246.field_10576);
        int crystalsInvolved = Math.round(difficulty - (float)this.moreCagesAtDifficulty + 1.0f);
        int cagesGenerated = 0;
        for (class_1511 crystal : crystals) {
            CrystalFeature.generateCage(crystal.field_6002, crystal.method_24515());
            if (++cagesGenerated != crystalsInvolved && cagesGenerated != this.maxBonusCages) continue;
            break;
        }
    }

    private void moreCrystals(class_1510 dragon, float difficulty) {
        if (this.moreCrystalsAtDifficulty == -1 || this.moreCrystalsMax == 0) {
            return;
        }
        if (difficulty < (float)this.moreCrystalsAtDifficulty) {
            return;
        }
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        if (dragonTags.method_10545("progressivebosses:more_crystals")) {
            return;
        }
        dragonTags.method_10556("progressivebosses:more_crystals", true);
        ArrayList crystals = new ArrayList();
        ArrayList<class_3310.class_3181> spikes = new ArrayList<class_3310.class_3181>(class_3310.method_14506((class_5281)((class_3218)dragon.field_6002)));
        spikes.sort(Comparator.comparingInt(class_3310.class_3181::method_13963));
        for (class_3310.class_3181 spike : spikes) {
            crystals.addAll(dragon.field_6002.method_8390(class_1511.class, spike.method_13968(), class_1511::method_6836));
        }
        int crystalsMax = (int)Math.ceil((difficulty + 1.0f - (float)this.moreCrystalsAtDifficulty) / (float)this.moreCrystalsStep);
        if (crystalsMax <= 0) {
            return;
        }
        int crystalSpawned = 0;
        for (class_1511 crystal : crystals) {
            CrystalFeature.generateCrystalInTower(dragon.field_6002, crystal.method_23317(), crystal.method_23318(), crystal.method_23321());
            if (++crystalSpawned != crystalsMax && crystalSpawned != this.moreCrystalsMax) continue;
            break;
        }
    }

    public boolean onDamageFromExplosion(class_1511 enderCrystalEntity, class_1282 source) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.explosionImmune) {
            return false;
        }
        return source.method_5535();
    }

    public static class_1511 generateCrystalInTower(class_1937 world, double x, double y, double z) {
        class_243 centerPodium = class_243.method_24955((class_2382)world.method_8598(class_2902.class_2903.field_13203, class_3033.field_13600));
        int spawnY = (int)(y - (double)RandomHelper.getInt(world.method_8409(), 12, 24));
        if ((double)spawnY < centerPodium.method_10214()) {
            spawnY = (int)centerPodium.method_10214();
        }
        class_2338 crystalPos = new class_2338(x, (double)spawnY, z);
        Stream blocks = class_2338.method_20437((class_2338)crystalPos.method_10069(-1, -1, -1), (class_2338)crystalPos.method_10069(1, 1, 1));
        blocks.forEach(pos -> world.method_8501(pos, class_2246.field_10124.method_9564()));
        class_2680 baseBlockState = class_2246.field_9987.method_9564();
        if (class_2378.field_11146.method_10250(ENDERGETIC_CRYSTAL_HOLDER_RL)) {
            baseBlockState = ((class_2248)class_2378.field_11146.method_10223(ENDERGETIC_CRYSTAL_HOLDER_RL)).method_9564();
        }
        world.method_8501(crystalPos.method_10069(0, -1, 0), baseBlockState);
        world.method_8437(null, (double)((float)crystalPos.method_10263() + 0.5f), (double)crystalPos.method_10264(), (double)crystalPos.method_10260() + 0.5, 5.0f, class_1927.class_4179.field_18687);
        class_1511 crystal = new class_1511(world, (double)crystalPos.method_10263() + 0.5, (double)crystalPos.method_10264(), (double)crystalPos.method_10260() + 0.5);
        world.method_8649((class_1297)crystal);
        return crystal;
    }

    public static void generateCage(class_1937 world, class_2338 pos) {
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (int k = -2; k <= 2; ++k) {
            for (int l = -2; l <= 2; ++l) {
                for (int i1 = 0; i1 <= 3; ++i1) {
                    boolean flag2;
                    boolean flag = class_3532.method_15382((int)k) == 2;
                    boolean flag1 = class_3532.method_15382((int)l) == 2;
                    boolean bl = flag2 = i1 == 3;
                    if (!flag && !flag1 && !flag2) continue;
                    boolean flag3 = k == -2 || k == 2 || flag2;
                    boolean flag4 = l == -2 || l == 2 || flag2;
                    class_2680 blockstate = (class_2680)((class_2680)((class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2389.field_10905, (Comparable)Boolean.valueOf(flag3 && l != -2))).method_11657((class_2769)class_2389.field_10904, (Comparable)Boolean.valueOf(flag3 && l != 2))).method_11657((class_2769)class_2389.field_10903, (Comparable)Boolean.valueOf(flag4 && k != -2))).method_11657((class_2769)class_2389.field_10907, (Comparable)Boolean.valueOf(flag4 && k != 2));
                    world.method_8501((class_2338)blockpos$mutable.method_10103(pos.method_10263() + k, pos.method_10264() - 1 + i1, pos.method_10260() + l), blockstate);
                }
            }
        }
    }
}

