/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import com.google.common.util.concurrent.AtomicDouble;
import insane96mcp.progressivebosses.AComponents;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;

@ConfigEntries
@Label(name="Difficulty Settings", description="How difficulty is handled for the Dragon.")
public class DifficultyFeature
implements LabelConfigGroup {
    @ConfigEntry(translationKey="Sum Killed Dragons Difficulty", comment="If false and there's more than 1 player around the Dragon, difficulty will be the average of all the players' difficulty instead of summing them.")
    public boolean sumKilledDragonDifficulty = false;
    @ConfigEntry(translationKey="Bonus Difficulty per Player", comment="Percentage bonus difficulty added to the Dragon when more than one player is present. Each player past the first one will add this percentage to the difficulty.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double bonusDifficultyPerPlayer = 0.25;
    @ConfigEntry(translationKey="Max Difficulty", comment="The Maximum difficulty (times killed) reachable by Ender Dragon. By default is set to 24 because it's the last spawning end gate.")
    @ConfigEntry.BoundedInteger(min=1, max=0x7FFFFFFF)
    public int maxDifficulty = 8;
    @ConfigEntry(translationKey="Starting Difficulty", comment="How much difficulty will players start with when joining a world? Note that this will apply when the player joins the world if the current player difficulty is below this value.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int startingDifficulty = 0;
    @ConfigEntry(translationKey="Show First Killed Dragon Message", comment="Set to false to disable the first Dragon killed message.")
    public boolean showFirstKilledDragonMessage = true;

    public DifficultyFeature(LabelConfigGroup config) {
        config.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.DEATH.register(event -> this.onDeath(event));
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.setPlayerData(new DummyEvent((class_1937)world, entity)));
    }

    public void onSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        if (dragon.method_6829() == null) {
            return;
        }
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        if (dragonTags.method_10545("progressivebosses:difficulty")) {
            return;
        }
        int radius = 256;
        class_2338 pos1 = new class_2338(-radius, -radius, -radius);
        class_2338 pos2 = new class_2338(radius, radius, radius);
        class_238 bb = new class_238(pos1, pos2);
        List players = event.getWorld().method_8390(class_3222.class, bb, entity -> true);
        if (players.size() == 0) {
            return;
        }
        AtomicInteger playersFirstDragon = new AtomicInteger(0);
        AtomicDouble dragonDifficulty = new AtomicDouble(0.0);
        for (class_3222 player : players) {
            AComponents.DF.maybeGet((Object)player).ifPresent(difficulty -> {
                dragonDifficulty.addAndGet((double)difficulty.getKilledDragons());
                if (difficulty.getFirstDragon() == 1) {
                    playersFirstDragon.incrementAndGet();
                    difficulty.setFirstDragon((byte)2);
                }
            });
        }
        dragonTags.method_10569("progressivebosses:eggs_to_drop", playersFirstDragon.get());
        if (!this.sumKilledDragonDifficulty) {
            dragonDifficulty.set(dragonDifficulty.get() / (double)players.size());
        }
        if (players.size() > 1) {
            dragonDifficulty.set(dragonDifficulty.get() * (1.0 + (double)(players.size() - 1) * this.bonusDifficultyPerPlayer));
        }
        dragonTags.method_10548("progressivebosses:difficulty", (float)dragonDifficulty.get());
    }

    public void onDeath(LivingEntityEvents.OnLivingDeathEvent event) {
        if (event.getEntity().field_6002.field_9236) {
            return;
        }
        class_1309 class_13092 = event.getEntity();
        if (!(class_13092 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_13092;
        int radius = 256;
        class_2338 pos1 = new class_2338(-radius, -radius, -radius);
        class_2338 pos2 = new class_2338(radius, radius, radius);
        class_238 bb = new class_238(pos1, pos2);
        List players = dragon.field_6002.method_18467(class_3222.class, bb);
        if (players.size() == 0) {
            class_3222 nearestPlayer = (class_3222)dragon.field_6002.method_18459(dragon.method_23317(), dragon.method_23318(), dragon.method_23321(), Double.MAX_VALUE, true);
            players.add(nearestPlayer);
        }
        for (class_3222 player : players) {
            AComponents.DF.maybeGet((Object)player).ifPresent(difficulty -> {
                if (difficulty.getKilledDragons() <= this.startingDifficulty && this.showFirstKilledDragonMessage) {
                    player.method_7353((class_2561)new class_2588("dragon.first_killed"), true);
                }
                if (difficulty.getKilledDragons() < this.maxDifficulty) {
                    difficulty.addKilledDragons(1);
                }
            });
        }
    }

    public void setPlayerData(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_12972;
        AComponents.DF.maybeGet((Object)player).ifPresent(difficulty -> {
            if (difficulty.getKilledDragons() < this.startingDifficulty) {
                difficulty.setKilledDragons(this.startingDifficulty);
                LogHelper.info("[Progressive Bosses] %s killed dragons counter was below the set 'Starting Difficulty', Has been increased to match 'Starting Difficulty'", player.method_5477().getString());
            }
            if (difficulty.getKilledDragons() > this.maxDifficulty) {
                difficulty.setKilledDragons(this.maxDifficulty);
                LogHelper.info("[Progressive Bosses] %s killed dragons counter was above the 'Max Difficulty', Has been decreased to match 'Max Difficulty'", player.method_5477().getString());
            }
            if (difficulty.getFirstDragon() == 0) {
                difficulty.setFirstDragon((byte)1);
                LogHelper.info("[Progressive Bosses] %s first spawned. Set First Dragon to 1", player.method_5477().getString());
            }
        });
    }
}

