/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.progressivebosses.utils.Drop;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;

@ConfigEntries
@Label(name="Rewards", description="Bonus Experience and Dragon Egg per player")
public class RewardFeature
implements LabelConfigGroup {
    @ConfigEntry(translationKey="Bonus Experience per Difficulty", comment="How much more experience (percentage) will Dragon drop per Difficulty. The percentage is additive (e.g. with this set to 100%, 7 dragons killed = 700% more experience)")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double bonusExperience = 4.5;
    @ConfigEntry(translationKey="Dragon Egg per Player", comment="If true whenever a player, that has never killed the dragon, kills the dragon a Dragon Egg \u00ec\u00ec will drop. E.g. If 2 players kill the Dragon for the first time, she will drop 2 Dragon Eggs")
    public boolean dragonEggPerPlayer = true;
    @ConfigEntry(translationKey="Drops", comment="A list of drops for the Dragons. Entry format: item,amount,difficulty_required,chance,difficulty_mode,chance_mode\nitem: item id\namount: amount\ndifficulty_required: the amount of difficulty required for the item to drop, works differently based on mode\nchance: chance for the drop to happen, between 0 and 1\ndifficulty_mode:\n* MINIMUM: will try to drop the item when the difficulty matches or is higher\n* PER_DIFFICULTY: will try to drop the item once per difficulty (e.g. at difficulty 10, difficulty required 3, the chance to drop the item is tried 7 times)\nchance_mode:\n* FLAT: chance is the percentage chance for the item to drop if the difficulty criteria matches\n* SCALING: each point of difficulty >= 'difficulty to drop the item' will be multiplied by the chance (e.g. difficulty 10, chance 2% and difficulty required 5, chance to drop the item will be chance * (difficulty - difficulty_required + 1) = 2% * (10 - 5 + 1) = 12%)")
    private static List<String> dropsListConfig = Arrays.asList("minecraft:enchanted_golden_apple,1,5,0.10,MINIMUM,SCALING");
    @ConfigEntries.Exclude
    public ArrayList<Drop> dropsList;

    public RewardFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        this.dropsList = Drop.parseDropsList(dropsListConfig);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.DEATH.register(event -> this.onDeath(event));
        LivingEntityEvents.TICK.register(entity -> this.onUpdate(new DummyEvent(entity.field_6002, (class_1297)entity)));
    }

    public void onSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        if (this.bonusExperience == 0.0) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = dragonTags.method_10583("progressivebosses:difficulty");
        dragon.field_6194 = (int)((double)dragon.field_6194 * (this.bonusExperience * (double)difficulty));
    }

    public void onUpdate(DummyEvent event) {
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        this.dropEgg(dragon);
    }

    private void dropEgg(class_1510 dragon) {
        if (!this.dragonEggPerPlayer) {
            return;
        }
        if (dragon.field_7031 != 100) {
            return;
        }
        class_2487 tags = ((IEntityExtraData)dragon).getPersistentData();
        int eggsToDrop = tags.method_10550("progressivebosses:eggs_to_drop");
        if (dragon.method_6829() != null && !dragon.method_6829().method_12536()) {
            --eggsToDrop;
        }
        for (int i = 0; i < eggsToDrop; ++i) {
            dragon.field_6002.method_8501(new class_2338(0, 255 - i, 0), class_2246.field_10081.method_9564());
        }
    }

    public void onDeath(LivingEntityEvents.OnLivingDeathEvent event) {
        if (this.dropsList.isEmpty()) {
            return;
        }
        class_1309 class_13092 = event.getEntity();
        if (!(class_13092 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_13092;
        class_2487 tags = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = tags.method_10583("progressivebosses:difficulty");
        for (Drop drop : this.dropsList) {
            drop.drop(dragon.field_6002, dragon.method_19538(), difficulty);
        }
    }
}

