/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.progressivebosses.module.dragon.ai.DragonMinionAttackGoal;
import insane96mcp.progressivebosses.module.dragon.ai.PBNearestAttackableTargetGoal;
import insane96mcp.progressivebosses.utils.DragonMinionHelper;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.MCUtils;
import insane96mcp.progressivebosses.utils.RandomHelper;
import insane96mcp.progressivebosses.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1510;
import net.minecraft.class_1606;
import net.minecraft.class_1678;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2902;
import net.minecraft.class_3033;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_5134;

@ConfigEntries
@Label(name="Minions", description="Shulkers that will make you float around.")
public class MinionFeature
implements LabelConfigGroup {
    @ConfigEntry(translationKey="Minion at Difficulty", comment="At which difficulty the Ender Dragon starts spawning Minions")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int minionAtDifficulty = 1;
    @ConfigEntry(translationKey="Minimum Cooldown", comment="Minimum ticks (20 ticks = 1 seconds) after Minions can spwan.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int minCooldown = 1400;
    @ConfigEntry(translationKey="Maximum Cooldown", comment="Maximum ticks (20 ticks = 1 seconds) after Minions can spwan.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int maxCooldown = 2000;
    @ConfigEntry(translationKey="Cooldown Reduction", comment="Percentage cooldown reduction per difficulty for the cooldown of Minion spawning.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double cooldownReduction = 0.05;
    @ConfigEntry(translationKey="Blinding Chance", comment="Percentage chance per difficulty for a Minion to spawn as a Blinding Minion.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double blindingChance = 0.05;
    @ConfigEntry(translationKey="Blinding duration", comment="Time (in ticks) for the bliding effect when hit by a blinding bullet.")
    @ConfigEntry.BoundedInteger(min=0, max=6000)
    public int blindingDuration = 150;
    @ConfigEntry(translationKey="Reduced Dragon Damage", comment="If true, Dragon Minions will take only 10% damage from the Ender Dragon.")
    public boolean reducedDragonDamage = true;

    public MinionFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        if (this.minCooldown > this.maxCooldown) {
            this.minCooldown = this.maxCooldown;
        }
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onDragonSpawn(new DummyEvent((class_1937)world, entity)));
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onShulkerSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.TICK.register(entity -> this.update(new DummyEvent(entity.field_6002, (class_1297)entity)));
        LivingEntityEvents.HURT.register(event -> this.onMinionHurt(event));
    }

    public void onDragonSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        int cooldown = (int)((double)RandomHelper.getInt(dragon.method_6051(), this.minCooldown, this.maxCooldown) * 0.5);
        dragonTags.method_10569("progressivebosses:dragon_minion_cooldown", cooldown);
    }

    public void onShulkerSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1606)) {
            return;
        }
        class_1606 shulker = (class_1606)class_12972;
        class_2487 tags = ((IEntityExtraData)shulker).getPersistentData();
        if (!tags.method_10545("progressivebosses:dragon_minion")) {
            return;
        }
        MinionFeature.setMinionAI(shulker);
    }

    public void update(DummyEvent event) {
        if (event.getEntity().field_6002.field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        class_1937 world = event.getEntity().field_6002;
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = dragonTags.method_10583("progressivebosses:difficulty");
        if (difficulty < (float)this.minionAtDifficulty) {
            return;
        }
        if (dragon.method_6032() <= 0.0f) {
            return;
        }
        int cooldown = dragonTags.method_10550("progressivebosses:dragon_minion_cooldown");
        if (cooldown > 0) {
            dragonTags.method_10569("progressivebosses:dragon_minion_cooldown", cooldown - 1);
            return;
        }
        class_2338 centerPodium = dragon.field_6002.method_8598(class_2902.class_2903.field_13203, class_3033.field_13600);
        class_238 bb = new class_238(centerPodium).method_1014(64.0);
        List players = world.method_18467(class_3222.class, bb);
        if (players.isEmpty()) {
            return;
        }
        int minCooldown = this.minCooldown;
        int maxCooldown = this.maxCooldown;
        cooldown = RandomHelper.getInt(world.field_9229, minCooldown, maxCooldown);
        cooldown = (int)((double)cooldown * (1.0 - this.cooldownReduction * (double)difficulty));
        dragonTags.method_10569("progressivebosses:dragon_minion_cooldown", cooldown - 1);
        float angle = world.field_9229.nextFloat() * (float)Math.PI * 2.0f;
        float x = (float)(Math.cos(angle) * (double)RandomHelper.getFloat(dragon.method_6051(), 16.0f, 45.0f));
        float z = (float)(Math.sin(angle) * (double)RandomHelper.getFloat(dragon.method_6051(), 16.0f, 45.0f));
        float y = world.method_8598(class_2902.class_2903.field_13197, new class_2338((double)x, 255.0, (double)z)).method_10264();
        this.summonMinion(world, new class_243((double)x, (double)y, (double)z), difficulty);
    }

    private static void setMinionAI(class_1606 shulker) {
        ArrayList<class_1352> toRemove = new ArrayList<class_1352>();
        shulker.field_6201.field_6461.forEach(goal -> {
            if (goal.method_19058() instanceof class_1606.class_1607) {
                toRemove.add(goal.method_19058());
            }
        });
        toRemove.forEach(arg_0 -> ((class_1355)shulker.field_6201).method_6280(arg_0));
        shulker.field_6201.method_6277(2, (class_1352)new DragonMinionAttackGoal(shulker, 70));
        toRemove.clear();
        shulker.field_6185.field_6461.forEach(goal -> {
            if (goal.method_19058() instanceof class_1400) {
                toRemove.add(goal.method_19058());
            }
            if (goal.method_19058() instanceof class_1399) {
                toRemove.add(goal.method_19058());
            }
        });
        toRemove.forEach(arg_0 -> ((class_1355)shulker.field_6185).method_6280(arg_0));
        shulker.field_6185.method_6277(2, (class_1352)new PBNearestAttackableTargetGoal((class_1308)shulker));
        shulker.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)shulker, new Class[]{class_1606.class, class_1510.class}));
    }

    public class_1606 summonMinion(class_1937 world, class_243 pos, float difficulty) {
        class_1606 shulker = new class_1606(class_1299.field_6109, world);
        class_2487 minionTags = ((IEntityExtraData)shulker).getPersistentData();
        minionTags.method_10556("progressivebosses:dragon_minion", true);
        minionTags.method_10556("mobspropertiesrandomness:processed", true);
        boolean isBlindingMinion = world.method_8409().nextDouble() < this.blindingChance * (double)difficulty;
        shulker.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        shulker.method_5665((class_2561)new class_2588("progressivebosses:dragon_minion"));
        shulker.field_6198 = class_39.field_844;
        shulker.method_5971();
        DragonMinionHelper.setMinionColor(shulker, isBlindingMinion);
        MCUtils.applyModifier((class_1309)shulker, class_5134.field_23717, Strings.AttributeModifiers.FOLLOW_RANGE_BONUS_UUID, "progressivebosses:follow_range_bonus", 64.0, class_1322.class_1323.field_6328);
        world.method_8649((class_1297)shulker);
        return shulker;
    }

    public void onMinionHurt(LivingEntityEvents.OnLivingHurtEvent event) {
        if (!this.reducedDragonDamage) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1606)) {
            return;
        }
        class_1606 shulker = (class_1606)class_12972;
        class_2487 compoundNBT = ((IEntityExtraData)shulker).getPersistentData();
        if (!compoundNBT.method_10545("progressivebosses:dragon_minion")) {
            return;
        }
        if (event.getSource().method_5526() instanceof class_1510) {
            event.setAmount(event.getAmount() * 0.1f);
        }
    }

    public void onBulletTick(class_1678 shulkerBulletEntity) {
        if (!shulkerBulletEntity.field_6002.field_9236 && ((IEntityExtraData)shulkerBulletEntity).getPersistentData().method_10577("progressivebosses:blindness_bullet")) {
            ((class_3218)shulkerBulletEntity.field_6002).method_14199((class_2394)class_2398.field_11226, shulkerBulletEntity.method_23317(), shulkerBulletEntity.method_23318(), shulkerBulletEntity.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

