/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.progressivebosses.module.wither.dispenser.WitherSkullDispenseBehavior;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.ExplosionEvents;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_3532;

@ConfigEntries
@Label(name="Misc", description="Handles various small features, such as the explosion")
public class MiscFeature
implements LabelConfigGroup {
    @ConfigEntry(translationKey="Explosion Power Bonus", comment="How much explosion power (after the invulnerability) will the Wither gain for each difficulty point. Explosion Radius is capped to 13. Base Wither Explosion Power is 7.0. Setting this to 0 will not increase the Wither Explosion Power.")
    @ConfigEntry.BoundedDouble(min=0.0, max=4.0)
    public double explosionPowerBonus = 1.0;
    @ConfigEntry(translationKey="Explosion Causes Fire at Difficulty", comment="At this difficulty the Wither Explosion will cause fire. Set to -1 to disable.")
    @ConfigEntry.BoundedInteger(min=-1, max=0x7FFFFFFF)
    public int explosionCausesFireAtDifficulty = 5;
    @ConfigEntry(translationKey="Faster Breaking Blocks", comment="The Wither will no longer wait 1.0 seconds before breaking blocks when he's hit, instead just 0.5s")
    public boolean fasterBlockBreaking = true;
    @ConfigEntry(translationKey="Bigger Breaking Blocks", comment="The Wither will break even blocks below him when hit.")
    public boolean biggerBlockBreaking = true;
    @ConfigEntry(translationKey="Ignore Witherproof Blocks", comment="If true the Wither will break even blocks that are witherproof. Unbreakable blocks will still be unbreakable, so it's really useful with other mods as in vanilla Wither Proof Blocks are all the unbreakable blocks.")
    public boolean ignoreWitherProofBlocks = false;
    @ConfigEntry(translationKey="Wither Nether Only", comment="The wither can only be spawned in the Nether.\nNote that this feature completely disables Wither Skulls from begin placed nearby Soul Sand when not in the Nether or when on the Nether Roof.\nRequires Minecraft restart.")
    public boolean witherNetherOnly = false;
    @ConfigEntries.Exclude
    private boolean behaviourRegistered = false;

    public MiscFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        if (this.witherNetherOnly && !this.behaviourRegistered) {
            class_2315.method_10009((class_1935)class_1802.field_8791, (class_2357)new WitherSkullDispenseBehavior());
            this.behaviourRegistered = true;
        }
        LivingEntityEvents.TICK.register(entity -> this.onUpdate(new DummyEvent(entity.field_6002, (class_1297)entity)));
        ExplosionEvents.EXPLODE.register(event -> this.onExplosion(event));
        LivingEntityEvents.HURT.register(event -> this.onWitherDamage(event));
    }

    public void onUpdate(DummyEvent event) {
        if (event.getEntity().field_6002.field_9236) {
            return;
        }
        if (!this.biggerBlockBreaking) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        if (!wither.method_5805()) {
            return;
        }
        if (wither.field_7082 == 1) {
            --wither.field_7082;
            int i1 = class_3532.method_15357((double)wither.method_23318());
            int l1 = class_3532.method_15357((double)wither.method_23317());
            int i2 = class_3532.method_15357((double)wither.method_23321());
            boolean flag = false;
            int yOffsetLow = -1;
            if (wither.method_6872()) {
                yOffsetLow = 0;
            }
            for (int k2 = -1; k2 <= 1; ++k2) {
                for (int l2 = -1; l2 <= 1; ++l2) {
                    for (int j = yOffsetLow; j <= 4; ++j) {
                        int i3 = l1 + k2;
                        int k = i1 + j;
                        int l = i2 + l2;
                        class_2338 blockpos = new class_2338(i3, k, l);
                        class_2680 blockstate = wither.field_6002.method_8320(blockpos);
                        if (!this.canWitherDestroy(wither, blockpos, blockstate)) continue;
                        flag = wither.field_6002.method_8651(blockpos, true, (class_1297)wither) || flag;
                    }
                }
            }
            if (flag) {
                wither.field_6002.method_8444(null, 1022, wither.method_24515(), 0);
            }
        }
    }

    private boolean canWitherDestroy(class_1528 wither, class_2338 pos, class_2680 state) {
        return !state.method_26215() && state.method_26214((class_1922)wither.field_6002, pos) >= 0.0f;
    }

    public void onExplosion(ExplosionEvents.OnExplosionEvent event) {
        if (this.explosionCausesFireAtDifficulty == -1 && this.explosionPowerBonus == 0.0) {
            return;
        }
        class_1309 class_13092 = event.getExplosion().method_8347();
        if (!(class_13092 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_13092;
        if (event.getExplosion().field_9190 != 7.0f) {
            return;
        }
        class_2487 tags = ((IEntityExtraData)wither).getPersistentData();
        float difficulty = tags.method_10583("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float explosionPower = (float)((double)event.getExplosion().field_9190 + this.explosionPowerBonus * (double)difficulty);
        if (explosionPower > 13.0f) {
            explosionPower = 13.0f;
        }
        event.getExplosion().field_9190 = explosionPower;
        event.getExplosion().field_9186 = difficulty >= (float)this.explosionCausesFireAtDifficulty;
    }

    public void onWitherDamage(LivingEntityEvents.OnLivingHurtEvent event) {
        if (event.getEntity().field_6002.field_9236) {
            return;
        }
        if (!this.fasterBlockBreaking) {
            return;
        }
        if (!event.getEntity().method_5805()) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        wither.field_7082 = 10;
    }

    public static boolean canPlaceSkull(class_1937 world, class_2338 pos) {
        boolean isNether = world.method_27983().method_29177().equals((Object)class_2874.field_24754.method_29177());
        boolean hasSoulSandNearby = false;
        for (class_2350 dir : class_2350.values()) {
            if (!world.method_8320(pos.method_10081(dir.method_10163())).method_26204().equals(class_2246.field_10114) && !world.method_8320(pos.method_10081(dir.method_10163())).method_26204().equals(class_2246.field_22090)) continue;
            hasSoulSandNearby = true;
            break;
        }
        return isNether && pos.method_10264() <= 127 || !hasSoulSandNearby;
    }
}

