/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.animations.BodyPart;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_591;
import net.minecraft.class_742;

public class LookAtItemAnimation
extends BasicAnimation {
    private Set<class_1792> holdingItems = new HashSet<class_1792>();
    private final BodyPart[] bothHands = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM};
    private BodyPart[] target = this.bothHands;

    @Override
    public boolean isEnabled() {
        this.bind();
        return NEAnimationsLoader.config.holdUpAllItems || !this.holdingItems.isEmpty();
    }

    private void bind() {
        this.holdingItems.clear();
        class_1792 invalid = (class_1792)class_2378.field_11142.method_10223(new class_2960("minecraft", "air"));
        for (String itemId : NEAnimationsLoader.config.holdingItems) {
            try {
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(itemId.split(":")[0], itemId.split(":")[1]));
                if (invalid == item) continue;
                this.holdingItems.add(item);
            }
            catch (Exception ex) {
                NEAnimationsLoader.LOGGER.info("Unknown item to add to the holding list: " + itemId);
            }
        }
    }

    @Override
    public boolean isValid(class_742 entity, PlayerData data) {
        boolean leftArm;
        class_1799 itemInRightHand = entity.method_5998(entity.method_6068() == class_1306.field_6182 ? class_1268.field_5810 : class_1268.field_5808);
        class_1799 itemInLeftHand = entity.method_5998(entity.method_6068() == class_1306.field_6183 ? class_1268.field_5810 : class_1268.field_5808);
        boolean rightArm = this.holdingItems.contains(itemInRightHand.method_7909()) || NEAnimationsLoader.config.holdUpAllItems && !itemInRightHand.method_7960() && (!entity.field_6252 || entity.method_6068() != class_1306.field_6183);
        boolean bl = leftArm = this.holdingItems.contains(itemInLeftHand.method_7909()) || NEAnimationsLoader.config.holdUpAllItems && !itemInLeftHand.method_7960() && (!entity.field_6252 || entity.method_6068() != class_1306.field_6182);
        if (rightArm && leftArm) {
            this.target = this.bothHands;
            return true;
        }
        if (rightArm) {
            this.target = this.right;
            return true;
        }
        if (leftArm) {
            this.target = this.left;
            return true;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(class_742 entity, PlayerData data) {
        return this.target;
    }

    @Override
    public int getPriority(class_742 entity, PlayerData data) {
        return 300;
    }

    @Override
    public void apply(class_742 entity, PlayerData data, class_591<class_742> model, BodyPart part, float delta, float tickCounter) {
        class_1306 arm = part == BodyPart.LEFT_ARM ? class_1306.field_6182 : class_1306.field_6183;
        AnimationUtil.applyArmTransforms(model, arm, -class_3532.method_16439((float)(-1.0f * (entity.method_36455() - 90.0f) / 180.0f), (float)1.0f, (float)1.5f), -0.2f, 0.3f);
    }
}

