echo "Installing Sky FABRICation 3"
echo "deleting old fabric loader, mods, configs, and kubejs data"
rm -rf kubejs
rm -rf config
rm -f packwiz-installer-bootstrap.jar
rm -f packwiz-installer.jar
rm -f fabric-server-launch.jar

download () {
  which wget >> /dev/null
  if [ $? -eq 0 ]; then
    echo "wget download: ${2}"
    wget -q --no-verbose --no-check-certificate -O "${2}" "${1}"
  else
    which curl >> /dev/null
    if [ $? -eq 0 ]; then
      echo "curl download:  ${2}"
      curl --no-progress-meter -OL "${1}"
    else
      echo "Neither wget or curl were found on your system. Please install one and try again"
      exit 0
    fi
  fi
}

download "https://github.com/packwiz/packwiz-installer-bootstrap/releases/download/v0.0.3/packwiz-installer-bootstrap.jar" "packwiz-installer-bootstrap.jar"
download "https://meta.fabricmc.net/v2/versions/loader/1.18.2/0.14.10/0.11.1/server/jar" "fabric-server-launch.jar"
if [ -f "jar" ]; then
    mv jar fabric-server-launch.jar
fi

echo "downloading modpack data ..."
java -jar packwiz-installer-bootstrap.jar -g -s server https://raw.githubusercontent.com/MSandro/sky_fabrication3/0.5.6/pack.toml | tail -1
if [ $? -eq 0 ]; then
  echo "java -jar fabric-server-launch.jar --nogui" > start.sh
  chmod +x start.sh
  echo "SF3 was installed successfull!"
  echo "type ./start.sh to start the server"
else
  echo "something went wrong! aborting ..."
fi
