/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui;

import com.ardublock.core.Context;
import com.ardublock.ui.listener.ArdublockWorkspaceListener;
import com.ardublock.ui.listener.GenerateCodeButtonListener;
import com.ardublock.ui.listener.NewButtonListener;
import com.ardublock.ui.listener.OpenButtonListener;
import com.ardublock.ui.listener.OpenblocksFrameListener;
import com.ardublock.ui.listener.SaveAsButtonListener;
import com.ardublock.ui.listener.SaveButtonListener;
import edu.mit.blocks.controller.WorkspaceController;
import edu.mit.blocks.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OpenblocksFrame
extends JFrame {
    private static final long serialVersionUID = 2841155965906223806L;
    private Context context = Context.getContext();
    private JFileChooser fileChooser;
    private FileFilter ffilter;
    private ResourceBundle uiMessageBundle;
    private String lastVersion = null;
    private String lastFile = null;

    public void addListener(OpenblocksFrameListener ofl) {
        this.context.registerOpenblocksFrameListener(ofl);
    }

    public String makeFrameTitle() {
        String title = "ArduBlock " + this.context.getSaveFileName();
        if (this.context.isWorkspaceChanged()) {
            title = String.valueOf(title) + " *";
        }
        return title;
    }

    public OpenblocksFrame() {
        this.setTitle(this.makeFrameTitle());
        this.setSize(new Dimension(1024, 760));
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(null);
        this.uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");
        this.fileChooser = new JFileChooser();
        this.ffilter = new FileNameExtensionFilter(this.uiMessageBundle.getString("ardublock.file.suffix"), "abp");
        this.fileChooser.setFileFilter(this.ffilter);
        this.fileChooser.addChoosableFileFilter(this.ffilter);
        this.initOpenBlocks();
    }

    private void initOpenBlocks() {
        final Context context = Context.getContext();
        final Workspace workspace = context.getWorkspace();
        workspace.addWorkspaceListener(new ArdublockWorkspaceListener(this));
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        JButton newButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.new"));
        newButton.addActionListener(new NewButtonListener(this));
        JButton saveButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.save"));
        saveButton.addActionListener(new SaveButtonListener(this));
        JButton saveAsButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.saveAs"));
        saveAsButton.addActionListener(new SaveAsButtonListener(this));
        JButton openButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.load"));
        openButton.addActionListener(new OpenButtonListener(this));
        JButton generateButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.upload"));
        generateButton.addActionListener(new GenerateCodeButtonListener(this, context));
        JButton serialMonitorButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.serialMonitor"));
        serialMonitorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                context.getEditor().handleSerial();
            }
        });
        JButton saveImageButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.saveImage"));
        saveImageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dimension size = workspace.getCanvasSize();
                System.out.println("size: " + size);
                BufferedImage bi = new BufferedImage(2560, 2560, 1);
                Graphics2D g = bi.createGraphics();
                double theScaleFactor = 4.166666666666667;
                g.scale(theScaleFactor, theScaleFactor);
                workspace.getBlockCanvas().getPageAt(0).getJComponent().paint(g);
                try {
                    try {
                        JFileChooser fc = new JFileChooser();
                        fc.setSelectedFile(new File("ardublock.png"));
                        int returnVal = fc.showSaveDialog(workspace.getBlockCanvas().getJComponent());
                        if (returnVal == 0) {
                            File file = fc.getSelectedFile();
                            ImageIO.write((RenderedImage)bi, "png", file);
                        }
                    }
                    catch (Exception exception) {
                        g.dispose();
                    }
                }
                finally {
                    g.dispose();
                }
            }
        });
        buttons.add(newButton);
        buttons.add(saveButton);
        buttons.add(saveAsButton);
        buttons.add(openButton);
        buttons.add(generateButton);
        buttons.add(serialMonitorButton);
        JPanel bottomPanel = new JPanel();
        JButton websiteButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.website"));
        websiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Desktop desktop;
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Locale locale = Locale.getDefault();
                        URL url = locale.getLanguage().equals("zh") ? new URL("http://bbs.makeblock.cc/?from=ardublock") : new URL("http://forum.makeblock.cc/#ardublock");
                        desktop.browse(url.toURI());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        JButton checkButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.checkupdate"));
        checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    OpenblocksFrame.this.parseXml("https://raw.githubusercontent.com/Makeblock-official/ardublock/master/config/version.xml");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        JLabel versionLabel = new JLabel("v " + this.uiMessageBundle.getString("ardublock.ui.version"));
        bottomPanel.add(saveImageButton);
        bottomPanel.add(checkButton);
        bottomPanel.add(websiteButton);
        bottomPanel.add(versionLabel);
        this.add((Component)buttons, "North");
        this.add((Component)bottomPanel, "South");
        this.add((Component)workspace, "Center");
    }

    public void parseXml(String fileName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fileName);
            Element root = document.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            System.out.println(root.getNodeName());
            if (root != null) {
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node child = nodeList.item(i);
                    Node node = child.getFirstChild();
                    while (node != null) {
                        if (node.getNodeType() == 1) {
                            if ("file".equals(node.getNodeName())) {
                                this.lastFile = node.getFirstChild().getNodeValue();
                            } else if ("version".equals(node.getNodeName())) {
                                this.lastVersion = node.getFirstChild().getNodeValue();
                            }
                        }
                        node = node.getNextSibling();
                    }
                    ++i;
                }
                final JDialog dialog = new JDialog();
                dialog.setTitle(this.uiMessageBundle.getString("ardublock.ui.checkupdate"));
                dialog.setBounds(this.getBounds().x + this.getBounds().width / 2 - 100, this.getBounds().y + this.getBounds().height / 2 - 50, 280, 140);
                dialog.setVisible(true);
                dialog.setResizable(false);
                JLabel label = new JLabel();
                label.setHorizontalAlignment(0);
                JButton updateButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.updatenow"));
                updateButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Desktop desktop;
                        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                            try {
                                URL url = new URL(OpenblocksFrame.this.lastFile);
                                desktop.browse(url.toURI());
                                dialog.setVisible(false);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                Container pane = dialog.getContentPane();
                if (this.lastVersion != null && this.lastFile != null) {
                    if (!this.lastVersion.equals(this.uiMessageBundle.getString("ardublock.ui.version"))) {
                        label.setText(this.uiMessageBundle.getString("ardublock.ui.versionmessage"));
                        pane.add(updateButton);
                        label.setBounds(18, 20, 240, 40);
                    } else {
                        label.setText(this.uiMessageBundle.getString("ardublock.ui.noversionmessage"));
                        label.setBounds(18, 30, 240, 40);
                    }
                    System.out.print("version:" + this.lastVersion + " current:" + this.uiMessageBundle.getString("ardublock.ui.version") + "\r\n");
                    System.out.print("file:" + this.lastFile);
                } else {
                    label.setBounds(18, 30, 240, 40);
                    label.setText(this.uiMessageBundle.getString("ardublock.ui.noversionmessage"));
                }
                pane.setLayout(null);
                updateButton.setBounds(85, 66, 100, 28);
                pane.add(label);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void savexmlUrl(String xmlUrl) {
        try {
            URL url = new URL(xmlUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            InputStream stream = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            StringBuffer document = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                document.append(line);
            }
            System.out.println(document);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doOpenArduBlockFile() {
        if (this.context.isWorkspaceChanged()) {
            int optionValue = JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.content.open_unsaved"), this.uiMessageBundle.getString("message.title.question"), 1, 3, null, null, 0);
            if (optionValue == 0) {
                this.doSaveArduBlockFile();
                this.loadFile();
            } else if (optionValue == 1) {
                this.loadFile();
            }
        } else {
            this.loadFile();
        }
        this.setTitle(this.makeFrameTitle());
    }

    private void loadFile() {
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            File savedFile = this.fileChooser.getSelectedFile();
            if (!savedFile.exists()) {
                JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.file_not_found"), this.uiMessageBundle.getString("message.title.error"), 0, 0, null, null, 0);
                return;
            }
            try {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.context.loadArduBlockFile(savedFile);
                    this.context.setWorkspaceChanged(false);
                }
                catch (IOException e) {
                    JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.file_not_found"), this.uiMessageBundle.getString("message.title.error"), 0, 0, null, null, 0);
                    e.printStackTrace();
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void doSaveArduBlockFile() {
        if (!this.context.isWorkspaceChanged()) {
            return;
        }
        String saveString = this.getArduBlockString();
        if (this.context.getSaveFilePath() == null) {
            this.chooseFileAndSave(saveString);
        } else {
            File saveFile = new File(this.context.getSaveFilePath());
            this.writeFileAndUpdateFrame(saveString, saveFile);
        }
    }

    public void doSaveAsArduBlockFile() {
        if (this.context.isWorkspaceEmpty()) {
            return;
        }
        String saveString = this.getArduBlockString();
        this.chooseFileAndSave(saveString);
    }

    private void chooseFileAndSave(String ardublockString) {
        File saveFile = this.letUserChooseSaveFile();
        if ((saveFile = this.checkFileSuffix(saveFile)) == null) {
            return;
        }
        if (saveFile.exists() && !this.askUserOverwriteExistedFile()) {
            return;
        }
        this.writeFileAndUpdateFrame(ardublockString, saveFile);
    }

    private String getArduBlockString() {
        WorkspaceController workspaceController = this.context.getWorkspaceController();
        return workspaceController.getSaveString();
    }

    private void writeFileAndUpdateFrame(String ardublockString, File saveFile) {
        try {
            this.saveArduBlockToFile(ardublockString, saveFile);
            this.context.setWorkspaceChanged(false);
            this.setTitle(this.makeFrameTitle());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File letUserChooseSaveFile() {
        int chooseResult = this.fileChooser.showSaveDialog(this);
        if (chooseResult == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    private boolean askUserOverwriteExistedFile() {
        int optionValue = JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.content.overwrite"), this.uiMessageBundle.getString("message.title.question"), 1, 3, null, null, 0);
        return optionValue == 0;
    }

    private void saveArduBlockToFile(String ardublockString, File saveFile) throws IOException {
        this.context.saveArduBlockFile(saveFile, ardublockString);
        this.context.setSaveFileName(saveFile.getName());
        this.context.setSaveFilePath(saveFile.getAbsolutePath());
    }

    public void doNewArduBlockFile() {
        int optionValue;
        if (this.context.isWorkspaceChanged() && (optionValue = JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.question.newfile_on_workspace_changed"), this.uiMessageBundle.getString("message.title.question"), 1, 3, null, null, 0)) != 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.context.resetWorksapce();
        this.context.setWorkspaceChanged(false);
        this.setTitle(this.makeFrameTitle());
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private File checkFileSuffix(File saveFile) {
        String filePath = saveFile.getAbsolutePath();
        if (filePath.endsWith(".abp")) {
            return saveFile;
        }
        return new File(String.valueOf(filePath) + ".abp");
    }
}

