/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblockutil.GraphicsManager;
import edu.mit.blocks.workspace.Workspace;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JComponentDragHandler
implements MouseListener,
MouseMotionListener {
    public int mPressedX;
    public int mPressedY;
    public int mCurrentX;
    public int mCurrentY;
    public int dragDX;
    public int dragDY;
    public int oldLocX;
    public int oldLocY;
    private static Cursor openHandCursor = null;
    private static Cursor closedHandCursor = null;
    public Point myLoc = new Point();
    private JComponent myComponent;
    private final Workspace workspace;

    public JComponentDragHandler(Workspace workspace, JComponent jc) {
        this.workspace = workspace;
        this.myComponent = jc;
        if (openHandCursor == null || closedHandCursor == null) {
            JComponentDragHandler.initHandCursors();
        }
    }

    private static void initHandCursors() {
        openHandCursor = JComponentDragHandler.createHandCursor("/edu/mit/blocks/codeblocks/open_hand.png", "openHandCursor");
        closedHandCursor = JComponentDragHandler.createHandCursor("/edu/mit/blocks/codeblocks/closed_hand.png", "closedHandCursor");
    }

    private static Cursor createHandCursor(String location, String cursorName) {
        if (GraphicsEnvironment.isHeadless()) {
            return Cursor.getPredefinedCursor(12);
        }
        URL handURL = JComponentDragHandler.class.getResource(location);
        assert (handURL != null) : "Can not find hand cursor image " + cursorName;
        ImageIcon handicon = new ImageIcon(handURL);
        Dimension cursize = Toolkit.getDefaultToolkit().getBestCursorSize(handicon.getIconWidth(), handicon.getIconHeight());
        BufferedImage buffImg = GraphicsManager.gc.createCompatibleImage(cursize.width, cursize.height, 3);
        Graphics2D buffImgG2 = (Graphics2D)buffImg.getGraphics();
        Point cpoint = new Point(cursize.width / 2 - handicon.getIconWidth() / 2, cursize.height / 2 - handicon.getIconHeight() / 2);
        buffImgG2.drawImage(handicon.getImage(), cpoint.x, cpoint.y, null);
        return Toolkit.getDefaultToolkit().createCustomCursor(buffImg, new Point(cpoint.x + 5, cpoint.y), cursorName);
    }

    public Cursor getDragHintCursor() {
        return openHandCursor;
    }

    public Cursor getDraggingCursor() {
        return closedHandCursor;
    }

    public Point getMousePoint() {
        return new Point(this.mCurrentX, this.mCurrentY);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.myComponent.setCursor(closedHandCursor);
        this.mPressedX = e.getX();
        this.mPressedY = e.getY();
        this.oldLocX = this.myComponent.getX();
        this.oldLocY = this.myComponent.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.myComponent.setCursor(closedHandCursor);
        this.mCurrentX = e.getX();
        this.mCurrentY = e.getY();
        int dx = this.mCurrentX - this.mPressedX;
        int dy = this.mCurrentY - this.mPressedY;
        int curX = this.myComponent.getX();
        int curY = this.myComponent.getY();
        int newX = dx + curX;
        int newY = dy + curY;
        this.workspace.scrollToComponent(this.myComponent);
        Point p = SwingUtilities.convertPoint(this.myComponent, newX + this.mPressedX, newY + this.mPressedY, this.workspace);
        if (this.workspace.getWidgetAt(p) == null) {
            this.workspace.contains(p);
        }
        this.dragDX = newX - this.myComponent.getX();
        this.dragDY = newY - this.myComponent.getY();
        this.myComponent.setLocation(newX, newY);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mCurrentX = e.getX();
        this.mCurrentY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.myComponent.setCursor(openHandCursor);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.myComponent.setCursor(openHandCursor);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.myComponent.setCursor(openHandCursor);
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.myComponent.setCursor(Cursor.getPredefinedCursor(0));
    }
}

