/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.storage;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class EEPROMReadLongBlock
extends TranslatorBlock {
    public EEPROMReadLongBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        EEPROMReadLongBlock.setupEEPROMEnvironment(this.translator);
        String ret = "eepromReadLong( ";
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        ret = String.valueOf(ret) + tb.toCode() + " ) ";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }

    public static void setupEEPROMEnvironment(Translator t) {
        t.addHeaderFile("EEPROM.h");
        t.addDefinitionCommand("/********************************************************\nA way to read unsigned longs (4 Bytes)from EEPROM \nEEPROM library natively supports only bytes\n********************************************************/\nunsigned long eepromReadLong(int address){\n\n\tunion u_tag {\n\t\tbyte b[4];\n\t\tunsigned long ULtime;\n\t} time;\n\ttime.b[0] = EEPROM.read(address);\n\ttime.b[1] = EEPROM.read(address+1);\n\ttime.b[2] = EEPROM.read(address+2);\n\ttime.b[3] = EEPROM.read(address+3);\n\treturn time.ULtime;\n}\n");
    }
}

