/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.BlockStub;
import edu.mit.blocks.codeblocks.LinkRule;
import edu.mit.blocks.codeblocks.ProcedureOutputManager;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceListener;
import java.util.ArrayList;

public class PolyRule
implements LinkRule,
WorkspaceListener {
    private final Workspace workspace;

    public PolyRule(Workspace workspace) {
        this.workspace = workspace;
    }

    private static boolean isInitPoly(BlockConnector socket) {
        return socket.initKind().contains("poly");
    }

    private static boolean isCurrentlyPoly(BlockConnector socket) {
        return socket.getKind().contains("poly");
    }

    private boolean isProcRelated(Long blockID) {
        Block block = this.workspace.getEnv().getBlock(blockID);
        return block.isProcedureDeclBlock() || block.getGenusName().equals("callerprocedure") || block.getGenusName().equals("serial_print") || block.getGenusName().equals("serial_println");
    }

    @Override
    public boolean canLink(Block block1, Block block2, BlockConnector socket1, BlockConnector socket2) {
        boolean isPlug2;
        boolean isPlug1 = block1.hasPlug() && block1.getPlug() == socket1;
        boolean bl = isPlug2 = block2.hasPlug() && block2.getPlug() == socket2;
        if (socket1.hasBlock() || socket2.hasBlock() || !(isPlug1 ^ isPlug2)) {
            return false;
        }
        boolean isPoly1 = socket1.getKind().contains("poly");
        boolean isPoly2 = socket2.getKind().contains("poly");
        boolean isList1 = socket1.getKind().contains("list");
        boolean isList2 = socket2.getKind().contains("list");
        boolean inListBlock1 = block1.isListRelated();
        boolean inListBlock2 = block2.isListRelated();
        if (isList1 || isList2) {
            return this.canLinkList(isPoly1, isPoly2, isList1, isList2, inListBlock1, inListBlock2);
        }
        return (isPoly1 || isPoly2) && !socket1.getKind().contains("cmd") && !socket2.getKind().contains("cmd");
    }

    private boolean canLinkList(boolean isPoly1, boolean isPoly2, boolean isList1, boolean isList2, boolean inListBlock1, boolean inListBlock2) {
        return isList1 && isList2 && isPoly1 ^ isPoly2 || !isList1 && isPoly1 && !inListBlock1 || !isList2 && isPoly2 && !inListBlock2;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void workspaceEventOccurred(WorkspaceEvent e) {
        BlockLink link = e.getSourceLink();
        if (e.getEventType() == 5) {
            boolean isPolyPlug = link.getPlug().getKind().contains("poly");
            boolean isPolySocket = link.getSocket().getKind().contains("poly");
            boolean isListPlug = link.getPlug().getKind().contains("list");
            boolean isListSocket = link.getSocket().getKind().contains("list");
            if (isPolyPlug && !isListPlug && (!isPolySocket || isListSocket)) {
                this.connectPoly(link.getSocketBlockID(), link.getSocket());
            } else if (isPolySocket && !isListSocket) {
                this.connectPoly(link.getPlugBlockID(), link.getPlug());
            } else if (isPolyPlug && isListPlug && (!isPolySocket || !isListSocket)) {
                this.connectPoly(link.getSocketBlockID(), link.getSocket());
            } else if (isPolySocket && isListSocket) {
                this.connectPoly(link.getPlugBlockID(), link.getPlug());
            } else if (link.getSocket().isExpandable()) {
                this.setPolyConnectors(link.getPlug());
            }
        } else if (e.getEventType() == 6) {
            this.revertPoly(this.workspace.getEnv().getBlock(link.getPlugBlockID()), link.getPlug());
            this.revertPoly(this.workspace.getEnv().getBlock(link.getSocketBlockID()), link.getSocket());
        }
        ProcedureOutputManager.procedureUpdateInfo(e);
    }

    private static Iterable<BlockConnector> getPolyConnectors(Block b) {
        ArrayList<BlockConnector> polySockets = new ArrayList<BlockConnector>();
        if (b.hasPlug() && PolyRule.isInitPoly(b.getPlug())) {
            polySockets.add(b.getPlug());
        }
        for (BlockConnector socket : b.getSockets()) {
            if (!PolyRule.isInitPoly(socket)) continue;
            polySockets.add(socket);
        }
        return polySockets;
    }

    private void connectPoly(Long setterBlockID, BlockConnector setterConn) {
        if (setterConn.hasBlock()) {
            this.setPolyConnectors(setterConn, setterBlockID);
        }
    }

    private void setPolyConnectors(BlockConnector setterConn) {
        if (setterConn.hasBlock()) {
            Block otherBlock = this.workspace.getEnv().getBlock(setterConn.getBlockID());
            for (BlockConnector polyConn : PolyRule.getPolyConnectors(otherBlock)) {
                if (!PolyRule.isCurrentlyPoly(polyConn)) continue;
                PolyRule.setPolyKind(otherBlock, polyConn, setterConn.getKind());
            }
            otherBlock.notifyRenderable();
        }
    }

    private void setPolyConnectors(BlockConnector setterConn, Long setterBlockID) {
        Block otherBlock = this.workspace.getEnv().getBlock(setterConn.getBlockID());
        if (this.isProcRelated(otherBlock.getBlockID())) {
            BlockConnector polyConn = otherBlock.getConnectorTo(setterBlockID);
            PolyRule.setPolyKind(otherBlock, polyConn, setterConn.getKind());
            otherBlock.notifyRenderable();
            if (otherBlock.hasStubs()) {
                BlockStub.parentConnectorsChanged(this.workspace, otherBlock.getBlockID());
            }
        } else {
            for (BlockConnector polyConn : PolyRule.getPolyConnectors(otherBlock)) {
                if (!PolyRule.isCurrentlyPoly(polyConn)) continue;
                PolyRule.setPolyKind(otherBlock, polyConn, setterConn.getKind());
                if (!polyConn.hasBlock() || polyConn.getBlockID().equals(setterBlockID)) continue;
                this.setPolyConnectors(polyConn, otherBlock.getBlockID());
            }
            otherBlock.notifyRenderable();
        }
    }

    private static void setPolyKind(Block polyBlock, BlockConnector polyConn, String newType) {
        String prefix = newType;
        int index = prefix.indexOf("-");
        if (!prefix.contains("inv") && index >= 0) {
            prefix = prefix.substring(0, index);
        }
        if (polyConn.getKind().equals("poly")) {
            if (!polyBlock.isListRelated()) {
                polyConn.setKind(newType);
            } else {
                polyConn.setKind(prefix);
            }
        } else if (polyConn.getKind().startsWith("poly-")) {
            prefix = String.valueOf(prefix) + polyConn.getKind().substring(4);
            polyConn.setKind(prefix);
        }
    }

    private boolean canRevertPolyConnectors(Block b, Long prevBlock) {
        if (this.isProcRelated(b.getBlockID())) {
            return true;
        }
        for (BlockConnector polyConn : PolyRule.getPolyConnectors(b)) {
            Block otherBlock;
            if (!polyConn.hasBlock() || polyConn.getBlockID() == prevBlock || PolyRule.isInitPoly((otherBlock = this.workspace.getEnv().getBlock(polyConn.getBlockID())).getConnectorTo(b.getBlockID())) && this.canRevertPolyConnectors(otherBlock, b.getBlockID())) continue;
            return false;
        }
        return true;
    }

    private void revertPoly(Block polyBlock, BlockConnector polyConn) {
        if (!PolyRule.isInitPoly(polyConn) || !this.canRevertPolyConnectors(polyBlock, Block.NULL)) {
            return;
        }
        polyConn.setKind(polyConn.initKind());
        if (this.isProcRelated(polyBlock.getBlockID())) {
            polyBlock.notifyRenderable();
            if (polyBlock.hasStubs()) {
                BlockStub.parentConnectorsChanged(this.workspace, polyBlock.getBlockID());
            }
        } else {
            for (BlockConnector nextConn : PolyRule.getPolyConnectors(polyBlock)) {
                PolyRule.revertPolyKind(nextConn, polyConn);
                if (!nextConn.hasBlock()) continue;
                this.revertPolyConnectors(nextConn, polyBlock.getBlockID());
            }
            polyBlock.notifyRenderable();
        }
    }

    private void revertPolyConnectors(BlockConnector setterConn, Long setterBlockID) {
        Block otherBlock = this.workspace.getEnv().getBlock(setterConn.getBlockID());
        if (this.isProcRelated(otherBlock.getBlockID())) {
            BlockConnector polyConn = otherBlock.getConnectorTo(setterBlockID);
            PolyRule.revertPolyKind(polyConn, setterConn);
            otherBlock.notifyRenderable();
            if (otherBlock.hasStubs()) {
                BlockStub.parentConnectorsChanged(this.workspace, otherBlock.getBlockID());
            }
        } else {
            for (BlockConnector polyConn : PolyRule.getPolyConnectors(otherBlock)) {
                PolyRule.revertPolyKind(polyConn, setterConn);
                if (!polyConn.hasBlock() || polyConn.getBlockID().equals(setterBlockID)) continue;
                this.revertPolyConnectors(polyConn, otherBlock.getBlockID());
            }
        }
        otherBlock.notifyRenderable();
    }

    private static void revertPolyKind(BlockConnector polyConn, BlockConnector setterConn) {
        if (!PolyRule.isInitPoly(polyConn)) {
            return;
        }
        if (polyConn.initKind().equals(setterConn.initKind())) {
            polyConn.setKind(setterConn.getKind());
        } else if (polyConn.getKind().contains("list")) {
            polyConn.setKind("poly-list");
        } else {
            polyConn.setKind("poly");
        }
    }
}

