/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CProgressBar;
import edu.mit.blocks.codeblockutil.CSVFilter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public final class CFileHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readFromFile(JComponent parent, int numLines) {
        int numberOfLines = numLines;
        JFileChooser filechooser = new JFileChooser("Import Data From");
        filechooser.addChoosableFileFilter(new CSVFilter());
        int returnVal = filechooser.showOpenDialog(parent.getTopLevelAncestor());
        if (returnVal != 0) return null;
        File file = filechooser.getSelectedFile();
        ArrayList<String> data = new ArrayList<String>();
        BufferedReader input = null;
        String line = null;
        if (file == null) return null;
        try {
            try {
                input = new BufferedReader(new FileReader(file));
                while (true) {
                    line = input.readLine();
                    if (line == null) return data.toArray(new String[data.size()]);
                    if (numberOfLines <= 0) {
                        return data.toArray(new String[data.size()]);
                    }
                    --numberOfLines;
                    data.add(line);
                }
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static boolean writeToFile(JComponent parent, String source) {
        JFileChooser fc = new JFileChooser("Saving Data");
        int returnVal = fc.showSaveDialog(parent.getTopLevelAncestor());
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            new CProgressBar("Saving Data to " + f.getName());
            try {
                if (f.getPath().length() > 4) {
                    String extension = f.getPath().substring(f.getPath().length() - 4, f.getPath().length());
                    if (extension.equals(".csv")) {
                        System.out.println("Saving with default extension: " + extension);
                    } else {
                        System.out.println("Generating extension: " + extension);
                        f = new File(String.valueOf(f.getPath()) + ".csv");
                    }
                } else {
                    System.out.println("Filename too short");
                    f = new File(String.valueOf(f.getPath()) + ".csv");
                }
                BufferedWriter output = null;
                output = new BufferedWriter(new FileWriter(f));
                output.write(source);
                ((Writer)output).close();
                return true;
            }
            catch (IOException io) {
                return false;
            }
        }
        return false;
    }

    public static boolean writeToFile(JComponent parent, BufferedImage image) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(parent.getTopLevelAncestor());
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            new CProgressBar("Saving Graph to " + f.getName());
            try {
                if (f.getPath().length() > 4) {
                    String extension = f.getPath().substring(f.getPath().length() - 4, f.getPath().length());
                    String extension2 = f.getPath().substring(f.getPath().length() - 5, f.getPath().length());
                    if (extension.equals(".jpg") || extension.equals(".gif") || extension.equals(".tif") || extension.equals(".png") || extension2.equals(".jpeg") || extension2.equals(".tiff")) {
                        System.out.println("Saving with default extension: " + extension);
                    } else {
                        System.out.println("Generating extension: " + extension);
                        f = new File(String.valueOf(f.getPath()) + ".jpg");
                    }
                } else {
                    System.out.println("Filename too short");
                    f = new File(String.valueOf(f.getPath()) + ".jpg");
                }
                ImageIO.write((RenderedImage)image, "jpg", f);
                return true;
            }
            catch (IOException io) {
                return false;
            }
        }
        return false;
    }
}

