/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CScrollPane;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;

class HoverVerticalBar
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = 328149080216L;
    private final BoundedRangeModel modelrange;
    private final Color thumbColor;
    private final Color trackColor;
    private final RenderingHints renderingHints;
    private int pressLocation;
    private int SCROLLINGUNIT = 3;
    private CScrollPane.ScrollPolicy vpolicy;

    public HoverVerticalBar(int barwidth, Color thumbColor, Color trackColor, BoundedRangeModel modelrange, CScrollPane.ScrollPolicy verticalPolicy) {
        this.vpolicy = verticalPolicy;
        this.trackColor = trackColor;
        this.modelrange = modelrange;
        this.thumbColor = thumbColor;
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.pressLocation = 0;
        this.setOpaque(false);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        double viewValue = this.modelToView(this.modelrange.getValue());
        double viewExtent = this.modelToView(this.modelrange.getExtent());
        if (!this.vpolicy.equals((Object)CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED) || this.modelrange.getMaximum() > this.getHeight() + 7 + this.getWidth()) {
            int vWidth = this.getWidth() / 2;
            Graphics2D g2 = (Graphics2D)g;
            g2.addRenderingHints(this.renderingHints);
            g2.translate(vWidth / 2, 0);
            g2.setColor(this.trackColor);
            g2.fillRoundRect(0, 0, vWidth, this.getHeight(), vWidth, vWidth);
            g2.setColor(new Color(150, 150, 150));
            g2.drawRoundRect(0, 0, vWidth, this.getHeight() - 1, vWidth, vWidth);
            if (viewValue < (double)((float)this.getHeight() - 0.5f * (float)this.getWidth())) {
                g2.translate(0.0, viewValue);
            } else {
                g2.translate(0.0, (float)this.getHeight() - 0.5f * (float)this.getWidth());
            }
            g2.setPaint(new GradientPaint(0.0f, 0.0f, this.thumbColor, this.getWidth() + 10, 0.0f, Color.black, true));
            g2.fillRoundRect(0, 0, vWidth, (int)viewExtent, vWidth, vWidth);
            g2.setColor(new Color(250, 250, 250, 100));
            g2.drawRoundRect(0, 0, vWidth, (int)viewExtent, vWidth, vWidth);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        return (double)x > (double)this.getWidth() * 0.25 && (double)x < (double)this.getWidth() * 0.75;
    }

    private double viewToModel(int view) {
        return view * this.modelrange.getMaximum() / this.getHeight();
    }

    private double modelToView(int model) {
        return (double)(model * this.getHeight()) / (double)this.modelrange.getMaximum();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double viewValue = this.modelToView(this.modelrange.getValue());
        double viewExtent = this.modelToView(this.modelrange.getExtent());
        if ((double)e.getY() < viewValue || (double)e.getY() > viewExtent + viewValue) {
            this.pressLocation = (int)(viewExtent / 2.0);
            this.modelrange.setValue((int)this.viewToModel(e.getY()) - this.modelrange.getExtent() / 2);
            this.repaint();
        } else {
            this.pressLocation = e.getY() - (int)viewValue;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.modelrange.setValue((int)this.viewToModel(e.getY() - this.pressLocation));
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pressLocation = 0;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.modelrange.setValue(this.modelrange.getValue() + e.getUnitsToScroll() * e.getScrollAmount() * this.SCROLLINGUNIT);
        this.repaint();
    }

    public void setScrollingUnit(int x) {
        this.SCROLLINGUNIT = x;
    }
}

