/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CMenuItem;
import edu.mit.blocks.codeblockutil.CPopupMenu;
import edu.mit.blocks.codeblockutil.CToolTip;
import edu.mit.blocks.codeblockutil.NumberFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class LabelWidget
extends JComponent {
    public static final int DROP_DOWN_MENU_WIDTH = 7;
    private static final long serialVersionUID = 837647234895L;
    private static final Border textFieldBorder = new CompoundBorder(BorderFactory.createLoweredBevelBorder(), new EmptyBorder(1, 2, 1, 2));
    private static final NumberFormatter nf = new NumberFormatter(NumberFormatter.MEDIUM_PRECISION);
    private final ShadowLabel textLabel = new ShadowLabel();
    private final BlockLabelTextField textField = new BlockLabelTextField();
    private final LabelMenu menu = new LabelMenu();
    private String labelBeforeEdit = "";
    private boolean isNumber = false;
    private boolean isEditable = false;
    private boolean isFocused = false;
    private boolean hasSiblings = false;
    private boolean editingText;
    private Color tooltipBackground = new Color(255, 255, 225);
    private double zoom = 1.0;

    public LabelWidget(String initLabelText, Color fieldColor, Color tooltipBackground) {
        if (initLabelText == null) {
            initLabelText = "";
        }
        this.setFocusTraversalKeysEnabled(false);
        this.setLayout(new BorderLayout());
        this.tooltipBackground = tooltipBackground;
        this.labelBeforeEdit = initLabelText;
        this.textField.setForeground(Color.WHITE);
        this.textField.setBackground(fieldColor);
        this.textField.setCaretColor(Color.WHITE);
        this.textField.setSelectionColor(Color.BLACK);
        this.textField.setSelectedTextColor(Color.WHITE);
        this.textField.setBorder(textFieldBorder);
        this.textField.setMargin(textFieldBorder.getBorderInsets(this.textField));
    }

    protected abstract void fireTextChanged(String var1);

    protected abstract void fireGenusChanged(String var1);

    protected abstract void fireDimensionsChanged(Dimension var1);

    protected abstract boolean isTextValid(String var1);

    public void addKeyListenerToTextField(KeyListener l) {
        this.textField.addKeyListener(l);
    }

    public void addMouseListenerToLabel(MouseListener l) {
        this.textLabel.addMouseListener(l);
    }

    public void addMouseMotionListenerToLabel(MouseMotionListener l) {
        this.textLabel.addMouseMotionListener(l);
    }

    public void showMenuIcon(boolean show) {
        if (this.hasSiblings) {
            this.isFocused = show;
            this.menu.popupmenu.setZoomLevel(this.zoom);
            this.menu.repaint();
        }
    }

    public void setEditingState(boolean editing) {
        if (editing) {
            this.editingText = true;
            this.textField.setText(this.textLabel.getText().trim());
            this.labelBeforeEdit = this.textLabel.getText();
            this.removeAll();
            this.add(this.textField);
            this.textField.grabFocus();
        } else {
            if (this.editingText) {
                if (this.isTextValid(this.textField.getText().trim())) {
                    this.setText(this.textField.getText());
                } else {
                    this.setText(this.labelBeforeEdit);
                }
            }
            this.editingText = false;
        }
    }

    public boolean editingText() {
        return this.editingText;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setNumeric(boolean isNumber) {
        this.isNumber = isNumber;
    }

    public boolean isNumeric() {
        return this.isNumber;
    }

    public void setSiblings(boolean hasSiblings, String[][] siblings) {
        this.hasSiblings = hasSiblings;
        this.menu.setSiblings(siblings);
    }

    public boolean hasSiblings() {
        return this.hasSiblings;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.textLabel.setFont(font);
        this.textField.setFont(font);
        this.menu.setFont(font);
    }

    public void assignToolTipToLabel(String text) {
        this.textLabel.setToolTipText(text);
    }

    public String getText() {
        return this.textLabel.getText().trim();
    }

    public void setText(double value) {
        if (Math.abs(value - Double.MAX_VALUE) < 1.0) {
            this.updateLabelText("Infinity");
        } else if (Math.abs(value + Double.MAX_VALUE) < 1.0) {
            this.updateLabelText("-Infinity");
        } else {
            this.updateLabelText(nf.format(value));
        }
    }

    public void setText(String string) {
        if (string != null) {
            this.updateLabelText(string.trim());
        }
    }

    public void setText(boolean bool) {
        this.updateLabelText(bool ? "True" : "False");
    }

    public void updateLabelText(String text) {
        if (text.equals("")) {
            text = "     ";
        }
        this.textLabel.setText(text);
        this.textField.setText(text);
        this.updateDimensions();
        this.fireTextChanged(text);
        this.removeAll();
        this.add((Component)this.textLabel, "Center");
        if (this.hasSiblings) {
            this.add((Component)this.menu, "East");
        }
    }

    private void updateDimensions() {
        Dimension updatedDimension = new Dimension(this.textField.getPreferredSize().width, this.textField.getPreferredSize().height);
        if (this.hasSiblings) {
            updatedDimension.width += 7;
        }
        this.textField.setSize(updatedDimension);
        this.textLabel.setSize(updatedDimension);
        this.setSize(updatedDimension);
        this.fireDimensionsChanged(this.getSize());
    }

    public void highlightText() {
        this.textField.setSelectionStart(0);
    }

    protected void suggestEditable(boolean suggest) {
        if (this.isEditable) {
            if (suggest) {
                this.setBorder(BorderFactory.createLineBorder(Color.white));
            } else {
                this.setBorder(null);
            }
        }
    }

    public void setZoomLevel(double newZoom) {
        this.zoom = newZoom;
        AffineTransform at = new AffineTransform();
        at.setToScale(newZoom, newZoom);
        Font renderingFont = this.getFont().deriveFont(at);
        this.setFont(renderingFont);
        this.repaint();
        this.updateDimensions();
    }

    @Override
    public String toString() {
        return "Label at " + this.getLocation() + " with text: \"" + this.textLabel.getText() + "\"";
    }

    public boolean canProcessNegativeSign() {
        if (this.getText() != null && this.getText().contains("-")) {
            return this.textField.getSelectedText() != null && this.textField.getSelectedText().contains("-");
        }
        if (this.textField.getCaretPosition() == 0) {
            return true;
        }
        return this.textField.getSelectionStart() == 0;
    }

    private class BlockLabelTextField
    extends JTextField
    implements MouseListener,
    DocumentListener,
    FocusListener,
    ActionListener {
        private static final long serialVersionUID = 873847239234L;
        private final char[] validNumbers = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '.'};
        private final char[] validChar = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm', 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '\'', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', '-', '=', '{', '}', '|', '[', ']', '\\', ' ', ':', '\"', ';', '\'', '<', '>', '?', ',', '.', '/', '`', '~'};
        private final int[] validMasks = new int[]{8, 38, 40, 37, 39, 35, 36, 45, 127, 16, 17, 1, 64};

        private BlockLabelTextField() {
            this.addActionListener(this);
            this.getDocument().addDocumentListener(this);
            this.addFocusListener(this);
            this.addMouseListener(this);
            this.setFocusTraversalKeysEnabled(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            LabelWidget.this.suggestEditable(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LabelWidget.this.setEditingState(false);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LabelWidget.this.updateDimensions();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LabelWidget.this.updateDimensions();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            LabelWidget.this.setEditingState(false);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            char c;
            int n;
            int n2;
            Object[] objectArray;
            if (LabelWidget.this.isNumber) {
                if (e.getKeyChar() == '-' && LabelWidget.this.canProcessNegativeSign()) {
                    return super.processKeyBinding(ks, e, condition, pressed);
                }
                if (this.getText().contains(".") && e.getKeyChar() == '.') {
                    return false;
                }
                objectArray = this.validNumbers;
                n2 = this.validNumbers.length;
                n = 0;
                while (n < n2) {
                    c = objectArray[n];
                    if (e.getKeyChar() == c) {
                        return super.processKeyBinding(ks, e, condition, pressed);
                    }
                    ++n;
                }
            } else {
                objectArray = this.validChar;
                n2 = this.validChar.length;
                n = 0;
                while (n < n2) {
                    c = objectArray[n];
                    if (e.getKeyChar() == c) {
                        return super.processKeyBinding(ks, e, condition, pressed);
                    }
                    ++n;
                }
            }
            objectArray = this.validMasks;
            n2 = this.validMasks.length;
            n = 0;
            while (n < n2) {
                char i = objectArray[n];
                if (e.getKeyCode() == i) {
                    return super.processKeyBinding(ks, e, condition, pressed);
                }
                ++n;
            }
            if ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            return false;
        }
    }

    private class LabelMenu
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 328149080240L;
        private CPopupMenu popupmenu;
        private GeneralPath triangle;

        private LabelMenu() {
            this.setOpaque(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setCursor(new Cursor(0));
            this.popupmenu = new CPopupMenu();
        }

        private void setSiblings(String[][] siblings) {
            this.popupmenu = new CPopupMenu();
            int i = 0;
            while (i < siblings.length) {
                final String selfGenus = siblings[i][0];
                CMenuItem selfItem = new CMenuItem(siblings[i][1]);
                selfItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LabelWidget.this.fireGenusChanged(selfGenus);
                        LabelWidget.this.showMenuIcon(false);
                    }
                });
                this.popupmenu.add(selfItem);
                ++i;
            }
        }

        @Override
        public boolean contains(Point p) {
            return this.triangle != null && this.triangle.contains(p);
        }

        @Override
        public boolean contains(int x, int y) {
            return this.triangle != null && this.triangle.contains(x, y);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (LabelWidget.this.isFocused) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.triangle = new GeneralPath();
                this.triangle.moveTo(0.0f, this.getHeight() / 4);
                this.triangle.lineTo(this.getWidth() - 1, this.getHeight() / 4);
                this.triangle.lineTo(this.getWidth() / 2 - 1, this.getHeight() / 4 + 7);
                this.triangle.lineTo(0.0f, this.getHeight() / 4);
                this.triangle.closePath();
                g2.setColor(new Color(255, 255, 255, 100));
                g2.fill(this.triangle);
                g2.setColor(Color.BLACK);
                g2.draw(this.triangle);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (LabelWidget.this.hasSiblings) {
                this.popupmenu.show(this, 0, 0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class ShadowLabel
    extends JLabel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 90123787382L;
        private final int[][] shadowPositionArray;
        private final float[] shadowColorArray;
        private double offsetSize;

        private ShadowLabel() {
            int[][] nArrayArray = new int[9][];
            int[] nArray = new int[2];
            nArray[1] = -1;
            nArrayArray[0] = nArray;
            nArrayArray[1] = new int[]{1, -1};
            int[] nArray2 = new int[2];
            nArray2[0] = -1;
            nArrayArray[2] = nArray2;
            int[] nArray3 = new int[2];
            nArray3[0] = 2;
            nArrayArray[3] = nArray3;
            nArrayArray[4] = new int[]{-1, 1};
            nArrayArray[5] = new int[]{1, 1};
            int[] nArray4 = new int[2];
            nArray4[1] = 2;
            nArrayArray[6] = nArray4;
            int[] nArray5 = new int[2];
            nArray5[0] = 1;
            nArrayArray[7] = nArray5;
            int[] nArray6 = new int[2];
            nArray6[1] = 1;
            nArrayArray[8] = nArray6;
            this.shadowPositionArray = nArrayArray;
            this.shadowColorArray = new float[]{0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.0f, 0.0f};
            this.offsetSize = 1.0;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            int i = 0;
            while (i < this.shadowPositionArray.length) {
                int dx = this.shadowPositionArray[i][0];
                int dy = this.shadowPositionArray[i][1];
                g2.setColor(new Color(0.5f, 0.5f, 0.5f, this.shadowColorArray[i]));
                g2.drawString(this.getText(), (int)((double)(4 + dx) * this.offsetSize), this.getHeight() + (int)((double)(dy - 6) * this.offsetSize));
                ++i;
            }
            g2.setColor(Color.white);
            g2.drawString(this.getText(), (int)(4.0 * this.offsetSize), this.getHeight() + (int)(-6.0 * this.offsetSize));
        }

        @Override
        public JToolTip createToolTip() {
            return new CToolTip(LabelWidget.this.tooltipBackground);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1 && LabelWidget.this.isEditable) {
                LabelWidget.this.setEditingState(true);
                LabelWidget.this.textField.setSelectionStart(0);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            LabelWidget.this.suggestEditable(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            LabelWidget.this.suggestEditable(false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            LabelWidget.this.suggestEditable(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            LabelWidget.this.suggestEditable(true);
        }
    }
}

