/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockStub;
import edu.mit.blocks.codeblockutil.LabelWidget;
import edu.mit.blocks.renderable.BlockUtilities;
import edu.mit.blocks.renderable.FactoryRenderableBlock;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class BlockLabel
implements MouseListener,
MouseMotionListener,
KeyListener {
    public static final Font blockFontSmall_Bold = new Font("Monospaced", 1, 7);
    public static final Font blockFontMedium_Bold = new Font("Monospaced", 1, 10);
    public static final Font blockFontLarge_Bold = new Font("Monospaced", 1, 12);
    public static final Font blockFontSmall_Plain = new Font("Monospaced", 0, 7);
    public static final Font blockFontMedium_Plain = new Font("Monospaced", 0, 10);
    public static final Font blockFontLarge_Plain = new Font("Monospaced", 0, 12);
    private LabelWidget widget;
    private final char[] validOperators = new char[]{'-', '+', '/', '*', '=', '<', '>', 'x', 'X'};
    private Long blockID;
    private Type labelType;
    private double zoom = 1.0;
    protected final Workspace workspace;

    public BlockLabel(Workspace workspace, String initLabelText, Type labelType, boolean isEditable, Color tooltipBackground) {
        this(workspace, initLabelText, labelType, isEditable, -1L, false, tooltipBackground);
    }

    public BlockLabel(Workspace workspace, String initLabelText, Type labelType, boolean isEditable, long blockID, boolean hasComboPopup, Color tooltipBackground) {
        this.workspace = workspace;
        if (Block.NULL.equals(blockID)) {
            throw new RuntimeException("May not pass a null block instance as the parent of a block label");
        }
        if (initLabelText == null) {
            initLabelText = "";
        }
        this.blockID = blockID;
        this.labelType = labelType;
        this.widget = new LabelWidget(initLabelText, workspace.getEnv().getBlock(blockID).getColor().darker(), tooltipBackground){
            private static final long serialVersionUID = 328149080424L;

            @Override
            protected void fireTextChanged(String text) {
                BlockLabel.this.textChanged(text);
            }

            @Override
            protected void fireGenusChanged(String genus) {
                BlockLabel.this.genusChanged(genus);
            }

            @Override
            protected void fireDimensionsChanged(Dimension value) {
                BlockLabel.this.dimensionsChanged(value);
            }

            @Override
            protected boolean isTextValid(String text) {
                return BlockLabel.this.textValid(text);
            }
        };
        this.widget.setNumeric(workspace.getEnv().getBlock(this.blockID).getGenusName().equals("number"));
        this.widget.setEditable(isEditable && (labelType == Type.NAME_LABEL || labelType == Type.PORT_LABEL) && workspace.getEnv().getBlock(blockID).isLabelEditable() && !(workspace.getEnv().getRenderableBlock(blockID) instanceof FactoryRenderableBlock));
        if (labelType == null || labelType.equals((Object)Type.NAME_LABEL)) {
            this.widget.setFont(blockFontLarge_Bold);
        } else if (labelType.equals((Object)Type.PAGE_LABEL)) {
            this.widget.setFont(blockFontMedium_Bold);
        } else if (labelType.equals((Object)Type.PORT_LABEL)) {
            this.widget.setFont(blockFontMedium_Bold);
        } else if (labelType.equals((Object)Type.DATA_LABEL)) {
            this.widget.setFont(blockFontMedium_Bold);
        }
        if (workspace.getEnv().getBlock(blockID).hasSiblings()) {
            List<String> siblingsNames = workspace.getEnv().getBlock(blockID).getSiblingsList();
            String[][] siblings = new String[siblingsNames.size() + 1][2];
            siblings[0] = new String[]{workspace.getEnv().getBlock(blockID).getGenusName(), workspace.getEnv().getBlock(blockID).getInitialLabel()};
            int i = 0;
            while (i < siblingsNames.size()) {
                siblings[i + 1] = new String[]{siblingsNames.get(i), workspace.getEnv().getGenusWithName(siblingsNames.get(i)).getInitialLabel()};
                ++i;
            }
            this.widget.setSiblings(hasComboPopup && workspace.getEnv().getBlock(blockID).hasSiblings(), siblings);
        }
        this.widget.addMouseListenerToLabel(this);
        this.widget.addMouseMotionListenerToLabel(this);
        this.widget.addKeyListenerToTextField(this);
        this.widget.updateLabelText(initLabelText);
        this.widget.setEditingState(false);
    }

    public void setZoomLevel(double newZoom) {
        this.zoom = newZoom;
        this.widget.setZoomLevel(newZoom);
    }

    public int getAbstractWidth() {
        if (this.widget.hasSiblings()) {
            return (int)((double)this.widget.getWidth() / this.zoom) - 7;
        }
        return (int)((double)this.widget.getWidth() / this.zoom);
    }

    public int getAbstractHeight() {
        return (int)((double)this.widget.getHeight() / this.zoom);
    }

    public int getPixelWidth() {
        return this.widget.getWidth();
    }

    public int getPixelHeight() {
        return this.widget.getHeight();
    }

    public Point getPixelLocation() {
        return this.widget.getLocation();
    }

    public void setEditable(boolean isEditable) {
        this.widget.setEditable(isEditable);
    }

    public boolean editingText() {
        return this.widget.editingText();
    }

    public void highlightText() {
        this.widget.highlightText();
    }

    public void setPixelLocation(int x, int y) {
        this.widget.setLocation(x, y);
    }

    public String getText() {
        return this.widget.getText();
    }

    public void setText(String text) {
        this.widget.setText(text);
    }

    public void setText(boolean text) {
        this.widget.setText(text);
    }

    public void setText(double text) {
        this.widget.setText(text);
    }

    public void setToolTipText(String text) {
        this.widget.assignToolTipToLabel(text);
    }

    public void showMenuIcon(boolean show) {
        this.widget.showMenuIcon(show);
    }

    public JComponent getJComponent() {
        return this.widget;
    }

    public void setEditingState(boolean editing) {
        this.widget.setEditingState(editing);
    }

    protected int rescale(int x) {
        return (int)((double)x * this.zoom);
    }

    protected int rescale(double x) {
        return (int)(x * this.zoom);
    }

    protected int descale(int x) {
        return (int)((double)x / this.zoom);
    }

    protected int descale(double x) {
        return (int)(x / this.zoom);
    }

    Long getBlockID() {
        return this.blockID;
    }

    protected void textChanged(String text) {
        if ((this.labelType.equals((Object)Type.NAME_LABEL) || this.labelType.equals((Object)Type.PORT_LABEL)) && this.workspace.getEnv().getBlock(this.blockID).isLabelEditable()) {
            RenderableBlock rb;
            BlockConnector plug;
            if (this.labelType.equals((Object)Type.NAME_LABEL)) {
                this.workspace.getEnv().getBlock(this.blockID).setBlockLabel(text);
            }
            if ((plug = this.workspace.getEnv().getBlock(this.blockID).getPlug()) != null && plug.getBlockID() != Block.NULL && this.workspace.getEnv().getBlock(plug.getBlockID()) != null && this.workspace.getEnv().getBlock(plug.getBlockID()).isProcedureDeclBlock() && this.workspace.getEnv().getBlock(plug.getBlockID()).hasStubs() && this.workspace.getEnv().getRenderableBlock(plug.getBlockID()).isLoading()) {
                BlockStub.parentConnectorsChanged(this.workspace, plug.getBlockID());
            }
            if ((rb = this.workspace.getEnv().getRenderableBlock(this.blockID)) != null) {
                this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, rb.getParentWidget(), this.blockID, 10));
            }
        }
    }

    protected void genusChanged(String genus) {
        if (this.widget.hasSiblings()) {
            Block oldBlock = this.workspace.getEnv().getBlock(this.blockID);
            oldBlock.changeGenusTo(genus);
            RenderableBlock rb = this.workspace.getEnv().getRenderableBlock(this.blockID);
            rb.repaintBlock();
            this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, rb.getParentWidget(), this.blockID, 12));
        }
    }

    protected void dimensionsChanged(Dimension value) {
        if (this.workspace.getEnv().getRenderableBlock(this.blockID) != null) {
            this.workspace.getEnv().getRenderableBlock(this.blockID).repaintBlock();
        }
    }

    protected boolean textValid(String text) {
        return !text.equals("") && BlockUtilities.isLabelValid(this.workspace, this.blockID, text);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() != 1 || !this.widget.isEditable()) {
            this.workspace.getEnv().getRenderableBlock(this.blockID).processMouseEvent(SwingUtilities.convertMouseEvent(this.widget, e, this.widget.getParent()));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.widget.getParent() != null && this.widget.getParent() instanceof MouseListener) {
            this.workspace.getEnv().getRenderableBlock(this.blockID).processMouseEvent(SwingUtilities.convertMouseEvent(this.widget, e, this.widget.getParent()));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.widget.getParent() != null && this.widget.getParent() instanceof MouseListener) {
            this.workspace.getEnv().getRenderableBlock(this.blockID).processMouseEvent(SwingUtilities.convertMouseEvent(this.widget, e, this.widget.getParent()));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.widget.getParent() != null && this.widget.getParent() instanceof MouseListener) {
            this.workspace.getEnv().getRenderableBlock(this.blockID).processMouseEvent(SwingUtilities.convertMouseEvent(this.widget, e, this.widget.getParent()));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.widget.getParent() != null && this.widget.getParent() instanceof MouseListener) {
            this.workspace.getEnv().getRenderableBlock(this.blockID).processMouseEvent(SwingUtilities.convertMouseEvent(this.widget, e, this.widget.getParent()));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.widget.getParent() != null && this.widget.getParent() instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.widget.getParent())).mouseDragged(SwingUtilities.convertMouseEvent(this.widget, e, this.widget.getParent()));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                this.workspace.getEnv().getRenderableBlock(this.blockID).requestFocus();
                return;
            }
            case 10: {
                this.workspace.getEnv().getRenderableBlock(this.blockID).requestFocus();
                return;
            }
            case 9: {
                this.workspace.getEnv().getRenderableBlock(this.blockID).processKeyPressed(e);
                return;
            }
        }
        if (this.workspace.getEnv().getBlock(this.blockID).getGenusName().equals("number")) {
            if (e.getKeyChar() == '-' && this.widget.canProcessNegativeSign()) {
                return;
            }
            char[] cArray = this.validOperators;
            int n = this.validOperators.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (e.getKeyChar() == c) {
                    this.workspace.getEnv().getRenderableBlock(this.blockID).processKeyPressed(e);
                    return;
                }
                ++n2;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static enum Type {
        NAME_LABEL,
        PAGE_LABEL,
        PORT_LABEL,
        DATA_LABEL;

    }
}

