#
# To activate this environment, use
#
#     $ conda activate patterns_py
#
# To deactivate an active environment, use
#
#     $ conda deactivate

#=============================================================
#               Libraries
#=============================================================
import pandas as pd
import numpy as np
import sys

import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator
from matplotlib.ticker import PercentFormatter
import matplotlib.patches as patches

from matplotlib import rc
rc('text', usetex=True)
#plt.rcParams['text.latex.preamble'] = [r"\usepackage{amsmath}"]
rc('font', **{'family': 'serif', 'serif': ['Palatino']})

#=============================================================
#               Global
#=============================================================
colors = ['royalblue', 'orange', 'mediumvioletred', 'seagreen', 'gold',
			'teal', 'orchid', 'olive', 'grey', 'black']
markers = ['o', 'v', '^', 'D', 'P', '*', 'p', 's', '>', '<']

#=============================================================
#               Functions
#=============================================================
def get_gyre_data(gyre_file_name):
    gyre_data = np.genfromtxt(gyre_file_name, skip_header=5, names=True)
    
    freq = gyre_data['Refreq']
    n_g = gyre_data['n_g']
    n_p = gyre_data['n_p']
    n_pg = gyre_data['n_pg']

    idx = np.where(n_p == 0)[0]

    return freq[idx], n_g[idx]

def plot_pattern(ax, freq, n_g, color, marker, label):
    
    n_idx = []
    n_diff = np.diff(n_g)
    freq_list = []
    for i in range(len(n_diff)):
        if abs(n_diff[i]) == 1:
            freq_list = np.append(freq_list, freq[i])
        else:
            periods = 1/freq_list[::-1]     # period in days
            dP = np.diff(periods)*86400.    # period spacing in seconds
            ax.plot(periods[1:], dP, color=color, marker=marker, label='_nolegend_')
            freq_list = []
            
    periods = 1/freq_list[::-1]     # period in days
    dP = np.diff(periods)*86400.    # period spacing in seconds
    ax.plot(periods[1:], dP, color=color,marker=marker, label=label)
    
    ax.set_xlabel('Period [days]', fontsize=15)
    ax.set_ylabel('Period spacing [seconds]', fontsize=15)
    ax.tick_params(labelsize=12)
#=============================================================
#               Main
#=============================================================

fig_name = sys.argv[1]
gyre_summary_file_names = sys.argv[2:]

print()
print(gyre_summary_file_names)
print()

fig = plt.figure()
ax = plt.subplot(111)
for f in range(len(gyre_summary_file_names)):
	# Get frequencies and radial orders from file
    freq, n_g = get_gyre_data(gyre_summary_file_names[f])
    
    # Plot pattern
    plot_pattern(ax, freq, n_g, color=colors[f], marker=markers[f], label='pattern ' + str(f+1))

# Add legend to plot    
ax.legend()
plt.tight_layout()
plt.savefig(fig_name, dpi=300)
plt.show()

