﻿Module Bazu
    '月令司權
    Public MJ, JCHID, SLING_TK As Integer
    Public SLING As String
    '男女命造
    Public sd1, sd2, DESTINY As String
    '身命胎息
    Public mkj, mkk, skj, skk, tik, tij, sik, sij As Integer
    '干支配色
    Public innum As Integer
    Public textcolor As String
    '十神變化
    Public TK As Integer
    Public TG, TG_SE As String
    '地支轉換天干
    Public BDJ, DK1, DK2, DK3 As Integer
    '天干地支取十神配色
    Public BTK As Integer
    Public TKTG, DK1TG, DK2TG, DK3TG, tk_color, dk1_color, dk2_color, dk3_color As String
    '大運計算
    Public STM_ONE, DA_STEP, dauntk(12), daundj(12) As Integer
    Public birth_time, birth_day, CTIME, daunstm(12), daundate(12), daunage(12) As String
    Public daunhours(12) As Long
    '歲數計算
    Public ages As Integer
    '五行旺衰: Fire 火 Water 水 Wood 木 Metal 金 Earth 土
    Public Fire, Water, Wood, Metal, Earth, MUL, TKX, DJX As Integer
    '計算大運流年月日時五行
    Public FEINDEX As Integer

    '=================================================================================
    '=== 月令用事
    '=================================================================================
    Sub month_sling()
        Select Case MJ
            Case 1 '月建地支子
                If JCHID < 11 Then SLING = "壬水" : SLING_TK = 9
                If JCHID > 10 Then SLING = "癸水" : SLING_TK = 10
            Case 2 '月建地支丑
                If JCHID < 10 Then SLING = "癸水" : SLING_TK = 10
                If JCHID > 9 And JCHID < 13 Then SLING = "辛金" : SLING_TK = 8
                If JCHID > 12 Then SLING = "己土" : SLING_TK = 6
            Case 3 '月建地支寅
                If JCHID < 8 Then SLING = "戊土" : SLING_TK = 5
                If JCHID > 7 And JCHID < 15 Then SLING = "丙火" : SLING_TK = 3
                If JCHID > 14 Then SLING = "甲木" : SLING_TK = 1
            Case 4 '月建地支卯
                If JCHID < 11 Then SLING = "甲木" : SLING_TK = 1
                If JCHID > 10 Then SLING = "乙木" : SLING_TK = 2
            Case 5 '月建地支辰
                If JCHID < 10 Then SLING = "乙木" : SLING_TK = 2
                If JCHID > 9 And JCHID < 13 Then SLING = "癸水" : SLING_TK = 10
                If JCHID > 12 Then SLING = "戊土" : SLING_TK = 5
            Case 6 '月建地支巳
                If JCHID < 8 Then SLING = "戊土" : SLING_TK = 5
                If JCHID > 7 And JCHID < 15 Then SLING = "庚金" : SLING_TK = 7
                If JCHID > 14 Then SLING = "丙火" : SLING_TK = 3
            Case 7 '月建地支午
                If JCHID < 11 Then SLING = "丙火" : SLING_TK = 3
                If JCHID > 10 And JCHID < 20 Then SLING = "己土" : SLING_TK = 6
                If JCHID > 19 Then SLING = "丁火" : SLING_TK = 4
            Case 8 '月建地支未
                If JCHID < 10 Then SLING = "丁火" : SLING_TK = 4
                If JCHID > 9 And JCHID < 13 Then SLING = "乙木" : SLING_TK = 2
                If JCHID > 12 Then SLING = "己土" : SLING_TK = 6
            Case 9 '月建地支申
                If JCHID < 8 Then SLING = "戊土" : SLING_TK = 5
                If JCHID > 7 And JCHID < 15 Then SLING = "壬水" : SLING_TK = 9
                If JCHID > 14 Then SLING = "庚金" : SLING_TK = 7
            Case 10 '月建地支酉
                If JCHID < 11 Then SLING = "庚金" : SLING_TK = 7
                If JCHID > 10 Then SLING = "辛金" : SLING_TK = 8
            Case 11 '月建地支戌
                If JCHID < 10 Then SLING = "辛金" : SLING_TK = 8
                If JCHID > 9 And JCHID < 13 Then SLING = "丁火" : SLING_TK = 4
                If JCHID > 12 Then SLING = "戊土" : SLING_TK = 5
            Case 12 '月建地支亥
                If JCHID < 8 Then SLING = "戊土" : SLING_TK = 5
                If JCHID > 7 And JCHID < 15 Then SLING = "甲木" : SLING_TK = 1
                If JCHID > 14 Then SLING = "壬水" : SLING_TK = 9
        End Select

    End Sub
    '=================================================================================
    '=== 男女命造
    '=================================================================================
    Sub destiny_create()
        If BirthData(7, 1) = 0 Then sd1 = "陰" Else sd1 = "陽"
        If BirthData(7, 2) = 0 Then sd2 = "女" Else sd2 = "男"

        If sd2 = "男" Then
            DESTINY = "乾造"
        Else
            DESTINY = "坤造"
        End If
    End Sub

    '=================================================================================
    '=== 身命胎息
    '=================================================================================
    Sub smts()
        Dim n, mstep, jstep, hstep, mkstep, skstep As Integer
        '=========================================
        '節氣月支移位間隔
        mstep = BirthData(2, 4) - 3
        If mstep < 0 Then mstep = mstep + 12

        '中氣月支移位間隔
        jstep = (BirthData(2, 4) + CDAY) - 3
        If jstep > 12 Then jstep = jstep - 12
        If jstep < 0 Then jstep = jstep + 12

        '時支移位間隔
        hstep = BirthData(4, 4) - 1
        If hstep < 0 Then hstep = hstep + 12

        '五虎遁
        YTK = BirthData(1, 3)
        FiveTiger()

        '命宮
        '以中氣換月，大寒立春當正月、雨水驚蟄當二月...
        '卯上起正月,逆至生月,再逆至生時
        '命宮地支
        n = 4 - jstep
        If n < 1 Then n = n + 12

        mkj = n - hstep
        If mkj < 1 Then mkj = mkj + 12
        If mkj > 12 Then mkj = mkj Mod 12

        '命宮天干
        '寅到命宮移位間隔
        mkstep = mkj - 3
        If mkstep < 0 Then mkstep = mkstep + 12

        '寅上順數天干到命宮
        mkk = ONE_MTK + mkstep
        If mkk > 10 Then mkk = mkk - 10

        '=========================================
        '身宮
        '卯上起正月,順至生月,再順至生時
        '身宮地支
        skj = 4 + mstep + hstep
        If skj > 12 Then skj = skj Mod 12
        If skj = 0 Then skj = skj + 12

        '身宮天干
        '寅到身宮移位間隔
        skstep = skj - 3
        If skstep < 0 Then skstep = skstep + 12

        '寅上順數天干到命宮
        skk = ONE_MTK + skstep
        If skk > 10 Then skk = skk - 10

        '=========================================
        '胎元: 月柱天干加一, 地支加三
        '胎元天干
        tik = BirthData(2, 3) + 1
        If tik < 1 Then tik = tik + 10
        If tik > 10 Then tik = tik - 10

        '胎元地支
        tij = BirthData(2, 4) + 3
        If tij < 1 Then tij = tij + 12
        If tij > 12 Then tij = tij - 12

        '=========================================
        '息元: 日柱天干地支相合
        '息元天干
        n = BirthData(3, 3)
        '天干相合計算 (天干加五)
        sik = n + 5
        If sik > 10 Then sik = sik - 10

        '息元地支
        n = BirthData(3, 4)
        '地支相合計算 (丑上起子逆行)
        sij = 3 - n
        If sij < 1 Then sij = sij + 12

    End Sub

    '=================================================================================
    '=== 干支配色
    '=================================================================================
    Sub lable_color()
        '甲乙木綠色
        If innum = 1 Or innum = 2 Then textcolor = "LimeGreen"
        '丙丁火紅色
        If innum = 3 Or innum = 4 Then textcolor = "Red"
        '戊己土茶色
        If innum = 5 Or innum = 6 Then textcolor = "DarkGoldenrod"
        '庚辛金橙黃色
        If innum = 7 Or innum = 8 Then textcolor = "Orange"
        '壬癸水藍色
        If innum = 9 Or innum = 10 Then textcolor = "Blue"

    End Sub

    '=================================================================================
    '=== 十神變化
    '=================================================================================
    Sub TenGods()
        Dim n, z, ZK As Integer
        '日主
        ZK = BirthData(3, 3)

        n = TK - ZK
        If n < 0 Then n = n + 10

        z = ZK Mod 2
        If z = 1 Then
            '陽日主
            Select Case n
                Case 0 : TG = "比肩" : TG_SE = "比"
                Case 1 : TG = "劫財" : TG_SE = "劫"
                Case 2 : TG = "食神" : TG_SE = "食"
                Case 3 : TG = "傷官" : TG_SE = "傷"
                Case 4 : TG = "偏財" : TG_SE = "才"
                Case 5 : TG = "正財" : TG_SE = "財"
                Case 6 : TG = "七殺" : TG_SE = "殺"
                Case 7 : TG = "正官" : TG_SE = "官"
                Case 8 : TG = "偏印" : TG_SE = "梟"
                Case 9 : TG = "正印" : TG_SE = "印"
            End Select
        Else
            '陰日主
            Select Case n
                Case 0 : TG = "比肩" : TG_SE = "比"
                Case 1 : TG = "傷官" : TG_SE = "傷"
                Case 2 : TG = "食神" : TG_SE = "食"
                Case 3 : TG = "正財" : TG_SE = "財"
                Case 4 : TG = "偏財" : TG_SE = "才"
                Case 5 : TG = "正官" : TG_SE = "官"
                Case 6 : TG = "七殺" : TG_SE = "殺"
                Case 7 : TG = "正印" : TG_SE = "印"
                Case 8 : TG = "偏印" : TG_SE = "梟"
                Case 9 : TG = "劫財" : TG_SE = "劫"
            End Select
        End If

    End Sub

    '=================================================================================
    '=== 地支轉換天干
    '=================================================================================
    Sub DJToTK()
        Select Case BDJ
            Case 1    '子
                DK1 = 10
                DK2 = 0
                DK3 = 0
            Case 2    '丑
                DK1 = 6
                DK2 = 10
                DK3 = 8
            Case 3    '寅
                DK1 = 1
                DK2 = 3
                DK3 = 5
            Case 4    '卯
                DK1 = 2
                DK2 = 0
                DK3 = 0
            Case 5    '辰
                DK1 = 5
                DK2 = 2
                DK3 = 10
            Case 6    '巳
                DK1 = 3
                DK2 = 5
                DK3 = 7
            Case 7    '午
                DK1 = 4
                DK2 = 6
                DK3 = 0
            Case 8    '未
                DK1 = 6
                DK2 = 4
                DK3 = 2
            Case 9    '申
                DK1 = 7
                DK2 = 9
                DK3 = 5
            Case 10   '酉
                DK1 = 8
                DK2 = 0
                DK3 = 0
            Case 11   '戌
                DK1 = 5
                DK2 = 8
                DK3 = 4
            Case 12   '亥
                DK1 = 9
                DK2 = 1
                DK3 = 0
        End Select
    End Sub
    '=================================================================================
    '=== 天干地支取十神配色
    '=================================================================================
    Sub KJTGC()
        '天干顏色與十神
        innum = BTK
        lable_color()
        tk_color = textcolor
        If ppc = 1 Then
            TK = BTK
            TenGods()
            TKTG = TG_SE
        End If

        '地支藏干顏色與十神
        DJToTK()
        innum = DK1
        lable_color()
        dk1_color = textcolor
        innum = DK2
        lable_color()
        dk2_color = textcolor
        innum = DK3
        lable_color()
        dk3_color = textcolor

        If ppc = 1 Then
            TK = DK1
            TenGods()
            DK1TG = TG_SE
            TK = DK2
            TenGods()
            DK2TG = TG_SE
            TK = DK3
            TenGods()
            DK3TG = TG_SE
        End If

    End Sub

    '=================================================================================
    '=== 取得大運每柱交節氣時間點與干支歲數
    '=================================================================================
    Sub getdaun_stime()
        Dim x, y, st, MyDate, MyStr, DAYY, DAMM, DADD, TT As String
        Dim i, n, z, dn, sumjday, T As Integer

        '起運節氣點
        If BirthData(7, 1) = BirthData(7, 2) Then
            '陽男陰女
            STM_ONE = STM_LINE + 2
        Else
            '陰男陽女
            STM_ONE = STM_LINE
        End If

        '====== 目前日期時間 (年/月/日 時:分)
        birth_day = DateSerial(BirthData(1, 1), BirthData(2, 1), BirthData(3, 1))
        x = BirthData(4, 1)
        y = BirthData(5, 1)
        st = x + ":" + y
        birth_time = birth_day + " " + st

        '計算交大運日期
        If BirthData(7, 1) = BirthData(7, 2) Then
            '陽男陰女
            '計算生於節氣後幾天
            For i = 0 To 11
                READ_LINE = STM_ONE + (i * 2)
                GetSolarTermTime()
                daunstm(i + 1) = JCPOINT
                '計算換運總時數
                '生日到節氣差距總分數,1分鐘等於1個時辰
                n = DateDiff("n", birth_time, daunstm(i + 1)) * 120
                daunhours(i + 1) = n

                '計算換運日期
                z = n \ 1440
                MyDate = DateAdd("d", z, birth_day)
                DAYY = DatePart("YYYY", MyDate) : DAMM = DatePart("M", MyDate) : DADD = DatePart("D", MyDate)
                '個位數補0
                T = DAMM
                If T < 10 Then
                    TT = "0" + DAMM
                    DAMM = TT
                End If
                T = DADD
                If T < 10 Then
                    TT = "0" + DADD
                    DADD = TT
                End If
                MyStr = DAYY + "年" + DAMM + "月" + DADD + "日"
                daundate(i + 1) = MyStr

            Next
        Else
            '陰男陽女
            '計算生於節氣後幾天
            For i = 0 To 11
                READ_LINE = STM_ONE - (i * 2)
                GetSolarTermTime()
                daunstm(i + 1) = JCPOINT
                '計算換運總時數
                '生日到節氣差距總分數,1分鐘等於1個時辰
                n = DateDiff("n", daunstm(i + 1), birth_time) * 120
                daunhours(i + 1) = n

                '計算換運日期
                z = n \ 1440
                MyDate = DateAdd("d", z, birth_day)
                DAYY = DatePart("YYYY", MyDate) : DAMM = DatePart("M", MyDate) : DADD = DatePart("D", MyDate)
                '個位數補0
                T = DAMM
                If T < 10 Then
                    TT = "0" + DAMM
                    DAMM = TT
                End If
                T = DADD
                If T < 10 Then
                    TT = "0" + DADD
                    DADD = TT
                End If
                MyStr = DAYY + "年" + DAMM + "月" + DADD + "日"
                daundate(i + 1) = MyStr
            Next
        End If

        '計算起運歲數
        If BirthData(7, 1) = BirthData(7, 2) Then
            sumjday = DateDiff("h", birth_time, daunstm(1)) \ 24
        Else
            sumjday = DateDiff("h", daunstm(1), birth_time) \ 24
        End If

        n = sumjday Mod 3

        If n > 1 Then
            dn = sumjday \ 3 + 1
        Else
            dn = sumjday \ 3
        End If

        If sumjday < 2 Then dn = 0

        '計算大運歲數
        For i = 0 To 11
            daunage(i + 1) = Str(10 * i + dn) + " - " + Str(10 * i + dn + 9)
        Next

        '計算大運天干地支
        For i = 1 To 12
            '陽男陰女順行
            If BirthData(7, 1) = BirthData(7, 2) Then
                '天干
                n = BirthData(2, 3) + i
                If n > 10 Then n = n - 10
                dauntk(i) = n
                '地支
                n = BirthData(2, 4) + i
                If n > 12 Then n = n - 12
                daundj(i) = n
            Else
                '陰男陽女逆行
                '天干
                n = BirthData(2, 3) - i
                If n < 1 Then n = n + 10
                dauntk(i) = n
                '地支
                n = BirthData(2, 4) - i
                If n < 1 Then n = n + 12
                daundj(i) = n
            End If
        Next

    End Sub
    '=================================================================================
    '=== 大運限步計算
    '=================================================================================
    Sub daun_setp()
        Dim CTS As Integer

        '生日到目前總分數
        CTS = DateDiff("n", birth_time, CTIME)

        If CTS < daunhours(1) Then
            DA_STEP = 0
        ElseIf CTS > daunhours(1) And CTS < daunhours(2) Then
            DA_STEP = 1
        ElseIf CTS > daunhours(2) And CTS < daunhours(3) Then
            DA_STEP = 2
        ElseIf CTS > daunhours(3) And CTS < daunhours(4) Then
            DA_STEP = 3
        ElseIf CTS > daunhours(4) And CTS < daunhours(5) Then
            DA_STEP = 4
        ElseIf CTS > daunhours(5) And CTS < daunhours(6) Then
            DA_STEP = 5
        ElseIf CTS > daunhours(6) And CTS < daunhours(7) Then
            DA_STEP = 6
        ElseIf CTS > daunhours(7) And CTS < daunhours(8) Then
            DA_STEP = 7
        ElseIf CTS > daunhours(8) And CTS < daunhours(9) Then
            DA_STEP = 8
        ElseIf CTS > daunhours(9) And CTS < daunhours(10) Then
            DA_STEP = 9
        ElseIf CTS > daunhours(10) And CTS < daunhours(11) Then
            DA_STEP = 10
        ElseIf CTS > daunhours(11) And CTS < daunhours(12) Then
            DA_STEP = 11
        ElseIf CTS > daunhours(12) Then
            DA_STEP = 12

        End If

    End Sub
    '=================================================================================
    '=== 歲數計算 (實歲)
    '=================================================================================
    Sub agex()
        Dim x1, x2 As String
        Dim n1, n2, age, diff_day As Integer
        '生年
        n1 = BirthData(1, 1)
        '日前年份
        n2 = SolarYear

        age = n2 - n1

        '計算年齡
        x1 = DateSerial(SolarYear, BirthData(2, 1), BirthData(3, 1))
        x2 = DateSerial(SolarYear, SolarMonth, SolarDay)

        diff_day = DateDiff("d", x1, x2)

        If diff_day < 0 Then age = age - 1

        '實歲
        ages = age

        '虛歲
        'ages = age + 1

        If ages < 1 Then ages = 0
        If ages > 119 Then ages = 120

    End Sub

    '=================================================================================
    '=== 五行旺衰 計算天干五行
    '=================================================================================
    Sub CLCTK()
        Dim K As Integer
        K = (TKX + 1) \ 2

        Select Case K
            Case 1 : Wood = Wood + 5
            Case 2 : Fire = Fire + 5
            Case 3 : Earth = Earth + 5
            Case 4 : Metal = Metal + 5
            Case 5 : Water = Water + 5
        End Select

    End Sub

    '=================================================================================
    '=== 五行旺衰 計算地支五行
    '=================================================================================
    Sub CLCDJ()
        Select Case DJX
            Case 1 '子
                Water = Water + (8 * MUL)
            Case 2 '丑
                Earth = Earth + (5 * MUL)
                Water = Water + (2 * MUL)
                Metal = Metal + (1 * MUL)
            Case 3 '寅
                Wood = Wood + (5 * MUL)
                Fire = Fire + (2 * MUL)
                Earth = Earth + (1 * MUL)
            Case 4 '卯
                Wood = Wood + (8 * MUL)
            Case 5 '辰
                Earth = Earth + (5 * MUL)
                Wood = Wood + (2 * MUL)
                Water = Water + (1 * MUL)
            Case 6 '巳
                Fire = Fire + (5 * MUL)
                Earth = Earth + (2 * MUL)
                Metal = Metal + (1 * MUL)
            Case 7 '午
                Fire = Fire + (5 * MUL)
                Earth = Earth + (3 * MUL)
            Case 8 '未
                Earth = Earth + (5 * MUL)
                Fire = Fire + (2 * MUL)
                Wood = Wood + (1 * MUL)
            Case 9 '申
                Metal = Metal + (5 * MUL)
                Water = Water + (2 * MUL)
                Earth = Earth + (1 * MUL)
            Case 10 '酉
                Metal = Metal + (8 * MUL)
            Case 11 '戌
                Earth = Earth + (5 * MUL)
                Metal = Metal + (2 * MUL)
                Fire = Fire + (1 * MUL)
            Case 12 '亥
                Water = Water + (5 * MUL)
                Wood = Wood + (3 * MUL)
        End Select

    End Sub

End Module
