<?php

/**
 *
 * @category MultiSafepay
 * @package  MultiSafepay_Msp
 */
class MultiSafepay_Msp_Helper_Data extends Mage_Core_Helper_Abstract
{
    const CONVERT_TO_CURRENCY_CODE = 'EUR';

    /**
     * Get payment icon and title
     *
     * @param $method MultiSafepay_Msp_Model_Gateway_Abstract
     * @return string
     */
    public function getPaymentTitle($method)
    {
        $return = '';

        if (!is_subclass_of($method, 'MultiSafepay_Msp_Model_Gateway_Abstract')) {
            return;
        }

        $paymentCode = strtolower($method->getCode());
        $paymentTitle = $method->getTitle();

        $isShowImg = Mage::getStoreConfig('msp/settings/show_gateway_images');
        $isShowImgWithName = Mage::getStoreConfig('msp/settings/show_gateway_title_combi');

        if ($isShowImg || $isShowImgWithName) {
            $iconUrl = $method->getIconUrl($this->_getLangISO2());
            if (!empty($iconUrl)) {
                $return = '<img src="' . $iconUrl . '" id="' . 'msp_' . $paymentCode . '" title="' . $paymentTitle . '" />&nbsp;';
                /*
                    if ($isShowImgWithName) {
                        $return .= '<span class="gateway-title"> - ' . $paymentTitle . '</span>';
                    }
                */
            }
        }
        /*
            if ($return == '') {
                $return = $paymentTitle;
            }
        */
        echo $return;
        // return $return;
    }

    /**
     * Get Fee Description
     *
     * @return string
     */
    public function getFeeLabel($code)
    {
        $feeDescription = trim(Mage::getStoreConfig('msp_gateways/' . $code . '/fee_description'));

        return $feeDescription ? $feeDescription : $this->__('MultiSafepay servicekosten');
    }

    /**
     * Check are you in the Admin area
     *
     * @return bool
     */
    public function isAdmin()
    {
        if (Mage::app()->getStore()->isAdmin() || Mage::getDesign()->getArea() == 'adminhtml') {
            return true;
        }

        return false;
    }

    /**
     * Check is Magento Enterprise Edition
     *
     * @return bool
     */
    public function isEnterprise()
    {
        return (bool) Mage::getConfig()->getModuleConfig('Enterprise_Enterprise')->version;
    }

    /**
     * Restore
     *
     * @param $quote  Mage_Sales_Model_Quote
     * @param $status string
     * @return bool
     */
    public function restoreCart(Mage_Sales_Model_Quote $quote, $status)
    {
        $storeId = $quote->getStoreId();
        $gatewayMethod = $quote->getPayment()->getMethod();

        $needRestore = false;
        $statuses = array('cancelled', 'expired', 'declined', 'void');

        if (Mage::getStoreConfig('payment/msp/keep_cart', $storeId) ||
            Mage::getStoreConfig('msp/settings/keep_cart', $storeId) ||
            in_array($gatewayMethod, array('msp_payafter', 'msp_einvoice', 'msp_klarna', 'msp_afterpay', 'msp_in3', 'msp_zinia', 'msp_payafterdeliveryinstallments'))) {
            $needRestore = true;
        }

        if ($needRestore && in_array($status, $statuses)) {
            $quote->setIsActive(true)
                ->setReservedOrderId(null)
                ->save();

            return true;
        }

        return false;
    }

    /**
     * Get Locale code
     *
     * @return string
     */
    protected function _getLangISO2()
    {
        $locale = explode('_', Mage::app()->getLocale()->getLocale());
        if (is_array($locale) && isset($locale[0])) {
            return strtolower($locale[0]);
        }

        return 'en';
    }

    public function getTokenizationByRecurringHash($hash)
    {
        $recurrings = Mage::getModel('msp/tokenization')->getCollection()->addFieldToFilter('recurring_hash', $hash);
        return $recurrings->getFirstItem();
    }

    public function getTokenizationByOrderId($id)
    {
        $recurrings = Mage::getModel('msp/tokenization')->getCollection()->addFieldToFilter('order_id', $id);
        return $recurrings->getFirstItem();
    }

    public function getTokenizationsByCustomerId($id = null)
    {
        if (is_null($id)) {
            $id = Mage::helper('customer')->getCustomer()->getId();
        }
        $recurrings = Mage::getModel('msp/tokenization')->getCollection()->addFieldToFilter('customer_id', $id);
        return $recurrings;
    }

    public function encrypt($string)
    {
        return Mage::helper('core')->encrypt($string);
    }

    public function decrypt($encrypt)
    {
        return Mage::helper('core')->decrypt($encrypt);
    }

    public function uniqueHash()
    {
        return Mage::helper('core')->uniqHash();
    }

    /**
     * @param Mage_Sales_Model_Order $order
     * @return bool
     */
    public function canCancelOrder(Mage_Sales_Model_Order $order)
    {
        if ($order->getState() == Mage_Sales_Model_Order::STATE_NEW || $order->getState() == Mage_Sales_Model_Order::STATE_PENDING_PAYMENT) {
            return true;
        } else {
            return false;
        }
    }
}
