<?php

/**
 *
 * @category MultiSafepay
 * @package  MultiSafepay_Msp
 */
abstract class MultiSafepay_Msp_Model_Gateway_Genericbase extends MultiSafepay_Msp_Model_Gateway_Abstract
{
    const UPLOAD_DIR = 'multisafepay/icons';

    protected $_formBlockType = 'msp/generic';

    /**
     * get the configured gateway from the database
     */
    public function getGateway()
    {
        return $this->getConfigData('gateway');
    }

    public function backendOrdersAllowed()
    {
        return true;
    }

    public function isAvailableMethod()
    {
        return true;
    }

    /**
     * get the url of the configured gateway icon from the database
     */
    public function getIconUrl($locale = 'en')
    {
        $fileName = $this->getConfigData('icon');
        if ($fileName) {
            $uploadDir = self::UPLOAD_DIR;
            $fullFileName = Mage::getBaseDir('media') . DS . $uploadDir . DS . $fileName;
            if (file_exists($fullFileName)) {
                return Mage::getBaseUrl('media') . $uploadDir . '/' . $fileName;
            }
        }
        return Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . "msp/$locale/msp_multisafepay.png";
    }
}
