<?php

/**
 *
 * @category MultiSafepay
 * @package  MultiSafepay_Msp
 */
class MultiSafepay_Msp_Model_Gateway_Zinia extends MultiSafepay_Msp_Model_Gateway_Abstract
{
    public $_model = "zinia";
    public $_gateway = "ZINIA";

    protected $_code = "msp_zinia";
    protected $_formBlockType = 'msp/zinia';
    protected $_canUseCheckout = true;

    public function getOrderPlaceRedirectUrl()
    {
        $birthday = $_POST['payment']['birthday'] ?? '';
        $salutation = $_POST['payment']['salutation'] ?? '';
        $phonenumber = $_POST['payment']['phonenumber'] ?? '';

        $url = $this->getModelUrl("msp/standard/redirect");
        if (!strpos($url, "?")) {
            $url .= '?birthday=' . $birthday . '&salutation=' . $salutation . '&phonenumber=' . urlencode($phonenumber);
        } else {
            $url .= '&birthday=' . $birthday . '&salutation=' . $salutation . '&phonenumber=' . urlencode($phonenumber);
        }
        return $url;
    }
}
