<?php

/**
 *
 * @category MultiSafepay
 * @package  MultiSafepay_Msp
 */
/** @var $this MultiSafepay_Msp_Model_Setup */

$installer = $this;
$installer->startSetup();

$obsoleteFields = [
    'account_id_pad',
    'site_id_pad',
    'secure_code_pad',
    'account_id_pad_test',
    'site_id_pad_test',
    'secure_code_pad_test',
];

$gateways = [
    'msp_payafter',
    'msp_einvoice',
    'msp_klarna',
];

$giftcards = [
    'msp_babygiftcard',
    'msp_beautyandwellness',
    'msp_boekenbon',
    'msp_erotiekbon',
    'msp_fashioncheque',
    'msp_fashiongiftcard',
    'msp_gezondheidsbon',
    'msp_givacard',
    'msp_parfumcadeaukaart',
    'msp_podium',
    'msp_sportenfit',
    'msp_vvvgiftcard',
    'msp_webgift',
    'msp_wijncadeau',
    'msp_yourgift',
];

// Remove unused config data
$installer->deleteConfigData('msp/settings/account_id');
$installer->deleteConfigData('msp/settings/site_id');
$installer->deleteConfigData('msp/settings/secure_code');
$installer->deleteConfigData('mspcheckout/settings/account_id');
$installer->deleteConfigData('mspcheckout/settings/site_id');
$installer->deleteConfigData('mspcheckout/settings/secure_code');

// Remove unused gateways config data
foreach ($gateways as $gateway) {
    foreach ($obsoleteFields as $obsoleteField) {
        $installer->deleteConfigData('msp_gateways/' . $gateway . '/' . $obsoleteField);
    }
}

// Remove unused giftcards config data
foreach ($giftcards as $giftcard) {
    foreach ($obsoleteFields as $obsoleteField) {
        $installer->deleteConfigData('msp_giftcards/' . $giftcard . '/' . $obsoleteField);
    }
}

// Delete shipment request option as it becomes required
$installer->deleteConfigData('msp_gateways/msp_payafter/send_request_after_shipping');
$installer->deleteConfigData('msp_gateways/msp_einvoice/send_request_after_shipping');
$installer->deleteConfigData('msp_gateways/msp_klarna/send_request_after_shipping');
$installer->deleteConfigData('msp_gateways/msp_afterpay/send_request_after_shipping');
$installer->deleteConfigData('msp_gateways/msp_betaalplan/send_request_after_shipping');

// Update title for Santander Betaalplan
$installer->setConfigData('msp_gateways/msp_betaalplan/title', 'Pay per Month');
// Update title for Klarna
$installer->setConfigData('msp_gateways/msp_klarna/title', 'Klarna - buy now, pay later');
// Update title for Direct Bank transfer
$installer->setConfigData('msp_gateways/msp_directbanktransfer/title', 'Request to Pay');
// Update KBC title
$installer->setConfigData('msp_gateways/msp_kbc/title', 'KBC');
// Update ING Home'Pay title
$installer->setConfigData('msp_gateways/msp_ing/title', "ING Home'Pay");
// Update Card payment title
$installer->setConfigData('msp_gateways/msp_creditcard/title', 'Card payment');
// Update E-Invoicing title
$installer->setConfigData('msp_gateways/msp_einvoice/title', 'E-Invoicing');

// PLGMAGONE-674: Remove use_redirect option
$installer->deleteConfigData('msp/settings/use_redirect');
$installer->deleteConfigData('mspcheckout/settings/use_redirect');

$installer->endSetup();
