<?php

/**
 *
 * @category MultiSafepay
 * @package  MultiSafepay_Msp
 */
class MultiSafepay_Msp_Block_Mybankissuers extends Mage_Payment_Block_Form
{

    /**
     * Construct
     */
    protected function _construct()
    {
        $gateway_select = Mage::getStoreConfig('msp_gateways/msp_mybank/issuer_select');
        if ($gateway_select) {
            parent::_construct();
            $this->setTemplate('msp/mybankissuers.phtml');
        }
    }

    /**
     * @return array
     */
    public function getMyBankIssuersForTemplate(): array
    {
        /** @var $msp MultiSafepay_Msp_Model_Gateway_Mybank */
        $msp = Mage::getSingleton('msp/gateway_mybank');
        return $msp->getMyBankIssuers();
    }
}
