<?php

class MultiSafepay_Msp_Helper_Address extends Mage_Core_Helper_Abstract
{
    /**
     * @param Mage_Sales_Model_Quote_Address $billingAddress
     * @param Mage_Sales_Model_Quote_Address $shippingAddress
     * @return bool
     */
    public function isSameAddress(Mage_Sales_Model_Quote_Address $billingAddress, Mage_Sales_Model_Quote_Address $shippingAddress)
    {
        return $this->serializeAddress($billingAddress) === $this->serializeAddress($shippingAddress);
    }

    /**
     * @param Mage_Sales_Model_Quote_Address $address
     * @return string
     */
    public function serializeAddress(Mage_Sales_Model_Quote_Address $address)
    {
        return serialize([
            'street' => $address->getStreet(),
            'city' => $address->getCity(),
            'postcode' => $address->getPostcode(),
        ]);
    }
}
