<?php

/**
 *
 * @category MultiSafepay
 * @package  MultiSafepay_Msp
 */
class MultiSafepay_Msp_Model_Gateway_In3 extends MultiSafepay_Msp_Model_Gateway_Abstract
{
    public $_model = "in3";
    public $_gateway = "IN3";

    protected $_code = "msp_in3";
    protected $_formBlockType = 'msp/in3';
    protected $_canUseCheckout = true;

    public function getOrderPlaceRedirectUrl()
    {
        $birthday = isset($_POST['payment']['birthday']) ? $_POST['payment']['birthday'] : '';
        $phonenumber = isset($_POST['payment']['phonenumber']) ? $_POST['payment']['phonenumber'] : '';

        $url = $this->getModelUrl("msp/standard/redirect/issuer/" . $this->_issuer);
        if (!strpos($url, "?")) {
            $url .= '?birthday=' . $birthday . '&phonenumber=' . urlencode($phonenumber);
        } else {
            $url .= '&birthday=' . $birthday . '&phonenumber=' . urlencode($phonenumber);
        }
        return $url;
    }
}
