<?php

/**
 *
 * @property array|mixed|null $_issuer
 * @category MultiSafepay
 * @package  MultiSafepay_Msp
 */
class MultiSafepay_Msp_Model_Gateway_Mybank extends MultiSafepay_Msp_Model_Gateway_Abstract
{
    protected $_code = 'msp_mybank';
    public $_model = 'mybank';
    public $_gateway = 'MYBANK';
    protected $_formBlockType = 'msp/mybankissuers';

    public function assignData($data)
    {
        parent::assignData($data);
        $session = Mage::getSingleton('checkout/session');
        $session->setData('payment_additional', $data);
        return $this;
    }

    public function getPayment($storeId = null)
    {
        $payment = parent::getPayment($storeId);
        $payment->setIssuer($this->_issuer);

        return $payment;
    }

    public function getMyBankIssuers()
    {
        return $this->getIssuersHTML($this->_model);
    }
}
