import type { Predicate2 } from "@thi.ng/api";
/**
 * Takes an array of numbers and returns the index of the item which is
 * considered the minimum value according to the given initial `min` value
 * (default: ∞) and predicate (both optional). Returns -1 if `items` is empty.
 *
 * @remarks
 * See {@link argMax}.
 *
 * @example
 * ```ts tangle:../export/argmin.ts
 * import { argMin } from "@thi.ng/arrays";
 *
 * console.log(
 *   argMin([42, 11, 66, 23])
 * );
 * // 1
 *
 * // same as argmax() with defaults
 * console.log(
 *   argMin([42, 11, 66, 23], -Infinity, (a, b) => a > b)
 * );
 * // 2
 * ```
 *
 * @param buf
 * @param min
 * @param pred
 */
export declare const argMin: (buf: ArrayLike<number>, min?: number, pred?: Predicate2<number>) => number;
/**
 * Similar to {@link argMin}, but selects index of maximum item. Returns -1 if
 * `items` is empty.
 *
 * @param items
 * @param min
 * @param pred
 */
export declare const argMax: (items: ArrayLike<number>, min?: number, pred?: Predicate2<number>) => number;
//# sourceMappingURL=argmin.d.ts.map