function blit1d(dest, x, src, mask) {
  const [sx, sw, dx, dw] = __clip(0, src.length, x, dest.length);
  if (sw < 1 || dx >= dw) return dest;
  for (let i = 0; i < sw; i++) {
    const val = src[sx + i];
    val !== mask && (dest[dx + i] = val);
  }
  return dest;
}
function blitPred1d(dest, x, src, pred) {
  const [sx, sw, dx, dw] = __clip(0, src.length, x, dest.length);
  if (sw < 1 || dx >= dw) return dest;
  for (let i = 0; i < sw; i++) {
    const val = pred(src[sx + i], dest[dx + i], sx + i);
    val !== void 0 && (dest[dx + i] = val);
  }
  return dest;
}
function blit2d(dest, dpos, dsize, src, ssize, mask) {
  const [sx, sw, dx, dw] = __clip(0, ssize[0], dpos[0], dsize[0]);
  const [sy, sh, dy, dh] = __clip(0, ssize[1], dpos[1], dsize[1]);
  if (sw < 1 || sh < 1 || dx >= dw || dy >= dh) return dest;
  const sstride = ssize[0];
  const dstride = dsize[0];
  for (let y = 0; y < sh; y++) {
    for (let x = 0, soff = (sy + y) * sstride + sx, doff = (dy + y) * dstride + dx; x < sw; x++) {
      const val = src[soff + x];
      val !== mask && (dest[doff + x] = val);
    }
  }
  return dest;
}
const __clip = (sx, sw, dx, dw) => {
  if (dx < 0) {
    sx -= dx;
    sw += dx;
    dx = 0;
  } else if (dx + sw > dw) {
    sw = dw - dx;
  }
  return [sx, sw, dx, dw];
};
export {
  blit1d,
  blit2d,
  blitPred1d
};
