import type { TypedArray } from "@thi.ng/api";
/**
 * Returns index of `needle` sequence in a larger buffer or -1 if unsuccessful.
 * Search only starts at given `start` index.
 *
 * @remarks
 * TODO Also add Boyer-Moore implementation as alternative for longer sequences
 * (but with more overhead).
 *
 * @example
 * ```ts tangle:../export/find-seq.ts
 * import { findSequence } from "@thi.ng/arrays";
 *
 * console.log(
 *   findSequence([1, 2, 3, 1, 2, 3, 4], [1, 2, 3, 4])
 * );
 * // 3
 * ```
 *
 * @param buf
 * @param needle
 * @param start
 */
export declare function findSequence<T>(buf: Array<T>, needle: ArrayLike<T>, start?: number): number;
export declare function findSequence(buf: TypedArray, needle: ArrayLike<number>, start?: number): number;
//# sourceMappingURL=find-sequence.d.ts.map