import type { Predicate2 } from "@thi.ng/api";
/**
 * Similar to `Array.find()`, but uses [`equiv()`](https://docs.thi.ng/umbrella/equiv/functions/equiv.html) as
 * default predicate.
 *
 * @param buf - array
 * @param x - search value
 * @param equiv - equivalence predicate
 */
export declare const find: <T>(buf: ArrayLike<T>, x: T, equiv?: Predicate2<T>) => T | undefined;
/**
 * Similar to `Array.findIndex()`, but uses
 * [`equiv()`](https://docs.thi.ng/umbrella/equiv/functions/equiv.html) as
 * default predicate.
 *
 * @param buf - array
 * @param x - search value
 * @param equiv - equivalence predicate
 */
export declare const findIndex: <T>(buf: ArrayLike<T>, x: T, equiv?: Predicate2<T>) => number;
//# sourceMappingURL=find.d.ts.map