import type { Predicate2 } from "@thi.ng/api";
/**
 * Performs a fuzzy search of `query` in `domain` and returns `true` if
 * successful.
 *
 * @remarks
 * The optional `equiv` predicate can be used to customize item equality
 * checking. Uses
 * [`equiv()`](https://docs.thi.ng/umbrella/equiv/functions/equiv.html) by
 * default.
 *
 * Adapted and generalized from: https://github.com/bevacqua/fufuzzyzzysearch
 * (MIT licensed)
 *
 * [`filterFuzzy()`](https://docs.thi.ng/umbrella/transducers/functions/filterFuzzy.html)
 *
 * @param domain - array
 * @param query - search value
 * @param equiv - equivalence predicate
 */
export declare const fuzzyMatch: <T>(domain: ArrayLike<T>, query: ArrayLike<T>, equiv?: Predicate2<any>) => boolean;
//# sourceMappingURL=fuzzy-match.d.ts.map