import { assert } from "@thi.ng/errors/assert";
const topoSort = (nodes, deps) => {
  const cycles = {};
  const topology = [];
  const sort = (id, path) => {
    assert(nodes[id] != null, `missing node: ${id}`);
    assert(!cycles[id], `dependency cycle: ${path.join(" -> ")}`);
    cycles[id] = true;
    const nodeDeps = deps(nodes[id], id);
    if (nodeDeps) {
      for (let d of nodeDeps) sort(d, [...path, d]);
    }
    cycles[id] = false;
    if (!topology.includes(id)) topology.push(id);
  };
  for (let id in nodes) sort(id, [id]);
  return topology;
};
export {
  topoSort
};
