function juxt(...fns) {
  const [a, b, c, d, e, f, g, h] = fns;
  switch (fns.length) {
    case 1:
      return (x) => [a(x)];
    case 2:
      return (x) => [a(x), b(x)];
    case 3:
      return (x) => [a(x), b(x), c(x)];
    case 4:
      return (x) => [a(x), b(x), c(x), d(x)];
    case 5:
      return (x) => [a(x), b(x), c(x), d(x), e(x)];
    case 6:
      return (x) => [a(x), b(x), c(x), d(x), e(x), f(x)];
    case 7:
      return (x) => [a(x), b(x), c(x), d(x), e(x), f(x), g(x)];
    case 8:
      return (x) => [a(x), b(x), c(x), d(x), e(x), f(x), g(x), h(x)];
    default:
      return (x) => {
        let res = new Array(fns.length);
        for (let i = fns.length; i-- > 0; ) {
          res[i] = fns[i](x);
        }
        return res;
      };
  }
}
function juxtAsync(...fns) {
  return async (x) => await Promise.all(fns.map((f) => f(x)));
}
export {
  juxt,
  juxtAsync
};
