import type { FnN2 } from "@thi.ng/api";
/**
 * Returns the absolute difference between `a` and `b`.
 *
 * @param a
 * @param b
 */
export declare const absDiff: FnN2;
/**
 * Similar to `Math.sign()`, but uses `eps` to determine the zero value (i.e. if
 * `x` is in [-eps,eps] interval).
 *
 * @param x
 * @param eps
 */
export declare const sign: (x: number, eps?: number) => 1 | 0 | -1;
/**
 * Raises `x` to `k` power and multiplies it with the {@link sign} of `x`, using
 * `eps` to determine zero.
 *
 * @param x
 * @param k
 * @param eps
 */
export declare const signedPow: (x: number, k: number, eps?: number) => number;
//# sourceMappingURL=abs.d.ts.map