import type { FnU3 } from "@thi.ng/api";
/**
 * Returns true if `b` is a local minima, i.e. iff a > b and b < c.
 *
 * @param a -
 * @param b -
 * @param c -
 */
export declare const isMinima: FnU3<number, boolean>;
/**
 * Returns true if `b` is a local maxima, i.e. iff a < b and b > c.
 *
 * @param a -
 * @param b -
 * @param c -
 */
export declare const isMaxima: FnU3<number, boolean>;
/**
 * Returns index of the first local & internal minima found in given
 * `values` array, or -1 if no such minima exists. The search range can
 * be optionally defined via semi-open [from, to) index interval.
 *
 * @param values -
 * @param from -
 * @param to -
 */
export declare const minimaIndex: (values: number[], from?: number, to?: number) => number;
/**
 * Returns index of the first local & internal maxima found in given
 * `values` array, or -1 if no such maxima exists. The search range can
 * be optionally defined via semi-open [from, to) index interval.
 *
 * @param values -
 * @param from -
 * @param to -
 */
export declare const maximaIndex: (values: number[], from?: number, to?: number) => number;
/**
 * Returns an iterator yielding all minima indices in given `values`
 * array. The search range can be optionally defined via semi-open
 * [from, to) index interval.
 *
 * @param values -
 * @param from -
 * @param to -
 */
export declare const minimaIndices: (values: number[], from?: number, to?: number) => Generator<number, void, unknown>;
/**
 * Returns an iterator yielding all maxima indices in given `values`
 * array. The search range can be optionally defined via semi-open
 * [from, to) index interval.
 *
 * @param values -
 * @param from -
 * @param to -
 */
export declare const maximaIndices: (values: number[], from?: number, to?: number) => Generator<number, void, unknown>;
//# sourceMappingURL=extrema.d.ts.map