/**
 * Returns iterator of all prime numbers ≤ given `x` using Sieve of
 * Eratosthenes.
 *
 * @remarks
 * Reference: https://en.wikipedia.org/wiki/Sieve_of_Eratosthenes
 *
 * @param x -
 */
export declare function primesUntil(x: number): Generator<number, void, unknown>;
/**
 * Returns largest prime number ≤ given `x` using Sieve of Eratosthenes. Returns
 * -1 if x < 1.
 *
 * @remarks
 * Reference: https://en.wikipedia.org/wiki/Sieve_of_Eratosthenes
 *
 * @param x -
 */
export declare const nearestPrime: (x: number) => number;
//# sourceMappingURL=prime.d.ts.map