import type { IRandom } from "./api.js";
/**
 * Returns true w/ a (theoretical) probability of 50% (obviously depending on
 * quality of given {@link IRandom}) PRNG.
 *
 * @remarks
 * Also see {@link fairCoin} and {@link IRandom.probability}.
 *
 * @param rnd -
 */
export declare const coin: (rnd?: IRandom) => boolean;
/**
 * Similar to {@link coin}, but more strict. Calls {@link coin} in a pairwise
 * manner as long as both results are equal (and discarding results). Otherwise
 * returns result of first call.
 *
 * @remarks
 * Reference:
 * https://en.m.wikipedia.org/wiki/Fair_coin#Fair_results_from_a_biased_coin
 *
 * @param rnd -
 */
export declare const fairCoin: (rnd?: IRandom) => boolean;
//# sourceMappingURL=coin.d.ts.map