import type { IRandom } from "../api.js";
/**
 * Higher order function. Returns no-arg function, yielding values in
 * exponential distribution based on given rate `lambda`.
 *
 * @remarks
 * https://en.wikipedia.org/wiki/Exponential_distribution
 *
 * @param rnd -
 * @param lambda - event interval [0,Inf)
 */
export declare const exponential: (rnd?: IRandom, lambda?: number) => () => number;
//# sourceMappingURL=exponential.d.ts.map