import type { IRandom } from "./api.js";
/**
 * Returns a random element from `src` using given {@link IRandom} instance
 * (default: {@link SYSTEM}). The index selection will be constrained to the
 * `[start,end)` interval (default: entire array).
 *
 * @param src -
 * @param rnd -
 * @param start -
 * @param end -
 */
export declare const pickRandom: <T>(src: ArrayLike<T>, rnd?: IRandom, start?: number, end?: number) => T;
/**
 * Returns a random key from given `object`.
 *
 * @param obj
 * @param rnd
 */
export declare const pickRandomKey: <T extends object>(obj: T, rnd?: IRandom) => keyof T;
//# sourceMappingURL=pick-random.d.ts.map