import type { IBuffered, ICopy } from "@thi.ng/api";
import type { ISeedable } from "./api.js";
import { ARandom } from "./arandom.js";
/**
 * @remarks
 * Reference: https://en.wikipedia.org/wiki/Xorshift
 */
export declare class XorShift128 extends ARandom implements IBuffered<Uint32Array>, ICopy<XorShift128>, ISeedable<ArrayLike<number>> {
    buffer: Uint32Array;
    constructor(seed?: ArrayLike<number>);
    copy(): XorShift128;
    bytes(): Uint8Array;
    seed(seed: ArrayLike<number>): this;
    int(): number;
}
//# sourceMappingURL=xorshift128.d.ts.map