import { ARandom } from "./arandom.js";
import { DEFAULT_SEED_160 } from "./constants.js";
class XorWow extends ARandom {
  buffer;
  constructor(seed = DEFAULT_SEED_160) {
    super();
    this.buffer = new Uint32Array(5);
    this.seed(seed);
  }
  copy() {
    return new XorWow(this.buffer);
  }
  seed(seed) {
    this.buffer.set(seed);
    return this;
  }
  bytes() {
    return new Uint8Array(this.buffer.buffer);
  }
  int() {
    const s = this.buffer;
    let t = s[3];
    let w;
    t ^= t >>> 2;
    t ^= t << 1;
    s[3] = s[2];
    s[2] = s[1];
    w = s[1] = s[0];
    t ^= w;
    t ^= w << 4;
    s[0] = t;
    return t + (s[4] += 362437) >>> 0;
  }
}
export {
  XorWow
};
