import type { IBuffered, ICopy } from "@thi.ng/api";
import type { ISeedable } from "./api.js";
import { ARandom } from "./arandom.js";
/**
 * @remarks
 * References:
 * - http://prng.di.unimi.it/
 * - http://prng.di.unimi.it/xoshiro128plusplus.c
 */
export declare class Xoshiro128 extends ARandom implements IBuffered<Uint32Array>, ICopy<Xoshiro128>, ISeedable<ArrayLike<number>> {
    buffer: Uint32Array;
    constructor(seed?: ArrayLike<number>);
    copy(): Xoshiro128;
    bytes(): Uint8Array;
    seed(seed: ArrayLike<number>): this;
    int(): number;
}
//# sourceMappingURL=xoshiro128.d.ts.map